/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterSubscriptionPricingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#id SecurityCenterSubscriptionPricing#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#resource_type SecurityCenterSubscriptionPricing#resource_type}
    */
    readonly resourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#subplan SecurityCenterSubscriptionPricing#subplan}
    */
    readonly subplan?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#tier SecurityCenterSubscriptionPricing#tier}
    */
    readonly tier: string;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#extension SecurityCenterSubscriptionPricing#extension}
    */
    readonly extension?: SecurityCenterSubscriptionPricingExtension[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#timeouts SecurityCenterSubscriptionPricing#timeouts}
    */
    readonly timeouts?: SecurityCenterSubscriptionPricingTimeouts;
}
export interface SecurityCenterSubscriptionPricingExtension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#additional_extension_properties SecurityCenterSubscriptionPricing#additional_extension_properties}
    */
    readonly additionalExtensionProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#name SecurityCenterSubscriptionPricing#name}
    */
    readonly name: string;
}
export declare function securityCenterSubscriptionPricingExtensionToTerraform(struct?: SecurityCenterSubscriptionPricingExtension | cdktf.IResolvable): any;
export declare function securityCenterSubscriptionPricingExtensionToHclTerraform(struct?: SecurityCenterSubscriptionPricingExtension | cdktf.IResolvable): any;
export declare class SecurityCenterSubscriptionPricingExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityCenterSubscriptionPricingExtension | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterSubscriptionPricingExtension | cdktf.IResolvable | undefined);
    private _additionalExtensionProperties?;
    get additionalExtensionProperties(): {
        [key: string]: string;
    };
    set additionalExtensionProperties(value: {
        [key: string]: string;
    });
    resetAdditionalExtensionProperties(): void;
    get additionalExtensionPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class SecurityCenterSubscriptionPricingExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityCenterSubscriptionPricingExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityCenterSubscriptionPricingExtensionOutputReference;
}
export interface SecurityCenterSubscriptionPricingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#create SecurityCenterSubscriptionPricing#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#delete SecurityCenterSubscriptionPricing#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#read SecurityCenterSubscriptionPricing#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#update SecurityCenterSubscriptionPricing#update}
    */
    readonly update?: string;
}
export declare function securityCenterSubscriptionPricingTimeoutsToTerraform(struct?: SecurityCenterSubscriptionPricingTimeouts | cdktf.IResolvable): any;
export declare function securityCenterSubscriptionPricingTimeoutsToHclTerraform(struct?: SecurityCenterSubscriptionPricingTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterSubscriptionPricingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterSubscriptionPricingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterSubscriptionPricingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing azurerm_security_center_subscription_pricing}
*/
export declare class SecurityCenterSubscriptionPricing extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_subscription_pricing";
    /**
    * Generates CDKTF code for importing a SecurityCenterSubscriptionPricing resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterSubscriptionPricing to import
    * @param importFromId The id of the existing SecurityCenterSubscriptionPricing that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterSubscriptionPricing to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/security_center_subscription_pricing azurerm_security_center_subscription_pricing} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterSubscriptionPricingConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterSubscriptionPricingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
    private _subplan?;
    get subplan(): string;
    set subplan(value: string);
    resetSubplan(): void;
    get subplanInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _extension;
    get extension(): SecurityCenterSubscriptionPricingExtensionList;
    putExtension(value: SecurityCenterSubscriptionPricingExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | SecurityCenterSubscriptionPricingExtension[] | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterSubscriptionPricingTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterSubscriptionPricingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterSubscriptionPricingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
