/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StackHciExtensionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#arc_setting_id StackHciExtension#arc_setting_id}
    */
    readonly arcSettingId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#auto_upgrade_minor_version_enabled StackHciExtension#auto_upgrade_minor_version_enabled}
    */
    readonly autoUpgradeMinorVersionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#automatic_upgrade_enabled StackHciExtension#automatic_upgrade_enabled}
    */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#id StackHciExtension#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#name StackHciExtension#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#protected_settings StackHciExtension#protected_settings}
    */
    readonly protectedSettings?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#publisher StackHciExtension#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#settings StackHciExtension#settings}
    */
    readonly settings?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#type StackHciExtension#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#type_handler_version StackHciExtension#type_handler_version}
    */
    readonly typeHandlerVersion?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#timeouts StackHciExtension#timeouts}
    */
    readonly timeouts?: StackHciExtensionTimeouts;
}
export interface StackHciExtensionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#create StackHciExtension#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#delete StackHciExtension#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#read StackHciExtension#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#update StackHciExtension#update}
    */
    readonly update?: string;
}
export declare function stackHciExtensionTimeoutsToTerraform(struct?: StackHciExtensionTimeouts | cdktf.IResolvable): any;
export declare function stackHciExtensionTimeoutsToHclTerraform(struct?: StackHciExtensionTimeouts | cdktf.IResolvable): any;
export declare class StackHciExtensionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciExtensionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciExtensionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension azurerm_stack_hci_extension}
*/
export declare class StackHciExtension extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stack_hci_extension";
    /**
    * Generates CDKTF code for importing a StackHciExtension resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StackHciExtension to import
    * @param importFromId The id of the existing StackHciExtension that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StackHciExtension to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/stack_hci_extension azurerm_stack_hci_extension} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StackHciExtensionConfig
    */
    constructor(scope: Construct, id: string, config: StackHciExtensionConfig);
    private _arcSettingId?;
    get arcSettingId(): string;
    set arcSettingId(value: string);
    get arcSettingIdInput(): string | undefined;
    private _autoUpgradeMinorVersionEnabled?;
    get autoUpgradeMinorVersionEnabled(): boolean | cdktf.IResolvable;
    set autoUpgradeMinorVersionEnabled(value: boolean | cdktf.IResolvable);
    resetAutoUpgradeMinorVersionEnabled(): void;
    get autoUpgradeMinorVersionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _automaticUpgradeEnabled?;
    get automaticUpgradeEnabled(): boolean | cdktf.IResolvable;
    set automaticUpgradeEnabled(value: boolean | cdktf.IResolvable);
    resetAutomaticUpgradeEnabled(): void;
    get automaticUpgradeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protectedSettings?;
    get protectedSettings(): string;
    set protectedSettings(value: string);
    resetProtectedSettings(): void;
    get protectedSettingsInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _settings?;
    get settings(): string;
    set settings(value: string);
    resetSettings(): void;
    get settingsInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeHandlerVersion?;
    get typeHandlerVersion(): string;
    set typeHandlerVersion(value: string);
    resetTypeHandlerVersion(): void;
    get typeHandlerVersionInput(): string | undefined;
    private _timeouts;
    get timeouts(): StackHciExtensionTimeoutsOutputReference;
    putTimeouts(value: StackHciExtensionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StackHciExtensionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
