/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDataLakeGen2PathConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#filesystem_name StorageDataLakeGen2Path#filesystem_name}
    */
    readonly filesystemName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#group StorageDataLakeGen2Path#group}
    */
    readonly group?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#id StorageDataLakeGen2Path#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#owner StorageDataLakeGen2Path#owner}
    */
    readonly owner?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#path StorageDataLakeGen2Path#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#resource StorageDataLakeGen2Path#resource}
    */
    readonly resource: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#storage_account_id StorageDataLakeGen2Path#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * ace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#ace StorageDataLakeGen2Path#ace}
    */
    readonly ace?: StorageDataLakeGen2PathAce[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#timeouts StorageDataLakeGen2Path#timeouts}
    */
    readonly timeouts?: StorageDataLakeGen2PathTimeouts;
}
export interface StorageDataLakeGen2PathAce {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#id StorageDataLakeGen2Path#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#permissions StorageDataLakeGen2Path#permissions}
    */
    readonly permissions: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#scope StorageDataLakeGen2Path#scope}
    */
    readonly scope?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#type StorageDataLakeGen2Path#type}
    */
    readonly type: string;
}
export declare function storageDataLakeGen2PathAceToTerraform(struct?: StorageDataLakeGen2PathAce | cdktf.IResolvable): any;
export declare function storageDataLakeGen2PathAceToHclTerraform(struct?: StorageDataLakeGen2PathAce | cdktf.IResolvable): any;
export declare class StorageDataLakeGen2PathAceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDataLakeGen2PathAce | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDataLakeGen2PathAce | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    get permissionsInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class StorageDataLakeGen2PathAceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDataLakeGen2PathAce[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDataLakeGen2PathAceOutputReference;
}
export interface StorageDataLakeGen2PathTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#create StorageDataLakeGen2Path#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#delete StorageDataLakeGen2Path#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#read StorageDataLakeGen2Path#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#update StorageDataLakeGen2Path#update}
    */
    readonly update?: string;
}
export declare function storageDataLakeGen2PathTimeoutsToTerraform(struct?: StorageDataLakeGen2PathTimeouts | cdktf.IResolvable): any;
export declare function storageDataLakeGen2PathTimeoutsToHclTerraform(struct?: StorageDataLakeGen2PathTimeouts | cdktf.IResolvable): any;
export declare class StorageDataLakeGen2PathTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageDataLakeGen2PathTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDataLakeGen2PathTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path azurerm_storage_data_lake_gen2_path}
*/
export declare class StorageDataLakeGen2Path extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_data_lake_gen2_path";
    /**
    * Generates CDKTF code for importing a StorageDataLakeGen2Path resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageDataLakeGen2Path to import
    * @param importFromId The id of the existing StorageDataLakeGen2Path that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageDataLakeGen2Path to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/storage_data_lake_gen2_path azurerm_storage_data_lake_gen2_path} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDataLakeGen2PathConfig
    */
    constructor(scope: Construct, id: string, config: StorageDataLakeGen2PathConfig);
    private _filesystemName?;
    get filesystemName(): string;
    set filesystemName(value: string);
    get filesystemNameInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _ace;
    get ace(): StorageDataLakeGen2PathAceList;
    putAce(value: StorageDataLakeGen2PathAce[] | cdktf.IResolvable): void;
    resetAce(): void;
    get aceInput(): cdktf.IResolvable | StorageDataLakeGen2PathAce[] | undefined;
    private _timeouts;
    get timeouts(): StorageDataLakeGen2PathTimeoutsOutputReference;
    putTimeouts(value: StorageDataLakeGen2PathTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageDataLakeGen2PathTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
