/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubscriptionCostManagementViewConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#accumulated SubscriptionCostManagementView#accumulated}
    */
    readonly accumulated: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#chart_type SubscriptionCostManagementView#chart_type}
    */
    readonly chartType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#display_name SubscriptionCostManagementView#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#id SubscriptionCostManagementView#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#name SubscriptionCostManagementView#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#report_type SubscriptionCostManagementView#report_type}
    */
    readonly reportType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#subscription_id SubscriptionCostManagementView#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#timeframe SubscriptionCostManagementView#timeframe}
    */
    readonly timeframe: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#dataset SubscriptionCostManagementView#dataset}
    */
    readonly dataset: SubscriptionCostManagementViewDataset;
    /**
    * kpi block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#kpi SubscriptionCostManagementView#kpi}
    */
    readonly kpi?: SubscriptionCostManagementViewKpi[] | cdktf.IResolvable;
    /**
    * pivot block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#pivot SubscriptionCostManagementView#pivot}
    */
    readonly pivot?: SubscriptionCostManagementViewPivot[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#timeouts SubscriptionCostManagementView#timeouts}
    */
    readonly timeouts?: SubscriptionCostManagementViewTimeouts;
}
export interface SubscriptionCostManagementViewDatasetAggregation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#column_name SubscriptionCostManagementView#column_name}
    */
    readonly columnName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#name SubscriptionCostManagementView#name}
    */
    readonly name: string;
}
export declare function subscriptionCostManagementViewDatasetAggregationToTerraform(struct?: SubscriptionCostManagementViewDatasetAggregation | cdktf.IResolvable): any;
export declare function subscriptionCostManagementViewDatasetAggregationToHclTerraform(struct?: SubscriptionCostManagementViewDatasetAggregation | cdktf.IResolvable): any;
export declare class SubscriptionCostManagementViewDatasetAggregationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionCostManagementViewDatasetAggregation | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionCostManagementViewDatasetAggregation | cdktf.IResolvable | undefined);
    private _columnName?;
    get columnName(): string;
    set columnName(value: string);
    get columnNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class SubscriptionCostManagementViewDatasetAggregationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionCostManagementViewDatasetAggregation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionCostManagementViewDatasetAggregationOutputReference;
}
export interface SubscriptionCostManagementViewDatasetGrouping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#name SubscriptionCostManagementView#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#type SubscriptionCostManagementView#type}
    */
    readonly type: string;
}
export declare function subscriptionCostManagementViewDatasetGroupingToTerraform(struct?: SubscriptionCostManagementViewDatasetGrouping | cdktf.IResolvable): any;
export declare function subscriptionCostManagementViewDatasetGroupingToHclTerraform(struct?: SubscriptionCostManagementViewDatasetGrouping | cdktf.IResolvable): any;
export declare class SubscriptionCostManagementViewDatasetGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionCostManagementViewDatasetGrouping | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionCostManagementViewDatasetGrouping | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SubscriptionCostManagementViewDatasetGroupingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionCostManagementViewDatasetGrouping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionCostManagementViewDatasetGroupingOutputReference;
}
export interface SubscriptionCostManagementViewDatasetSorting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#direction SubscriptionCostManagementView#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#name SubscriptionCostManagementView#name}
    */
    readonly name: string;
}
export declare function subscriptionCostManagementViewDatasetSortingToTerraform(struct?: SubscriptionCostManagementViewDatasetSorting | cdktf.IResolvable): any;
export declare function subscriptionCostManagementViewDatasetSortingToHclTerraform(struct?: SubscriptionCostManagementViewDatasetSorting | cdktf.IResolvable): any;
export declare class SubscriptionCostManagementViewDatasetSortingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionCostManagementViewDatasetSorting | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionCostManagementViewDatasetSorting | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class SubscriptionCostManagementViewDatasetSortingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionCostManagementViewDatasetSorting[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionCostManagementViewDatasetSortingOutputReference;
}
export interface SubscriptionCostManagementViewDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#granularity SubscriptionCostManagementView#granularity}
    */
    readonly granularity: string;
    /**
    * aggregation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#aggregation SubscriptionCostManagementView#aggregation}
    */
    readonly aggregation: SubscriptionCostManagementViewDatasetAggregation[] | cdktf.IResolvable;
    /**
    * grouping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#grouping SubscriptionCostManagementView#grouping}
    */
    readonly grouping?: SubscriptionCostManagementViewDatasetGrouping[] | cdktf.IResolvable;
    /**
    * sorting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#sorting SubscriptionCostManagementView#sorting}
    */
    readonly sorting?: SubscriptionCostManagementViewDatasetSorting[] | cdktf.IResolvable;
}
export declare function subscriptionCostManagementViewDatasetToTerraform(struct?: SubscriptionCostManagementViewDatasetOutputReference | SubscriptionCostManagementViewDataset): any;
export declare function subscriptionCostManagementViewDatasetToHclTerraform(struct?: SubscriptionCostManagementViewDatasetOutputReference | SubscriptionCostManagementViewDataset): any;
export declare class SubscriptionCostManagementViewDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionCostManagementViewDataset | undefined;
    set internalValue(value: SubscriptionCostManagementViewDataset | undefined);
    private _granularity?;
    get granularity(): string;
    set granularity(value: string);
    get granularityInput(): string | undefined;
    private _aggregation;
    get aggregation(): SubscriptionCostManagementViewDatasetAggregationList;
    putAggregation(value: SubscriptionCostManagementViewDatasetAggregation[] | cdktf.IResolvable): void;
    get aggregationInput(): cdktf.IResolvable | SubscriptionCostManagementViewDatasetAggregation[] | undefined;
    private _grouping;
    get grouping(): SubscriptionCostManagementViewDatasetGroupingList;
    putGrouping(value: SubscriptionCostManagementViewDatasetGrouping[] | cdktf.IResolvable): void;
    resetGrouping(): void;
    get groupingInput(): cdktf.IResolvable | SubscriptionCostManagementViewDatasetGrouping[] | undefined;
    private _sorting;
    get sorting(): SubscriptionCostManagementViewDatasetSortingList;
    putSorting(value: SubscriptionCostManagementViewDatasetSorting[] | cdktf.IResolvable): void;
    resetSorting(): void;
    get sortingInput(): cdktf.IResolvable | SubscriptionCostManagementViewDatasetSorting[] | undefined;
}
export interface SubscriptionCostManagementViewKpi {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#type SubscriptionCostManagementView#type}
    */
    readonly type: string;
}
export declare function subscriptionCostManagementViewKpiToTerraform(struct?: SubscriptionCostManagementViewKpi | cdktf.IResolvable): any;
export declare function subscriptionCostManagementViewKpiToHclTerraform(struct?: SubscriptionCostManagementViewKpi | cdktf.IResolvable): any;
export declare class SubscriptionCostManagementViewKpiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionCostManagementViewKpi | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionCostManagementViewKpi | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SubscriptionCostManagementViewKpiList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionCostManagementViewKpi[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionCostManagementViewKpiOutputReference;
}
export interface SubscriptionCostManagementViewPivot {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#name SubscriptionCostManagementView#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#type SubscriptionCostManagementView#type}
    */
    readonly type: string;
}
export declare function subscriptionCostManagementViewPivotToTerraform(struct?: SubscriptionCostManagementViewPivot | cdktf.IResolvable): any;
export declare function subscriptionCostManagementViewPivotToHclTerraform(struct?: SubscriptionCostManagementViewPivot | cdktf.IResolvable): any;
export declare class SubscriptionCostManagementViewPivotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionCostManagementViewPivot | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionCostManagementViewPivot | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SubscriptionCostManagementViewPivotList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionCostManagementViewPivot[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionCostManagementViewPivotOutputReference;
}
export interface SubscriptionCostManagementViewTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#create SubscriptionCostManagementView#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#delete SubscriptionCostManagementView#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#read SubscriptionCostManagementView#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#update SubscriptionCostManagementView#update}
    */
    readonly update?: string;
}
export declare function subscriptionCostManagementViewTimeoutsToTerraform(struct?: SubscriptionCostManagementViewTimeouts | cdktf.IResolvable): any;
export declare function subscriptionCostManagementViewTimeoutsToHclTerraform(struct?: SubscriptionCostManagementViewTimeouts | cdktf.IResolvable): any;
export declare class SubscriptionCostManagementViewTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionCostManagementViewTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionCostManagementViewTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view azurerm_subscription_cost_management_view}
*/
export declare class SubscriptionCostManagementView extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subscription_cost_management_view";
    /**
    * Generates CDKTF code for importing a SubscriptionCostManagementView resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SubscriptionCostManagementView to import
    * @param importFromId The id of the existing SubscriptionCostManagementView that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SubscriptionCostManagementView to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/subscription_cost_management_view azurerm_subscription_cost_management_view} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubscriptionCostManagementViewConfig
    */
    constructor(scope: Construct, id: string, config: SubscriptionCostManagementViewConfig);
    private _accumulated?;
    get accumulated(): boolean | cdktf.IResolvable;
    set accumulated(value: boolean | cdktf.IResolvable);
    get accumulatedInput(): boolean | cdktf.IResolvable | undefined;
    private _chartType?;
    get chartType(): string;
    set chartType(value: string);
    get chartTypeInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _reportType?;
    get reportType(): string;
    set reportType(value: string);
    get reportTypeInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    get timeframeInput(): string | undefined;
    private _dataset;
    get dataset(): SubscriptionCostManagementViewDatasetOutputReference;
    putDataset(value: SubscriptionCostManagementViewDataset): void;
    get datasetInput(): SubscriptionCostManagementViewDataset | undefined;
    private _kpi;
    get kpi(): SubscriptionCostManagementViewKpiList;
    putKpi(value: SubscriptionCostManagementViewKpi[] | cdktf.IResolvable): void;
    resetKpi(): void;
    get kpiInput(): cdktf.IResolvable | SubscriptionCostManagementViewKpi[] | undefined;
    private _pivot;
    get pivot(): SubscriptionCostManagementViewPivotList;
    putPivot(value: SubscriptionCostManagementViewPivot[] | cdktf.IResolvable): void;
    resetPivot(): void;
    get pivotInput(): cdktf.IResolvable | SubscriptionCostManagementViewPivot[] | undefined;
    private _timeouts;
    get timeouts(): SubscriptionCostManagementViewTimeoutsOutputReference;
    putTimeouts(value: SubscriptionCostManagementViewTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SubscriptionCostManagementViewTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
