/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebAppHybridConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The hostname of the endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#hostname WebAppHybridConnection#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#id WebAppHybridConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The port to use for the endpoint
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#port WebAppHybridConnection#port}
    */
    readonly port: number;
    /**
    * The ID of the Relay Hybrid Connection to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#relay_id WebAppHybridConnection#relay_id}
    */
    readonly relayId: string;
    /**
    * The name of the Relay key with `Send` permission to use. Defaults to `RootManageSharedAccessKey`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#send_key_name WebAppHybridConnection#send_key_name}
    */
    readonly sendKeyName?: string;
    /**
    * The ID of the Web App for this Hybrid Connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#web_app_id WebAppHybridConnection#web_app_id}
    */
    readonly webAppId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#timeouts WebAppHybridConnection#timeouts}
    */
    readonly timeouts?: WebAppHybridConnectionTimeouts;
}
export interface WebAppHybridConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#create WebAppHybridConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#delete WebAppHybridConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#read WebAppHybridConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#update WebAppHybridConnection#update}
    */
    readonly update?: string;
}
export declare function webAppHybridConnectionTimeoutsToTerraform(struct?: WebAppHybridConnectionTimeouts | cdktf.IResolvable): any;
export declare function webAppHybridConnectionTimeoutsToHclTerraform(struct?: WebAppHybridConnectionTimeouts | cdktf.IResolvable): any;
export declare class WebAppHybridConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebAppHybridConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WebAppHybridConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection azurerm_web_app_hybrid_connection}
*/
export declare class WebAppHybridConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_web_app_hybrid_connection";
    /**
    * Generates CDKTF code for importing a WebAppHybridConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WebAppHybridConnection to import
    * @param importFromId The id of the existing WebAppHybridConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WebAppHybridConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/web_app_hybrid_connection azurerm_web_app_hybrid_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebAppHybridConnectionConfig
    */
    constructor(scope: Construct, id: string, config: WebAppHybridConnectionConfig);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get namespaceName(): string;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _relayId?;
    get relayId(): string;
    set relayId(value: string);
    get relayIdInput(): string | undefined;
    get relayName(): string;
    private _sendKeyName?;
    get sendKeyName(): string;
    set sendKeyName(value: string);
    resetSendKeyName(): void;
    get sendKeyNameInput(): string | undefined;
    get sendKeyValue(): string;
    get serviceBusNamespace(): string;
    get serviceBusSuffix(): string;
    private _webAppId?;
    get webAppId(): string;
    set webAppId(value: string);
    get webAppIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): WebAppHybridConnectionTimeoutsOutputReference;
    putTimeouts(value: WebAppHybridConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WebAppHybridConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
