/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WorkloadsSapSingleNodeVirtualInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#app_location WorkloadsSapSingleNodeVirtualInstance#app_location}
    */
    readonly appLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#environment WorkloadsSapSingleNodeVirtualInstance#environment}
    */
    readonly environment: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#id WorkloadsSapSingleNodeVirtualInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#location WorkloadsSapSingleNodeVirtualInstance#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#managed_resource_group_name WorkloadsSapSingleNodeVirtualInstance#managed_resource_group_name}
    */
    readonly managedResourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#managed_resources_network_access_type WorkloadsSapSingleNodeVirtualInstance#managed_resources_network_access_type}
    */
    readonly managedResourcesNetworkAccessType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#name WorkloadsSapSingleNodeVirtualInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#resource_group_name WorkloadsSapSingleNodeVirtualInstance#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#sap_fqdn WorkloadsSapSingleNodeVirtualInstance#sap_fqdn}
    */
    readonly sapFqdn: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#sap_product WorkloadsSapSingleNodeVirtualInstance#sap_product}
    */
    readonly sapProduct: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#tags WorkloadsSapSingleNodeVirtualInstance#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#identity WorkloadsSapSingleNodeVirtualInstance#identity}
    */
    readonly identity?: WorkloadsSapSingleNodeVirtualInstanceIdentity;
    /**
    * single_server_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#single_server_configuration WorkloadsSapSingleNodeVirtualInstance#single_server_configuration}
    */
    readonly singleServerConfiguration: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#timeouts WorkloadsSapSingleNodeVirtualInstance#timeouts}
    */
    readonly timeouts?: WorkloadsSapSingleNodeVirtualInstanceTimeouts;
}
export interface WorkloadsSapSingleNodeVirtualInstanceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#identity_ids WorkloadsSapSingleNodeVirtualInstance#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#type WorkloadsSapSingleNodeVirtualInstance#type}
    */
    readonly type: string;
}
export declare function workloadsSapSingleNodeVirtualInstanceIdentityToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceIdentityOutputReference | WorkloadsSapSingleNodeVirtualInstanceIdentity): any;
export declare function workloadsSapSingleNodeVirtualInstanceIdentityToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceIdentityOutputReference | WorkloadsSapSingleNodeVirtualInstanceIdentity): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceIdentity | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#number_of_disks WorkloadsSapSingleNodeVirtualInstance#number_of_disks}
    */
    readonly numberOfDisks: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#size_in_gb WorkloadsSapSingleNodeVirtualInstance#size_in_gb}
    */
    readonly sizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#sku_name WorkloadsSapSingleNodeVirtualInstance#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#volume_name WorkloadsSapSingleNodeVirtualInstance#volume_name}
    */
    readonly volumeName: string;
}
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfigurationToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration | cdktf.IResolvable): any;
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfigurationToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration | cdktf.IResolvable): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration | cdktf.IResolvable | undefined);
    private _numberOfDisks?;
    get numberOfDisks(): number;
    set numberOfDisks(value: number);
    get numberOfDisksInput(): number | undefined;
    private _sizeInGb?;
    get sizeInGb(): number;
    set sizeInGb(value: number);
    get sizeInGbInput(): number | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _volumeName?;
    get volumeName(): string;
    set volumeName(value: string);
    get volumeNameInput(): string | undefined;
}
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfigurationOutputReference;
}
export interface WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#offer WorkloadsSapSingleNodeVirtualInstance#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#publisher WorkloadsSapSingleNodeVirtualInstance#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#sku WorkloadsSapSingleNodeVirtualInstance#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#version WorkloadsSapSingleNodeVirtualInstance#version}
    */
    readonly version: string;
}
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImageToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImageOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage): any;
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImageToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImageOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#admin_username WorkloadsSapSingleNodeVirtualInstance#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#ssh_private_key WorkloadsSapSingleNodeVirtualInstance#ssh_private_key}
    */
    readonly sshPrivateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#ssh_public_key WorkloadsSapSingleNodeVirtualInstance#ssh_public_key}
    */
    readonly sshPublicKey: string;
}
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfileToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfileOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile): any;
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfileToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfileOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile | undefined);
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _sshPrivateKey?;
    get sshPrivateKey(): string;
    set sshPrivateKey(value: string);
    get sshPrivateKeyInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    get sshPublicKeyInput(): string | undefined;
}
export interface WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#virtual_machine_size WorkloadsSapSingleNodeVirtualInstance#virtual_machine_size}
    */
    readonly virtualMachineSize: string;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#image WorkloadsSapSingleNodeVirtualInstance#image}
    */
    readonly image: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage;
    /**
    * os_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#os_profile WorkloadsSapSingleNodeVirtualInstance#os_profile}
    */
    readonly osProfile: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile;
}
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration): any;
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration | undefined);
    private _virtualMachineSize?;
    get virtualMachineSize(): string;
    set virtualMachineSize(value: string);
    get virtualMachineSizeInput(): string | undefined;
    private _image;
    get image(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImageOutputReference;
    putImage(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage): void;
    get imageInput(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationImage | undefined;
    private _osProfile;
    get osProfile(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfileOutputReference;
    putOsProfile(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile): void;
    get osProfileInput(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOsProfile | undefined;
}
export interface WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#names WorkloadsSapSingleNodeVirtualInstance#names}
    */
    readonly names: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#volume_name WorkloadsSapSingleNodeVirtualInstance#volume_name}
    */
    readonly volumeName: string;
}
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDiskToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk | cdktf.IResolvable): any;
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDiskToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk | cdktf.IResolvable): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk | cdktf.IResolvable | undefined);
    private _names?;
    get names(): string[];
    set names(value: string[]);
    get namesInput(): string[] | undefined;
    private _volumeName?;
    get volumeName(): string;
    set volumeName(value: string);
    get volumeNameInput(): string | undefined;
}
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDiskOutputReference;
}
export interface WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#host_name WorkloadsSapSingleNodeVirtualInstance#host_name}
    */
    readonly hostName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#network_interface_names WorkloadsSapSingleNodeVirtualInstance#network_interface_names}
    */
    readonly networkInterfaceNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#os_disk_name WorkloadsSapSingleNodeVirtualInstance#os_disk_name}
    */
    readonly osDiskName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#virtual_machine_name WorkloadsSapSingleNodeVirtualInstance#virtual_machine_name}
    */
    readonly virtualMachineName?: string;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#data_disk WorkloadsSapSingleNodeVirtualInstance#data_disk}
    */
    readonly dataDisk?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk[] | cdktf.IResolvable;
}
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames): any;
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames | undefined);
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    resetHostName(): void;
    get hostNameInput(): string | undefined;
    private _networkInterfaceNames?;
    get networkInterfaceNames(): string[];
    set networkInterfaceNames(value: string[]);
    resetNetworkInterfaceNames(): void;
    get networkInterfaceNamesInput(): string[] | undefined;
    private _osDiskName?;
    get osDiskName(): string;
    set osDiskName(value: string);
    resetOsDiskName(): void;
    get osDiskNameInput(): string | undefined;
    private _virtualMachineName?;
    get virtualMachineName(): string;
    set virtualMachineName(value: string);
    resetVirtualMachineName(): void;
    get virtualMachineNameInput(): string | undefined;
    private _dataDisk;
    get dataDisk(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDiskList;
    putDataDisk(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk[] | cdktf.IResolvable): void;
    resetDataDisk(): void;
    get dataDiskInput(): cdktf.IResolvable | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesDataDisk[] | undefined;
}
export interface WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#app_resource_group_name WorkloadsSapSingleNodeVirtualInstance#app_resource_group_name}
    */
    readonly appResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#database_type WorkloadsSapSingleNodeVirtualInstance#database_type}
    */
    readonly databaseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#secondary_ip_enabled WorkloadsSapSingleNodeVirtualInstance#secondary_ip_enabled}
    */
    readonly secondaryIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#subnet_id WorkloadsSapSingleNodeVirtualInstance#subnet_id}
    */
    readonly subnetId: string;
    /**
    * disk_volume_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#disk_volume_configuration WorkloadsSapSingleNodeVirtualInstance#disk_volume_configuration}
    */
    readonly diskVolumeConfiguration?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration[] | cdktf.IResolvable;
    /**
    * virtual_machine_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#virtual_machine_configuration WorkloadsSapSingleNodeVirtualInstance#virtual_machine_configuration}
    */
    readonly virtualMachineConfiguration: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration;
    /**
    * virtual_machine_resource_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#virtual_machine_resource_names WorkloadsSapSingleNodeVirtualInstance#virtual_machine_resource_names}
    */
    readonly virtualMachineResourceNames?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames;
}
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration): any;
export declare function workloadsSapSingleNodeVirtualInstanceSingleServerConfigurationToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationOutputReference | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration | undefined);
    private _appResourceGroupName?;
    get appResourceGroupName(): string;
    set appResourceGroupName(value: string);
    get appResourceGroupNameInput(): string | undefined;
    private _databaseType?;
    get databaseType(): string;
    set databaseType(value: string);
    resetDatabaseType(): void;
    get databaseTypeInput(): string | undefined;
    private _secondaryIpEnabled?;
    get secondaryIpEnabled(): boolean | cdktf.IResolvable;
    set secondaryIpEnabled(value: boolean | cdktf.IResolvable);
    resetSecondaryIpEnabled(): void;
    get secondaryIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _diskVolumeConfiguration;
    get diskVolumeConfiguration(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfigurationList;
    putDiskVolumeConfiguration(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration[] | cdktf.IResolvable): void;
    resetDiskVolumeConfiguration(): void;
    get diskVolumeConfigurationInput(): cdktf.IResolvable | WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationDiskVolumeConfiguration[] | undefined;
    private _virtualMachineConfiguration;
    get virtualMachineConfiguration(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfigurationOutputReference;
    putVirtualMachineConfiguration(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration): void;
    get virtualMachineConfigurationInput(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineConfiguration | undefined;
    private _virtualMachineResourceNames;
    get virtualMachineResourceNames(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNamesOutputReference;
    putVirtualMachineResourceNames(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames): void;
    resetVirtualMachineResourceNames(): void;
    get virtualMachineResourceNamesInput(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationVirtualMachineResourceNames | undefined;
}
export interface WorkloadsSapSingleNodeVirtualInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#create WorkloadsSapSingleNodeVirtualInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#delete WorkloadsSapSingleNodeVirtualInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#read WorkloadsSapSingleNodeVirtualInstance#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#update WorkloadsSapSingleNodeVirtualInstance#update}
    */
    readonly update?: string;
}
export declare function workloadsSapSingleNodeVirtualInstanceTimeoutsToTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceTimeouts | cdktf.IResolvable): any;
export declare function workloadsSapSingleNodeVirtualInstanceTimeoutsToHclTerraform(struct?: WorkloadsSapSingleNodeVirtualInstanceTimeouts | cdktf.IResolvable): any;
export declare class WorkloadsSapSingleNodeVirtualInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WorkloadsSapSingleNodeVirtualInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WorkloadsSapSingleNodeVirtualInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance azurerm_workloads_sap_single_node_virtual_instance}
*/
export declare class WorkloadsSapSingleNodeVirtualInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_workloads_sap_single_node_virtual_instance";
    /**
    * Generates CDKTF code for importing a WorkloadsSapSingleNodeVirtualInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WorkloadsSapSingleNodeVirtualInstance to import
    * @param importFromId The id of the existing WorkloadsSapSingleNodeVirtualInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WorkloadsSapSingleNodeVirtualInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/workloads_sap_single_node_virtual_instance azurerm_workloads_sap_single_node_virtual_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkloadsSapSingleNodeVirtualInstanceConfig
    */
    constructor(scope: Construct, id: string, config: WorkloadsSapSingleNodeVirtualInstanceConfig);
    private _appLocation?;
    get appLocation(): string;
    set appLocation(value: string);
    get appLocationInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedResourceGroupName?;
    get managedResourceGroupName(): string;
    set managedResourceGroupName(value: string);
    resetManagedResourceGroupName(): void;
    get managedResourceGroupNameInput(): string | undefined;
    private _managedResourcesNetworkAccessType?;
    get managedResourcesNetworkAccessType(): string;
    set managedResourcesNetworkAccessType(value: string);
    resetManagedResourcesNetworkAccessType(): void;
    get managedResourcesNetworkAccessTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sapFqdn?;
    get sapFqdn(): string;
    set sapFqdn(value: string);
    get sapFqdnInput(): string | undefined;
    private _sapProduct?;
    get sapProduct(): string;
    set sapProduct(value: string);
    get sapProductInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): WorkloadsSapSingleNodeVirtualInstanceIdentityOutputReference;
    putIdentity(value: WorkloadsSapSingleNodeVirtualInstanceIdentity): void;
    resetIdentity(): void;
    get identityInput(): WorkloadsSapSingleNodeVirtualInstanceIdentity | undefined;
    private _singleServerConfiguration;
    get singleServerConfiguration(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfigurationOutputReference;
    putSingleServerConfiguration(value: WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration): void;
    get singleServerConfigurationInput(): WorkloadsSapSingleNodeVirtualInstanceSingleServerConfiguration | undefined;
    private _timeouts;
    get timeouts(): WorkloadsSapSingleNodeVirtualInstanceTimeoutsOutputReference;
    putTimeouts(value: WorkloadsSapSingleNodeVirtualInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WorkloadsSapSingleNodeVirtualInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
