/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.util.filter.Filter;

public final class ResolveReport {
    private Map confReports = new LinkedHashMap();
    private List problemMessages = new ArrayList();
    private List dependencies = new ArrayList();
    private List artifacts = new ArrayList();
    private long resolveTime;
    private long downloadTime;
    private String resolveId;
    private long downloadSize;

    public ResolveReport(String string) {
        this.resolveId = string;
    }

    public final void addReport(String string, ConfigurationResolveReport configurationResolveReport) {
        this.confReports.put(string, configurationResolveReport);
    }

    public final ConfigurationResolveReport getConfigurationReport(String string) {
        return (ConfigurationResolveReport)this.confReports.get(string);
    }

    public final String[] getConfigurations() {
        return this.confReports.keySet().toArray(new String[this.confReports.size()]);
    }

    public final boolean hasError() {
        boolean bl;
        ConfigurationResolveReport configurationResolveReport;
        Iterator iterator = this.confReports.values().iterator();
        for (bl = false; iterator.hasNext() && !bl; bl |= configurationResolveReport.hasError()) {
            configurationResolveReport = (ConfigurationResolveReport)iterator.next();
        }
        return bl;
    }

    public final void output(ReportOutputter[] reportOutputterArray, ResolutionCacheManager resolutionCacheManager, ResolveOptions resolveOptions) {
        for (int i = 0; i < reportOutputterArray.length; ++i) {
            reportOutputterArray[i].output(this, resolutionCacheManager, resolveOptions);
        }
    }

    public final IvyNode[] getEvictedNodes() {
        LinkedHashSet<IvyNode> linkedHashSet = new LinkedHashSet<IvyNode>();
        Iterator iterator = this.confReports.values().iterator();
        while (iterator.hasNext()) {
            ConfigurationResolveReport configurationResolveReport = (ConfigurationResolveReport)iterator.next();
            linkedHashSet.addAll(Arrays.asList(configurationResolveReport.getEvictedNodes()));
        }
        return linkedHashSet.toArray(new IvyNode[linkedHashSet.size()]);
    }

    public final IvyNode[] getUnresolvedDependencies() {
        LinkedHashSet<IvyNode> linkedHashSet = new LinkedHashSet<IvyNode>();
        Iterator iterator = this.confReports.values().iterator();
        while (iterator.hasNext()) {
            ConfigurationResolveReport configurationResolveReport = (ConfigurationResolveReport)iterator.next();
            linkedHashSet.addAll(Arrays.asList(configurationResolveReport.getUnresolvedDependencies()));
        }
        return linkedHashSet.toArray(new IvyNode[linkedHashSet.size()]);
    }

    public final ArtifactDownloadReport[] getFailedArtifactsReports() {
        DownloadStatus downloadStatus = DownloadStatus.FAILED;
        ResolveReport resolveReport = this;
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
        Iterator iterator = resolveReport.confReports.values().iterator();
        while (iterator.hasNext()) {
            ArtifactDownloadReport[] artifactDownloadReportArray = ((ConfigurationResolveReport)iterator.next()).getArtifactsReports(downloadStatus, true);
            linkedHashSet.addAll(Arrays.asList(artifactDownloadReportArray));
        }
        return ConfigurationResolveReport.filterOutMergedArtifacts(linkedHashSet.toArray(new ArtifactDownloadReport[linkedHashSet.size()]));
    }

    public final void checkIfChanged() {
        Iterator iterator = this.confReports.values().iterator();
        while (iterator.hasNext()) {
            ((ConfigurationResolveReport)iterator.next()).checkIfChanged();
        }
    }

    public final void setProblemMessages(List list) {
        this.problemMessages = list;
    }

    public final List getAllProblemMessages() {
        ArrayList<String> arrayList = new ArrayList<String>(this.problemMessages);
        Iterator iterator = this.confReports.values().iterator();
        while (iterator.hasNext()) {
            ConfigurationResolveReport configurationResolveReport = (ConfigurationResolveReport)iterator.next();
            IvyNode[] ivyNodeArray = configurationResolveReport.getUnresolvedDependencies();
            for (int i = 0; i < ivyNodeArray.length; ++i) {
                String string = ivyNodeArray[i].getProblemMessage();
                if (string.length() > 0) {
                    arrayList.add("unresolved dependency: " + ivyNodeArray[i].getId() + ": " + string);
                    continue;
                }
                arrayList.add("unresolved dependency: " + ivyNodeArray[i].getId());
            }
            ArtifactDownloadReport[] artifactDownloadReportArray = configurationResolveReport.getFailedArtifactsReports();
            for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
                arrayList.add("download failed: " + artifactDownloadReportArray[i].getArtifact());
            }
        }
        return arrayList;
    }

    public final void setDependencies(List list, Filter filter2) {
        this.dependencies = list;
        this.artifacts = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)iterator.next();
            if (!ivyNode.isCompletelyEvicted() && !ivyNode.hasProblem()) {
                this.artifacts.addAll(Arrays.asList(ivyNode.getSelectedArtifacts(filter2)));
            }
            String[] stringArray = ivyNode.getRootModuleConfigurations();
            for (int i = 0; i < stringArray.length; ++i) {
                ConfigurationResolveReport configurationResolveReport = this.getConfigurationReport(stringArray[i]);
                if (configurationResolveReport == null) continue;
                configurationResolveReport.addDependency(ivyNode);
            }
        }
    }

    public final List getDependencies() {
        return this.dependencies;
    }

    public final List getArtifacts() {
        return this.artifacts;
    }

    public final void setResolveTime(long l) {
        this.resolveTime = l;
    }

    public final long getResolveTime() {
        return this.resolveTime;
    }

    public final void setDownloadTime(long l) {
        this.downloadTime = l;
    }

    public final long getDownloadTime() {
        return this.downloadTime;
    }

    public final void setDownloadSize(long l) {
        this.downloadSize = l;
    }

    public final long getDownloadSize() {
        return this.downloadSize;
    }

    public final String getResolveId() {
        return this.resolveId;
    }
}

