
# Mass-Analytics: Data Preparation Made Easy

[![PyPI Version](https://img.shields.io/pypi/v/mass-analytics.svg)](https://pypi.org/project/mass-analytics/)
[![Python Versions](https://img.shields.io/pypi/pyversions/mass-analytics.svg)](https://pypi.org/project/mass-analytics/)

## Overview

Mass-Analytics is a Python package designed to streamline the data preparation process. It provides a set of useful functions that simplify common data preparation tasks, making it easier for data scientists and analysts to get their data ready for analysis and modeling.

## Key Features

- Read data from various sources and formats.
- Perform data cleaning and preprocessing.
- Handle missing data effectively.
- Feature engineering and transformation.
- Simplify data transformation pipelines.

## Installation

You can install `mass-analytics` using `pip`.

```sh
pip install mass-analytics
```

## Usage

Import the `mass-analytics` package as `ma` and use its functions for data preparation tasks.

```python
import mass_analytics as ma

# Read data from a file
data_frame = ma.read_data("path/to/your/data.csv")

# Display data
print(data_frame)
```

## Authors

- Mejdi Trabelsi
- Mohamed Selim Alouini

## Project Status

The project is currently in development. We are actively working on adding more features and improving the existing ones. Your feedback and contributions are highly appreciated!