# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from crc-pulpcore-client.models.paginated_repository_response_list import PaginatedRepositoryResponseList

from crc-pulpcore-client.api_client import ApiClient, RequestSerialized
from crc-pulpcore-client.api_response import ApiResponse
from crc-pulpcore-client.rest import RESTResponseType


class RepositoriesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def list(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        latest_with_content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__iregex: Annotated[Optional[StrictStr], Field(description="Filter results where name matches regex value")] = None,
        name__istartswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        name__regex: Annotated[Optional[StrictStr], Field(description="Filter results where name matches regex value")] = None,
        name__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        pulp_type: Annotated[Optional[StrictStr], Field(description="Pulp type  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file")] = None,
        pulp_type__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        remote: Annotated[Optional[StrictStr], Field(description="Foreign Key referenced by HREF")] = None,
        retain_repo_versions: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions matches value")] = None,
        retain_repo_versions__gt: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is greater than value")] = None,
        retain_repo_versions__gte: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is greater than or equal to value")] = None,
        retain_repo_versions__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where retain_repo_versions has a null value")] = None,
        retain_repo_versions__lt: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is less than value")] = None,
        retain_repo_versions__lte: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is less than or equal to value")] = None,
        retain_repo_versions__ne: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions not equal to value")] = None,
        retain_repo_versions__range: Annotated[Optional[List[StrictInt]], Field(description="Filter results where retain_repo_versions is between two comma separated values")] = None,
        with_content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedRepositoryResponseList:
        """List repositories

        Endpoint to list all repositories.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param latest_with_content: Content Unit referenced by HREF/PRN
        :type latest_with_content: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__icontains: Filter results where name contains value
        :type name__icontains: str
        :param name__iexact: Filter results where name matches value
        :type name__iexact: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__iregex: Filter results where name matches regex value
        :type name__iregex: str
        :param name__istartswith: Filter results where name starts with value
        :type name__istartswith: str
        :param name__regex: Filter results where name matches regex value
        :type name__regex: str
        :param name__startswith: Filter results where name starts with value
        :type name__startswith: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param pulp_type: Pulp type  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file
        :type pulp_type: str
        :param pulp_type__in: Multiple values may be separated by commas.  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file
        :type pulp_type__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param remote: Foreign Key referenced by HREF
        :type remote: str
        :param retain_repo_versions: Filter results where retain_repo_versions matches value
        :type retain_repo_versions: int
        :param retain_repo_versions__gt: Filter results where retain_repo_versions is greater than value
        :type retain_repo_versions__gt: int
        :param retain_repo_versions__gte: Filter results where retain_repo_versions is greater than or equal to value
        :type retain_repo_versions__gte: int
        :param retain_repo_versions__isnull: Filter results where retain_repo_versions has a null value
        :type retain_repo_versions__isnull: bool
        :param retain_repo_versions__lt: Filter results where retain_repo_versions is less than value
        :type retain_repo_versions__lt: int
        :param retain_repo_versions__lte: Filter results where retain_repo_versions is less than or equal to value
        :type retain_repo_versions__lte: int
        :param retain_repo_versions__ne: Filter results where retain_repo_versions not equal to value
        :type retain_repo_versions__ne: int
        :param retain_repo_versions__range: Filter results where retain_repo_versions is between two comma separated values
        :type retain_repo_versions__range: List[int]
        :param with_content: Content Unit referenced by HREF/PRN
        :type with_content: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            latest_with_content=latest_with_content,
            limit=limit,
            name=name,
            name__contains=name__contains,
            name__icontains=name__icontains,
            name__iexact=name__iexact,
            name__in=name__in,
            name__iregex=name__iregex,
            name__istartswith=name__istartswith,
            name__regex=name__regex,
            name__startswith=name__startswith,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            pulp_type=pulp_type,
            pulp_type__in=pulp_type__in,
            q=q,
            remote=remote,
            retain_repo_versions=retain_repo_versions,
            retain_repo_versions__gt=retain_repo_versions__gt,
            retain_repo_versions__gte=retain_repo_versions__gte,
            retain_repo_versions__isnull=retain_repo_versions__isnull,
            retain_repo_versions__lt=retain_repo_versions__lt,
            retain_repo_versions__lte=retain_repo_versions__lte,
            retain_repo_versions__ne=retain_repo_versions__ne,
            retain_repo_versions__range=retain_repo_versions__range,
            with_content=with_content,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedRepositoryResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        latest_with_content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__iregex: Annotated[Optional[StrictStr], Field(description="Filter results where name matches regex value")] = None,
        name__istartswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        name__regex: Annotated[Optional[StrictStr], Field(description="Filter results where name matches regex value")] = None,
        name__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        pulp_type: Annotated[Optional[StrictStr], Field(description="Pulp type  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file")] = None,
        pulp_type__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        remote: Annotated[Optional[StrictStr], Field(description="Foreign Key referenced by HREF")] = None,
        retain_repo_versions: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions matches value")] = None,
        retain_repo_versions__gt: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is greater than value")] = None,
        retain_repo_versions__gte: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is greater than or equal to value")] = None,
        retain_repo_versions__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where retain_repo_versions has a null value")] = None,
        retain_repo_versions__lt: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is less than value")] = None,
        retain_repo_versions__lte: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is less than or equal to value")] = None,
        retain_repo_versions__ne: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions not equal to value")] = None,
        retain_repo_versions__range: Annotated[Optional[List[StrictInt]], Field(description="Filter results where retain_repo_versions is between two comma separated values")] = None,
        with_content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedRepositoryResponseList]:
        """List repositories

        Endpoint to list all repositories.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param latest_with_content: Content Unit referenced by HREF/PRN
        :type latest_with_content: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__icontains: Filter results where name contains value
        :type name__icontains: str
        :param name__iexact: Filter results where name matches value
        :type name__iexact: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__iregex: Filter results where name matches regex value
        :type name__iregex: str
        :param name__istartswith: Filter results where name starts with value
        :type name__istartswith: str
        :param name__regex: Filter results where name matches regex value
        :type name__regex: str
        :param name__startswith: Filter results where name starts with value
        :type name__startswith: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param pulp_type: Pulp type  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file
        :type pulp_type: str
        :param pulp_type__in: Multiple values may be separated by commas.  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file
        :type pulp_type__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param remote: Foreign Key referenced by HREF
        :type remote: str
        :param retain_repo_versions: Filter results where retain_repo_versions matches value
        :type retain_repo_versions: int
        :param retain_repo_versions__gt: Filter results where retain_repo_versions is greater than value
        :type retain_repo_versions__gt: int
        :param retain_repo_versions__gte: Filter results where retain_repo_versions is greater than or equal to value
        :type retain_repo_versions__gte: int
        :param retain_repo_versions__isnull: Filter results where retain_repo_versions has a null value
        :type retain_repo_versions__isnull: bool
        :param retain_repo_versions__lt: Filter results where retain_repo_versions is less than value
        :type retain_repo_versions__lt: int
        :param retain_repo_versions__lte: Filter results where retain_repo_versions is less than or equal to value
        :type retain_repo_versions__lte: int
        :param retain_repo_versions__ne: Filter results where retain_repo_versions not equal to value
        :type retain_repo_versions__ne: int
        :param retain_repo_versions__range: Filter results where retain_repo_versions is between two comma separated values
        :type retain_repo_versions__range: List[int]
        :param with_content: Content Unit referenced by HREF/PRN
        :type with_content: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            latest_with_content=latest_with_content,
            limit=limit,
            name=name,
            name__contains=name__contains,
            name__icontains=name__icontains,
            name__iexact=name__iexact,
            name__in=name__in,
            name__iregex=name__iregex,
            name__istartswith=name__istartswith,
            name__regex=name__regex,
            name__startswith=name__startswith,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            pulp_type=pulp_type,
            pulp_type__in=pulp_type__in,
            q=q,
            remote=remote,
            retain_repo_versions=retain_repo_versions,
            retain_repo_versions__gt=retain_repo_versions__gt,
            retain_repo_versions__gte=retain_repo_versions__gte,
            retain_repo_versions__isnull=retain_repo_versions__isnull,
            retain_repo_versions__lt=retain_repo_versions__lt,
            retain_repo_versions__lte=retain_repo_versions__lte,
            retain_repo_versions__ne=retain_repo_versions__ne,
            retain_repo_versions__range=retain_repo_versions__range,
            with_content=with_content,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedRepositoryResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        latest_with_content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__iregex: Annotated[Optional[StrictStr], Field(description="Filter results where name matches regex value")] = None,
        name__istartswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        name__regex: Annotated[Optional[StrictStr], Field(description="Filter results where name matches regex value")] = None,
        name__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        pulp_type: Annotated[Optional[StrictStr], Field(description="Pulp type  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file")] = None,
        pulp_type__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        remote: Annotated[Optional[StrictStr], Field(description="Foreign Key referenced by HREF")] = None,
        retain_repo_versions: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions matches value")] = None,
        retain_repo_versions__gt: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is greater than value")] = None,
        retain_repo_versions__gte: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is greater than or equal to value")] = None,
        retain_repo_versions__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where retain_repo_versions has a null value")] = None,
        retain_repo_versions__lt: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is less than value")] = None,
        retain_repo_versions__lte: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions is less than or equal to value")] = None,
        retain_repo_versions__ne: Annotated[Optional[StrictInt], Field(description="Filter results where retain_repo_versions not equal to value")] = None,
        retain_repo_versions__range: Annotated[Optional[List[StrictInt]], Field(description="Filter results where retain_repo_versions is between two comma separated values")] = None,
        with_content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List repositories

        Endpoint to list all repositories.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param latest_with_content: Content Unit referenced by HREF/PRN
        :type latest_with_content: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__icontains: Filter results where name contains value
        :type name__icontains: str
        :param name__iexact: Filter results where name matches value
        :type name__iexact: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__iregex: Filter results where name matches regex value
        :type name__iregex: str
        :param name__istartswith: Filter results where name starts with value
        :type name__istartswith: str
        :param name__regex: Filter results where name matches regex value
        :type name__regex: str
        :param name__startswith: Filter results where name starts with value
        :type name__startswith: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param pulp_type: Pulp type  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file
        :type pulp_type: str
        :param pulp_type__in: Multiple values may be separated by commas.  * `core.openpgp` - core.openpgp * `container.container` - container.container * `container.container-push` - container.container-push * `gem.gem` - gem.gem * `hugging_face.hugging-face` - hugging_face.hugging-face * `maven.maven` - maven.maven * `npm.npm` - npm.npm * `ostree.ostree` - ostree.ostree * `python.python` - python.python * `rpm.rpm` - rpm.rpm * `file.file` - file.file
        :type pulp_type__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param remote: Foreign Key referenced by HREF
        :type remote: str
        :param retain_repo_versions: Filter results where retain_repo_versions matches value
        :type retain_repo_versions: int
        :param retain_repo_versions__gt: Filter results where retain_repo_versions is greater than value
        :type retain_repo_versions__gt: int
        :param retain_repo_versions__gte: Filter results where retain_repo_versions is greater than or equal to value
        :type retain_repo_versions__gte: int
        :param retain_repo_versions__isnull: Filter results where retain_repo_versions has a null value
        :type retain_repo_versions__isnull: bool
        :param retain_repo_versions__lt: Filter results where retain_repo_versions is less than value
        :type retain_repo_versions__lt: int
        :param retain_repo_versions__lte: Filter results where retain_repo_versions is less than or equal to value
        :type retain_repo_versions__lte: int
        :param retain_repo_versions__ne: Filter results where retain_repo_versions not equal to value
        :type retain_repo_versions__ne: int
        :param retain_repo_versions__range: Filter results where retain_repo_versions is between two comma separated values
        :type retain_repo_versions__range: List[int]
        :param with_content: Content Unit referenced by HREF/PRN
        :type with_content: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            latest_with_content=latest_with_content,
            limit=limit,
            name=name,
            name__contains=name__contains,
            name__icontains=name__icontains,
            name__iexact=name__iexact,
            name__in=name__in,
            name__iregex=name__iregex,
            name__istartswith=name__istartswith,
            name__regex=name__regex,
            name__startswith=name__startswith,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            pulp_type=pulp_type,
            pulp_type__in=pulp_type__in,
            q=q,
            remote=remote,
            retain_repo_versions=retain_repo_versions,
            retain_repo_versions__gt=retain_repo_versions__gt,
            retain_repo_versions__gte=retain_repo_versions__gte,
            retain_repo_versions__isnull=retain_repo_versions__isnull,
            retain_repo_versions__lt=retain_repo_versions__lt,
            retain_repo_versions__lte=retain_repo_versions__lte,
            retain_repo_versions__ne=retain_repo_versions__ne,
            retain_repo_versions__range=retain_repo_versions__range,
            with_content=with_content,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedRepositoryResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        pulp_domain,
        x_task_diagnostics,
        latest_with_content,
        limit,
        name,
        name__contains,
        name__icontains,
        name__iexact,
        name__in,
        name__iregex,
        name__istartswith,
        name__regex,
        name__startswith,
        offset,
        ordering,
        prn__in,
        pulp_href__in,
        pulp_id__in,
        pulp_label_select,
        pulp_type,
        pulp_type__in,
        q,
        remote,
        retain_repo_versions,
        retain_repo_versions__gt,
        retain_repo_versions__gte,
        retain_repo_versions__isnull,
        retain_repo_versions__lt,
        retain_repo_versions__lte,
        retain_repo_versions__ne,
        retain_repo_versions__range,
        with_content,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'name__in': 'csv',
            'ordering': 'csv',
            'prn__in': 'csv',
            'pulp_href__in': 'csv',
            'pulp_id__in': 'csv',
            'pulp_type__in': 'csv',
            'retain_repo_versions__range': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pulp_domain is not None:
            _path_params['pulp_domain'] = pulp_domain
        # process the query parameters
        if latest_with_content is not None:
            
            _query_params.append(('latest_with_content', latest_with_content))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__contains is not None:
            
            _query_params.append(('name__contains', name__contains))
            
        if name__icontains is not None:
            
            _query_params.append(('name__icontains', name__icontains))
            
        if name__iexact is not None:
            
            _query_params.append(('name__iexact', name__iexact))
            
        if name__in is not None:
            
            _query_params.append(('name__in', name__in))
            
        if name__iregex is not None:
            
            _query_params.append(('name__iregex', name__iregex))
            
        if name__istartswith is not None:
            
            _query_params.append(('name__istartswith', name__istartswith))
            
        if name__regex is not None:
            
            _query_params.append(('name__regex', name__regex))
            
        if name__startswith is not None:
            
            _query_params.append(('name__startswith', name__startswith))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if pulp_id__in is not None:
            
            _query_params.append(('pulp_id__in', pulp_id__in))
            
        if pulp_label_select is not None:
            
            _query_params.append(('pulp_label_select', pulp_label_select))
            
        if pulp_type is not None:
            
            _query_params.append(('pulp_type', pulp_type))
            
        if pulp_type__in is not None:
            
            _query_params.append(('pulp_type__in', pulp_type__in))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if remote is not None:
            
            _query_params.append(('remote', remote))
            
        if retain_repo_versions is not None:
            
            _query_params.append(('retain_repo_versions', retain_repo_versions))
            
        if retain_repo_versions__gt is not None:
            
            _query_params.append(('retain_repo_versions__gt', retain_repo_versions__gt))
            
        if retain_repo_versions__gte is not None:
            
            _query_params.append(('retain_repo_versions__gte', retain_repo_versions__gte))
            
        if retain_repo_versions__isnull is not None:
            
            _query_params.append(('retain_repo_versions__isnull', retain_repo_versions__isnull))
            
        if retain_repo_versions__lt is not None:
            
            _query_params.append(('retain_repo_versions__lt', retain_repo_versions__lt))
            
        if retain_repo_versions__lte is not None:
            
            _query_params.append(('retain_repo_versions__lte', retain_repo_versions__lte))
            
        if retain_repo_versions__ne is not None:
            
            _query_params.append(('retain_repo_versions__ne', retain_repo_versions__ne))
            
        if retain_repo_versions__range is not None:
            
            _query_params.append(('retain_repo_versions__range', retain_repo_versions__range))
            
        if with_content is not None:
            
            _query_params.append(('with_content', with_content))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/pulp/{pulp_domain}/api/v3/repositories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


