# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from crc-pulpcore-client.models.async_operation_response import AsyncOperationResponse
from crc-pulpcore-client.models.my_permissions_response import MyPermissionsResponse
from crc-pulpcore-client.models.nested_role import NestedRole
from crc-pulpcore-client.models.nested_role_response import NestedRoleResponse
from crc-pulpcore-client.models.object_roles_response import ObjectRolesResponse
from crc-pulpcore-client.models.paginated_task_response_list import PaginatedTaskResponseList
from crc-pulpcore-client.models.patched_task_cancel import PatchedTaskCancel
from crc-pulpcore-client.models.profile_artifact_response import ProfileArtifactResponse
from crc-pulpcore-client.models.purge import Purge
from crc-pulpcore-client.models.task_response import TaskResponse

from crc-pulpcore-client.api_client import ApiClient, RequestSerialized
from crc-pulpcore-client.api_response import ApiResponse
from crc-pulpcore-client.rest import RESTResponseType


class TasksApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def add_role(
        self,
        task_href: StrictStr,
        nested_role: NestedRole,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> NestedRoleResponse:
        """Add a role

        Add a role for this object to users/groups.

        :param task_href: (required)
        :type task_href: str
        :param nested_role: (required)
        :type nested_role: NestedRole
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_role_serialize(
            task_href=task_href,
            nested_role=nested_role,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "NestedRoleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def add_role_with_http_info(
        self,
        task_href: StrictStr,
        nested_role: NestedRole,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[NestedRoleResponse]:
        """Add a role

        Add a role for this object to users/groups.

        :param task_href: (required)
        :type task_href: str
        :param nested_role: (required)
        :type nested_role: NestedRole
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_role_serialize(
            task_href=task_href,
            nested_role=nested_role,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "NestedRoleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def add_role_without_preload_content(
        self,
        task_href: StrictStr,
        nested_role: NestedRole,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add a role

        Add a role for this object to users/groups.

        :param task_href: (required)
        :type task_href: str
        :param nested_role: (required)
        :type nested_role: NestedRole
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_role_serialize(
            task_href=task_href,
            nested_role=nested_role,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "NestedRoleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_role_serialize(
        self,
        task_href,
        nested_role,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if nested_role is not None:
            _body_params = nested_role


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{task_href}add_role/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete a task

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_with_http_info(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete a task

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_without_preload_content(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a task

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_serialize(
        self,
        task_href,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='{task_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        child_tasks: Annotated[Optional[StrictStr], Field(description="Filter results where child_tasks matches value")] = None,
        created_resources: Optional[StrictStr] = None,
        exclusive_resources: Optional[StrictStr] = None,
        exclusive_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        finished_at: Annotated[Optional[datetime], Field(description="Filter results where finished_at matches value")] = None,
        finished_at__gt: Annotated[Optional[datetime], Field(description="Filter results where finished_at is greater than value")] = None,
        finished_at__gte: Annotated[Optional[datetime], Field(description="Filter results where finished_at is greater than or equal to value")] = None,
        finished_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where finished_at has a null value")] = None,
        finished_at__lt: Annotated[Optional[datetime], Field(description="Filter results where finished_at is less than value")] = None,
        finished_at__lte: Annotated[Optional[datetime], Field(description="Filter results where finished_at is less than or equal to value")] = None,
        finished_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where finished_at is between two comma separated values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        logging_cid: Annotated[Optional[StrictStr], Field(description="Filter results where logging_cid matches value")] = None,
        logging_cid__contains: Annotated[Optional[StrictStr], Field(description="Filter results where logging_cid contains value")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__ne: Annotated[Optional[StrictStr], Field(description="Filter results where name not equal to value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `state` - State * `-state` - State (descending) * `name` - Name * `-name` - Name (descending) * `logging_cid` - Logging cid * `-logging_cid` - Logging cid (descending) * `unblocked_at` - Unblocked at * `-unblocked_at` - Unblocked at (descending) * `started_at` - Started at * `-started_at` - Started at (descending) * `finished_at` - Finished at * `-finished_at` - Finished at (descending) * `error` - Error * `-error` - Error (descending) * `enc_args` - Enc args * `-enc_args` - Enc args (descending) * `enc_kwargs` - Enc kwargs * `-enc_kwargs` - Enc kwargs (descending) * `reserved_resources_record` - Reserved resources record * `-reserved_resources_record` - Reserved resources record (descending) * `versions` - Versions * `-versions` - Versions (descending) * `profile_options` - Profile options * `-profile_options` - Profile options (descending) * `immediate` - Immediate * `-immediate` - Immediate (descending) * `deferred` - Deferred * `-deferred` - Deferred (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        parent_task: Annotated[Optional[StrictStr], Field(description="Filter results where parent_task matches value")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_created: Annotated[Optional[datetime], Field(description="Filter results where pulp_created matches value")] = None,
        pulp_created__gt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than value")] = None,
        pulp_created__gte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than or equal to value")] = None,
        pulp_created__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where pulp_created has a null value")] = None,
        pulp_created__lt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than value")] = None,
        pulp_created__lte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than or equal to value")] = None,
        pulp_created__range: Annotated[Optional[List[datetime]], Field(description="Filter results where pulp_created is between two comma separated values")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        reserved_resources: Optional[StrictStr] = None,
        reserved_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        shared_resources: Optional[StrictStr] = None,
        shared_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        started_at: Annotated[Optional[datetime], Field(description="Filter results where started_at matches value")] = None,
        started_at__gt: Annotated[Optional[datetime], Field(description="Filter results where started_at is greater than value")] = None,
        started_at__gte: Annotated[Optional[datetime], Field(description="Filter results where started_at is greater than or equal to value")] = None,
        started_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where started_at has a null value")] = None,
        started_at__lt: Annotated[Optional[datetime], Field(description="Filter results where started_at is less than value")] = None,
        started_at__lte: Annotated[Optional[datetime], Field(description="Filter results where started_at is less than or equal to value")] = None,
        started_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where started_at is between two comma separated values")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter results where state matches value  * `waiting` - Waiting * `skipped` - Skipped * `running` - Running * `completed` - Completed * `failed` - Failed * `canceled` - Canceled * `canceling` - Canceling")] = None,
        state__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where state is in a comma-separated list of values")] = None,
        state__ne: Annotated[Optional[StrictStr], Field(description="Filter results where state not equal to value")] = None,
        task_group: Annotated[Optional[StrictStr], Field(description="Filter results where task_group matches value")] = None,
        unblocked_at: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at matches value")] = None,
        unblocked_at__gt: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is greater than value")] = None,
        unblocked_at__gte: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is greater than or equal to value")] = None,
        unblocked_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where unblocked_at has a null value")] = None,
        unblocked_at__lt: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is less than value")] = None,
        unblocked_at__lte: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is less than or equal to value")] = None,
        unblocked_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where unblocked_at is between two comma separated values")] = None,
        worker: Annotated[Optional[StrictStr], Field(description="Filter results where worker matches value")] = None,
        worker__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where worker is in a comma-separated list of values")] = None,
        worker__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where worker has a null value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedTaskResponseList:
        """List tasks

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param child_tasks: Filter results where child_tasks matches value
        :type child_tasks: str
        :param created_resources:
        :type created_resources: str
        :param exclusive_resources:
        :type exclusive_resources: str
        :param exclusive_resources__in: Multiple values may be separated by commas.
        :type exclusive_resources__in: List[str]
        :param finished_at: Filter results where finished_at matches value
        :type finished_at: datetime
        :param finished_at__gt: Filter results where finished_at is greater than value
        :type finished_at__gt: datetime
        :param finished_at__gte: Filter results where finished_at is greater than or equal to value
        :type finished_at__gte: datetime
        :param finished_at__isnull: Filter results where finished_at has a null value
        :type finished_at__isnull: bool
        :param finished_at__lt: Filter results where finished_at is less than value
        :type finished_at__lt: datetime
        :param finished_at__lte: Filter results where finished_at is less than or equal to value
        :type finished_at__lte: datetime
        :param finished_at__range: Filter results where finished_at is between two comma separated values
        :type finished_at__range: List[datetime]
        :param limit: Number of results to return per page.
        :type limit: int
        :param logging_cid: Filter results where logging_cid matches value
        :type logging_cid: str
        :param logging_cid__contains: Filter results where logging_cid contains value
        :type logging_cid__contains: str
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__ne: Filter results where name not equal to value
        :type name__ne: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `state` - State * `-state` - State (descending) * `name` - Name * `-name` - Name (descending) * `logging_cid` - Logging cid * `-logging_cid` - Logging cid (descending) * `unblocked_at` - Unblocked at * `-unblocked_at` - Unblocked at (descending) * `started_at` - Started at * `-started_at` - Started at (descending) * `finished_at` - Finished at * `-finished_at` - Finished at (descending) * `error` - Error * `-error` - Error (descending) * `enc_args` - Enc args * `-enc_args` - Enc args (descending) * `enc_kwargs` - Enc kwargs * `-enc_kwargs` - Enc kwargs (descending) * `reserved_resources_record` - Reserved resources record * `-reserved_resources_record` - Reserved resources record (descending) * `versions` - Versions * `-versions` - Versions (descending) * `profile_options` - Profile options * `-profile_options` - Profile options (descending) * `immediate` - Immediate * `-immediate` - Immediate (descending) * `deferred` - Deferred * `-deferred` - Deferred (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param parent_task: Filter results where parent_task matches value
        :type parent_task: str
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_created: Filter results where pulp_created matches value
        :type pulp_created: datetime
        :param pulp_created__gt: Filter results where pulp_created is greater than value
        :type pulp_created__gt: datetime
        :param pulp_created__gte: Filter results where pulp_created is greater than or equal to value
        :type pulp_created__gte: datetime
        :param pulp_created__isnull: Filter results where pulp_created has a null value
        :type pulp_created__isnull: bool
        :param pulp_created__lt: Filter results where pulp_created is less than value
        :type pulp_created__lt: datetime
        :param pulp_created__lte: Filter results where pulp_created is less than or equal to value
        :type pulp_created__lte: datetime
        :param pulp_created__range: Filter results where pulp_created is between two comma separated values
        :type pulp_created__range: List[datetime]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param reserved_resources:
        :type reserved_resources: str
        :param reserved_resources__in: Multiple values may be separated by commas.
        :type reserved_resources__in: List[str]
        :param shared_resources:
        :type shared_resources: str
        :param shared_resources__in: Multiple values may be separated by commas.
        :type shared_resources__in: List[str]
        :param started_at: Filter results where started_at matches value
        :type started_at: datetime
        :param started_at__gt: Filter results where started_at is greater than value
        :type started_at__gt: datetime
        :param started_at__gte: Filter results where started_at is greater than or equal to value
        :type started_at__gte: datetime
        :param started_at__isnull: Filter results where started_at has a null value
        :type started_at__isnull: bool
        :param started_at__lt: Filter results where started_at is less than value
        :type started_at__lt: datetime
        :param started_at__lte: Filter results where started_at is less than or equal to value
        :type started_at__lte: datetime
        :param started_at__range: Filter results where started_at is between two comma separated values
        :type started_at__range: List[datetime]
        :param state: Filter results where state matches value  * `waiting` - Waiting * `skipped` - Skipped * `running` - Running * `completed` - Completed * `failed` - Failed * `canceled` - Canceled * `canceling` - Canceling
        :type state: str
        :param state__in: Filter results where state is in a comma-separated list of values
        :type state__in: List[str]
        :param state__ne: Filter results where state not equal to value
        :type state__ne: str
        :param task_group: Filter results where task_group matches value
        :type task_group: str
        :param unblocked_at: Filter results where unblocked_at matches value
        :type unblocked_at: datetime
        :param unblocked_at__gt: Filter results where unblocked_at is greater than value
        :type unblocked_at__gt: datetime
        :param unblocked_at__gte: Filter results where unblocked_at is greater than or equal to value
        :type unblocked_at__gte: datetime
        :param unblocked_at__isnull: Filter results where unblocked_at has a null value
        :type unblocked_at__isnull: bool
        :param unblocked_at__lt: Filter results where unblocked_at is less than value
        :type unblocked_at__lt: datetime
        :param unblocked_at__lte: Filter results where unblocked_at is less than or equal to value
        :type unblocked_at__lte: datetime
        :param unblocked_at__range: Filter results where unblocked_at is between two comma separated values
        :type unblocked_at__range: List[datetime]
        :param worker: Filter results where worker matches value
        :type worker: str
        :param worker__in: Filter results where worker is in a comma-separated list of values
        :type worker__in: List[str]
        :param worker__isnull: Filter results where worker has a null value
        :type worker__isnull: bool
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            child_tasks=child_tasks,
            created_resources=created_resources,
            exclusive_resources=exclusive_resources,
            exclusive_resources__in=exclusive_resources__in,
            finished_at=finished_at,
            finished_at__gt=finished_at__gt,
            finished_at__gte=finished_at__gte,
            finished_at__isnull=finished_at__isnull,
            finished_at__lt=finished_at__lt,
            finished_at__lte=finished_at__lte,
            finished_at__range=finished_at__range,
            limit=limit,
            logging_cid=logging_cid,
            logging_cid__contains=logging_cid__contains,
            name=name,
            name__contains=name__contains,
            name__in=name__in,
            name__ne=name__ne,
            offset=offset,
            ordering=ordering,
            parent_task=parent_task,
            prn__in=prn__in,
            pulp_created=pulp_created,
            pulp_created__gt=pulp_created__gt,
            pulp_created__gte=pulp_created__gte,
            pulp_created__isnull=pulp_created__isnull,
            pulp_created__lt=pulp_created__lt,
            pulp_created__lte=pulp_created__lte,
            pulp_created__range=pulp_created__range,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            q=q,
            reserved_resources=reserved_resources,
            reserved_resources__in=reserved_resources__in,
            shared_resources=shared_resources,
            shared_resources__in=shared_resources__in,
            started_at=started_at,
            started_at__gt=started_at__gt,
            started_at__gte=started_at__gte,
            started_at__isnull=started_at__isnull,
            started_at__lt=started_at__lt,
            started_at__lte=started_at__lte,
            started_at__range=started_at__range,
            state=state,
            state__in=state__in,
            state__ne=state__ne,
            task_group=task_group,
            unblocked_at=unblocked_at,
            unblocked_at__gt=unblocked_at__gt,
            unblocked_at__gte=unblocked_at__gte,
            unblocked_at__isnull=unblocked_at__isnull,
            unblocked_at__lt=unblocked_at__lt,
            unblocked_at__lte=unblocked_at__lte,
            unblocked_at__range=unblocked_at__range,
            worker=worker,
            worker__in=worker__in,
            worker__isnull=worker__isnull,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedTaskResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        child_tasks: Annotated[Optional[StrictStr], Field(description="Filter results where child_tasks matches value")] = None,
        created_resources: Optional[StrictStr] = None,
        exclusive_resources: Optional[StrictStr] = None,
        exclusive_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        finished_at: Annotated[Optional[datetime], Field(description="Filter results where finished_at matches value")] = None,
        finished_at__gt: Annotated[Optional[datetime], Field(description="Filter results where finished_at is greater than value")] = None,
        finished_at__gte: Annotated[Optional[datetime], Field(description="Filter results where finished_at is greater than or equal to value")] = None,
        finished_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where finished_at has a null value")] = None,
        finished_at__lt: Annotated[Optional[datetime], Field(description="Filter results where finished_at is less than value")] = None,
        finished_at__lte: Annotated[Optional[datetime], Field(description="Filter results where finished_at is less than or equal to value")] = None,
        finished_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where finished_at is between two comma separated values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        logging_cid: Annotated[Optional[StrictStr], Field(description="Filter results where logging_cid matches value")] = None,
        logging_cid__contains: Annotated[Optional[StrictStr], Field(description="Filter results where logging_cid contains value")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__ne: Annotated[Optional[StrictStr], Field(description="Filter results where name not equal to value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `state` - State * `-state` - State (descending) * `name` - Name * `-name` - Name (descending) * `logging_cid` - Logging cid * `-logging_cid` - Logging cid (descending) * `unblocked_at` - Unblocked at * `-unblocked_at` - Unblocked at (descending) * `started_at` - Started at * `-started_at` - Started at (descending) * `finished_at` - Finished at * `-finished_at` - Finished at (descending) * `error` - Error * `-error` - Error (descending) * `enc_args` - Enc args * `-enc_args` - Enc args (descending) * `enc_kwargs` - Enc kwargs * `-enc_kwargs` - Enc kwargs (descending) * `reserved_resources_record` - Reserved resources record * `-reserved_resources_record` - Reserved resources record (descending) * `versions` - Versions * `-versions` - Versions (descending) * `profile_options` - Profile options * `-profile_options` - Profile options (descending) * `immediate` - Immediate * `-immediate` - Immediate (descending) * `deferred` - Deferred * `-deferred` - Deferred (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        parent_task: Annotated[Optional[StrictStr], Field(description="Filter results where parent_task matches value")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_created: Annotated[Optional[datetime], Field(description="Filter results where pulp_created matches value")] = None,
        pulp_created__gt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than value")] = None,
        pulp_created__gte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than or equal to value")] = None,
        pulp_created__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where pulp_created has a null value")] = None,
        pulp_created__lt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than value")] = None,
        pulp_created__lte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than or equal to value")] = None,
        pulp_created__range: Annotated[Optional[List[datetime]], Field(description="Filter results where pulp_created is between two comma separated values")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        reserved_resources: Optional[StrictStr] = None,
        reserved_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        shared_resources: Optional[StrictStr] = None,
        shared_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        started_at: Annotated[Optional[datetime], Field(description="Filter results where started_at matches value")] = None,
        started_at__gt: Annotated[Optional[datetime], Field(description="Filter results where started_at is greater than value")] = None,
        started_at__gte: Annotated[Optional[datetime], Field(description="Filter results where started_at is greater than or equal to value")] = None,
        started_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where started_at has a null value")] = None,
        started_at__lt: Annotated[Optional[datetime], Field(description="Filter results where started_at is less than value")] = None,
        started_at__lte: Annotated[Optional[datetime], Field(description="Filter results where started_at is less than or equal to value")] = None,
        started_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where started_at is between two comma separated values")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter results where state matches value  * `waiting` - Waiting * `skipped` - Skipped * `running` - Running * `completed` - Completed * `failed` - Failed * `canceled` - Canceled * `canceling` - Canceling")] = None,
        state__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where state is in a comma-separated list of values")] = None,
        state__ne: Annotated[Optional[StrictStr], Field(description="Filter results where state not equal to value")] = None,
        task_group: Annotated[Optional[StrictStr], Field(description="Filter results where task_group matches value")] = None,
        unblocked_at: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at matches value")] = None,
        unblocked_at__gt: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is greater than value")] = None,
        unblocked_at__gte: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is greater than or equal to value")] = None,
        unblocked_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where unblocked_at has a null value")] = None,
        unblocked_at__lt: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is less than value")] = None,
        unblocked_at__lte: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is less than or equal to value")] = None,
        unblocked_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where unblocked_at is between two comma separated values")] = None,
        worker: Annotated[Optional[StrictStr], Field(description="Filter results where worker matches value")] = None,
        worker__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where worker is in a comma-separated list of values")] = None,
        worker__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where worker has a null value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedTaskResponseList]:
        """List tasks

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param child_tasks: Filter results where child_tasks matches value
        :type child_tasks: str
        :param created_resources:
        :type created_resources: str
        :param exclusive_resources:
        :type exclusive_resources: str
        :param exclusive_resources__in: Multiple values may be separated by commas.
        :type exclusive_resources__in: List[str]
        :param finished_at: Filter results where finished_at matches value
        :type finished_at: datetime
        :param finished_at__gt: Filter results where finished_at is greater than value
        :type finished_at__gt: datetime
        :param finished_at__gte: Filter results where finished_at is greater than or equal to value
        :type finished_at__gte: datetime
        :param finished_at__isnull: Filter results where finished_at has a null value
        :type finished_at__isnull: bool
        :param finished_at__lt: Filter results where finished_at is less than value
        :type finished_at__lt: datetime
        :param finished_at__lte: Filter results where finished_at is less than or equal to value
        :type finished_at__lte: datetime
        :param finished_at__range: Filter results where finished_at is between two comma separated values
        :type finished_at__range: List[datetime]
        :param limit: Number of results to return per page.
        :type limit: int
        :param logging_cid: Filter results where logging_cid matches value
        :type logging_cid: str
        :param logging_cid__contains: Filter results where logging_cid contains value
        :type logging_cid__contains: str
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__ne: Filter results where name not equal to value
        :type name__ne: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `state` - State * `-state` - State (descending) * `name` - Name * `-name` - Name (descending) * `logging_cid` - Logging cid * `-logging_cid` - Logging cid (descending) * `unblocked_at` - Unblocked at * `-unblocked_at` - Unblocked at (descending) * `started_at` - Started at * `-started_at` - Started at (descending) * `finished_at` - Finished at * `-finished_at` - Finished at (descending) * `error` - Error * `-error` - Error (descending) * `enc_args` - Enc args * `-enc_args` - Enc args (descending) * `enc_kwargs` - Enc kwargs * `-enc_kwargs` - Enc kwargs (descending) * `reserved_resources_record` - Reserved resources record * `-reserved_resources_record` - Reserved resources record (descending) * `versions` - Versions * `-versions` - Versions (descending) * `profile_options` - Profile options * `-profile_options` - Profile options (descending) * `immediate` - Immediate * `-immediate` - Immediate (descending) * `deferred` - Deferred * `-deferred` - Deferred (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param parent_task: Filter results where parent_task matches value
        :type parent_task: str
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_created: Filter results where pulp_created matches value
        :type pulp_created: datetime
        :param pulp_created__gt: Filter results where pulp_created is greater than value
        :type pulp_created__gt: datetime
        :param pulp_created__gte: Filter results where pulp_created is greater than or equal to value
        :type pulp_created__gte: datetime
        :param pulp_created__isnull: Filter results where pulp_created has a null value
        :type pulp_created__isnull: bool
        :param pulp_created__lt: Filter results where pulp_created is less than value
        :type pulp_created__lt: datetime
        :param pulp_created__lte: Filter results where pulp_created is less than or equal to value
        :type pulp_created__lte: datetime
        :param pulp_created__range: Filter results where pulp_created is between two comma separated values
        :type pulp_created__range: List[datetime]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param reserved_resources:
        :type reserved_resources: str
        :param reserved_resources__in: Multiple values may be separated by commas.
        :type reserved_resources__in: List[str]
        :param shared_resources:
        :type shared_resources: str
        :param shared_resources__in: Multiple values may be separated by commas.
        :type shared_resources__in: List[str]
        :param started_at: Filter results where started_at matches value
        :type started_at: datetime
        :param started_at__gt: Filter results where started_at is greater than value
        :type started_at__gt: datetime
        :param started_at__gte: Filter results where started_at is greater than or equal to value
        :type started_at__gte: datetime
        :param started_at__isnull: Filter results where started_at has a null value
        :type started_at__isnull: bool
        :param started_at__lt: Filter results where started_at is less than value
        :type started_at__lt: datetime
        :param started_at__lte: Filter results where started_at is less than or equal to value
        :type started_at__lte: datetime
        :param started_at__range: Filter results where started_at is between two comma separated values
        :type started_at__range: List[datetime]
        :param state: Filter results where state matches value  * `waiting` - Waiting * `skipped` - Skipped * `running` - Running * `completed` - Completed * `failed` - Failed * `canceled` - Canceled * `canceling` - Canceling
        :type state: str
        :param state__in: Filter results where state is in a comma-separated list of values
        :type state__in: List[str]
        :param state__ne: Filter results where state not equal to value
        :type state__ne: str
        :param task_group: Filter results where task_group matches value
        :type task_group: str
        :param unblocked_at: Filter results where unblocked_at matches value
        :type unblocked_at: datetime
        :param unblocked_at__gt: Filter results where unblocked_at is greater than value
        :type unblocked_at__gt: datetime
        :param unblocked_at__gte: Filter results where unblocked_at is greater than or equal to value
        :type unblocked_at__gte: datetime
        :param unblocked_at__isnull: Filter results where unblocked_at has a null value
        :type unblocked_at__isnull: bool
        :param unblocked_at__lt: Filter results where unblocked_at is less than value
        :type unblocked_at__lt: datetime
        :param unblocked_at__lte: Filter results where unblocked_at is less than or equal to value
        :type unblocked_at__lte: datetime
        :param unblocked_at__range: Filter results where unblocked_at is between two comma separated values
        :type unblocked_at__range: List[datetime]
        :param worker: Filter results where worker matches value
        :type worker: str
        :param worker__in: Filter results where worker is in a comma-separated list of values
        :type worker__in: List[str]
        :param worker__isnull: Filter results where worker has a null value
        :type worker__isnull: bool
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            child_tasks=child_tasks,
            created_resources=created_resources,
            exclusive_resources=exclusive_resources,
            exclusive_resources__in=exclusive_resources__in,
            finished_at=finished_at,
            finished_at__gt=finished_at__gt,
            finished_at__gte=finished_at__gte,
            finished_at__isnull=finished_at__isnull,
            finished_at__lt=finished_at__lt,
            finished_at__lte=finished_at__lte,
            finished_at__range=finished_at__range,
            limit=limit,
            logging_cid=logging_cid,
            logging_cid__contains=logging_cid__contains,
            name=name,
            name__contains=name__contains,
            name__in=name__in,
            name__ne=name__ne,
            offset=offset,
            ordering=ordering,
            parent_task=parent_task,
            prn__in=prn__in,
            pulp_created=pulp_created,
            pulp_created__gt=pulp_created__gt,
            pulp_created__gte=pulp_created__gte,
            pulp_created__isnull=pulp_created__isnull,
            pulp_created__lt=pulp_created__lt,
            pulp_created__lte=pulp_created__lte,
            pulp_created__range=pulp_created__range,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            q=q,
            reserved_resources=reserved_resources,
            reserved_resources__in=reserved_resources__in,
            shared_resources=shared_resources,
            shared_resources__in=shared_resources__in,
            started_at=started_at,
            started_at__gt=started_at__gt,
            started_at__gte=started_at__gte,
            started_at__isnull=started_at__isnull,
            started_at__lt=started_at__lt,
            started_at__lte=started_at__lte,
            started_at__range=started_at__range,
            state=state,
            state__in=state__in,
            state__ne=state__ne,
            task_group=task_group,
            unblocked_at=unblocked_at,
            unblocked_at__gt=unblocked_at__gt,
            unblocked_at__gte=unblocked_at__gte,
            unblocked_at__isnull=unblocked_at__isnull,
            unblocked_at__lt=unblocked_at__lt,
            unblocked_at__lte=unblocked_at__lte,
            unblocked_at__range=unblocked_at__range,
            worker=worker,
            worker__in=worker__in,
            worker__isnull=worker__isnull,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedTaskResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        child_tasks: Annotated[Optional[StrictStr], Field(description="Filter results where child_tasks matches value")] = None,
        created_resources: Optional[StrictStr] = None,
        exclusive_resources: Optional[StrictStr] = None,
        exclusive_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        finished_at: Annotated[Optional[datetime], Field(description="Filter results where finished_at matches value")] = None,
        finished_at__gt: Annotated[Optional[datetime], Field(description="Filter results where finished_at is greater than value")] = None,
        finished_at__gte: Annotated[Optional[datetime], Field(description="Filter results where finished_at is greater than or equal to value")] = None,
        finished_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where finished_at has a null value")] = None,
        finished_at__lt: Annotated[Optional[datetime], Field(description="Filter results where finished_at is less than value")] = None,
        finished_at__lte: Annotated[Optional[datetime], Field(description="Filter results where finished_at is less than or equal to value")] = None,
        finished_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where finished_at is between two comma separated values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        logging_cid: Annotated[Optional[StrictStr], Field(description="Filter results where logging_cid matches value")] = None,
        logging_cid__contains: Annotated[Optional[StrictStr], Field(description="Filter results where logging_cid contains value")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__ne: Annotated[Optional[StrictStr], Field(description="Filter results where name not equal to value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `state` - State * `-state` - State (descending) * `name` - Name * `-name` - Name (descending) * `logging_cid` - Logging cid * `-logging_cid` - Logging cid (descending) * `unblocked_at` - Unblocked at * `-unblocked_at` - Unblocked at (descending) * `started_at` - Started at * `-started_at` - Started at (descending) * `finished_at` - Finished at * `-finished_at` - Finished at (descending) * `error` - Error * `-error` - Error (descending) * `enc_args` - Enc args * `-enc_args` - Enc args (descending) * `enc_kwargs` - Enc kwargs * `-enc_kwargs` - Enc kwargs (descending) * `reserved_resources_record` - Reserved resources record * `-reserved_resources_record` - Reserved resources record (descending) * `versions` - Versions * `-versions` - Versions (descending) * `profile_options` - Profile options * `-profile_options` - Profile options (descending) * `immediate` - Immediate * `-immediate` - Immediate (descending) * `deferred` - Deferred * `-deferred` - Deferred (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        parent_task: Annotated[Optional[StrictStr], Field(description="Filter results where parent_task matches value")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_created: Annotated[Optional[datetime], Field(description="Filter results where pulp_created matches value")] = None,
        pulp_created__gt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than value")] = None,
        pulp_created__gte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than or equal to value")] = None,
        pulp_created__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where pulp_created has a null value")] = None,
        pulp_created__lt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than value")] = None,
        pulp_created__lte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than or equal to value")] = None,
        pulp_created__range: Annotated[Optional[List[datetime]], Field(description="Filter results where pulp_created is between two comma separated values")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        reserved_resources: Optional[StrictStr] = None,
        reserved_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        shared_resources: Optional[StrictStr] = None,
        shared_resources__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        started_at: Annotated[Optional[datetime], Field(description="Filter results where started_at matches value")] = None,
        started_at__gt: Annotated[Optional[datetime], Field(description="Filter results where started_at is greater than value")] = None,
        started_at__gte: Annotated[Optional[datetime], Field(description="Filter results where started_at is greater than or equal to value")] = None,
        started_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where started_at has a null value")] = None,
        started_at__lt: Annotated[Optional[datetime], Field(description="Filter results where started_at is less than value")] = None,
        started_at__lte: Annotated[Optional[datetime], Field(description="Filter results where started_at is less than or equal to value")] = None,
        started_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where started_at is between two comma separated values")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter results where state matches value  * `waiting` - Waiting * `skipped` - Skipped * `running` - Running * `completed` - Completed * `failed` - Failed * `canceled` - Canceled * `canceling` - Canceling")] = None,
        state__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where state is in a comma-separated list of values")] = None,
        state__ne: Annotated[Optional[StrictStr], Field(description="Filter results where state not equal to value")] = None,
        task_group: Annotated[Optional[StrictStr], Field(description="Filter results where task_group matches value")] = None,
        unblocked_at: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at matches value")] = None,
        unblocked_at__gt: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is greater than value")] = None,
        unblocked_at__gte: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is greater than or equal to value")] = None,
        unblocked_at__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where unblocked_at has a null value")] = None,
        unblocked_at__lt: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is less than value")] = None,
        unblocked_at__lte: Annotated[Optional[datetime], Field(description="Filter results where unblocked_at is less than or equal to value")] = None,
        unblocked_at__range: Annotated[Optional[List[datetime]], Field(description="Filter results where unblocked_at is between two comma separated values")] = None,
        worker: Annotated[Optional[StrictStr], Field(description="Filter results where worker matches value")] = None,
        worker__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where worker is in a comma-separated list of values")] = None,
        worker__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where worker has a null value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List tasks

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param child_tasks: Filter results where child_tasks matches value
        :type child_tasks: str
        :param created_resources:
        :type created_resources: str
        :param exclusive_resources:
        :type exclusive_resources: str
        :param exclusive_resources__in: Multiple values may be separated by commas.
        :type exclusive_resources__in: List[str]
        :param finished_at: Filter results where finished_at matches value
        :type finished_at: datetime
        :param finished_at__gt: Filter results where finished_at is greater than value
        :type finished_at__gt: datetime
        :param finished_at__gte: Filter results where finished_at is greater than or equal to value
        :type finished_at__gte: datetime
        :param finished_at__isnull: Filter results where finished_at has a null value
        :type finished_at__isnull: bool
        :param finished_at__lt: Filter results where finished_at is less than value
        :type finished_at__lt: datetime
        :param finished_at__lte: Filter results where finished_at is less than or equal to value
        :type finished_at__lte: datetime
        :param finished_at__range: Filter results where finished_at is between two comma separated values
        :type finished_at__range: List[datetime]
        :param limit: Number of results to return per page.
        :type limit: int
        :param logging_cid: Filter results where logging_cid matches value
        :type logging_cid: str
        :param logging_cid__contains: Filter results where logging_cid contains value
        :type logging_cid__contains: str
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__ne: Filter results where name not equal to value
        :type name__ne: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `state` - State * `-state` - State (descending) * `name` - Name * `-name` - Name (descending) * `logging_cid` - Logging cid * `-logging_cid` - Logging cid (descending) * `unblocked_at` - Unblocked at * `-unblocked_at` - Unblocked at (descending) * `started_at` - Started at * `-started_at` - Started at (descending) * `finished_at` - Finished at * `-finished_at` - Finished at (descending) * `error` - Error * `-error` - Error (descending) * `enc_args` - Enc args * `-enc_args` - Enc args (descending) * `enc_kwargs` - Enc kwargs * `-enc_kwargs` - Enc kwargs (descending) * `reserved_resources_record` - Reserved resources record * `-reserved_resources_record` - Reserved resources record (descending) * `versions` - Versions * `-versions` - Versions (descending) * `profile_options` - Profile options * `-profile_options` - Profile options (descending) * `immediate` - Immediate * `-immediate` - Immediate (descending) * `deferred` - Deferred * `-deferred` - Deferred (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param parent_task: Filter results where parent_task matches value
        :type parent_task: str
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_created: Filter results where pulp_created matches value
        :type pulp_created: datetime
        :param pulp_created__gt: Filter results where pulp_created is greater than value
        :type pulp_created__gt: datetime
        :param pulp_created__gte: Filter results where pulp_created is greater than or equal to value
        :type pulp_created__gte: datetime
        :param pulp_created__isnull: Filter results where pulp_created has a null value
        :type pulp_created__isnull: bool
        :param pulp_created__lt: Filter results where pulp_created is less than value
        :type pulp_created__lt: datetime
        :param pulp_created__lte: Filter results where pulp_created is less than or equal to value
        :type pulp_created__lte: datetime
        :param pulp_created__range: Filter results where pulp_created is between two comma separated values
        :type pulp_created__range: List[datetime]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param reserved_resources:
        :type reserved_resources: str
        :param reserved_resources__in: Multiple values may be separated by commas.
        :type reserved_resources__in: List[str]
        :param shared_resources:
        :type shared_resources: str
        :param shared_resources__in: Multiple values may be separated by commas.
        :type shared_resources__in: List[str]
        :param started_at: Filter results where started_at matches value
        :type started_at: datetime
        :param started_at__gt: Filter results where started_at is greater than value
        :type started_at__gt: datetime
        :param started_at__gte: Filter results where started_at is greater than or equal to value
        :type started_at__gte: datetime
        :param started_at__isnull: Filter results where started_at has a null value
        :type started_at__isnull: bool
        :param started_at__lt: Filter results where started_at is less than value
        :type started_at__lt: datetime
        :param started_at__lte: Filter results where started_at is less than or equal to value
        :type started_at__lte: datetime
        :param started_at__range: Filter results where started_at is between two comma separated values
        :type started_at__range: List[datetime]
        :param state: Filter results where state matches value  * `waiting` - Waiting * `skipped` - Skipped * `running` - Running * `completed` - Completed * `failed` - Failed * `canceled` - Canceled * `canceling` - Canceling
        :type state: str
        :param state__in: Filter results where state is in a comma-separated list of values
        :type state__in: List[str]
        :param state__ne: Filter results where state not equal to value
        :type state__ne: str
        :param task_group: Filter results where task_group matches value
        :type task_group: str
        :param unblocked_at: Filter results where unblocked_at matches value
        :type unblocked_at: datetime
        :param unblocked_at__gt: Filter results where unblocked_at is greater than value
        :type unblocked_at__gt: datetime
        :param unblocked_at__gte: Filter results where unblocked_at is greater than or equal to value
        :type unblocked_at__gte: datetime
        :param unblocked_at__isnull: Filter results where unblocked_at has a null value
        :type unblocked_at__isnull: bool
        :param unblocked_at__lt: Filter results where unblocked_at is less than value
        :type unblocked_at__lt: datetime
        :param unblocked_at__lte: Filter results where unblocked_at is less than or equal to value
        :type unblocked_at__lte: datetime
        :param unblocked_at__range: Filter results where unblocked_at is between two comma separated values
        :type unblocked_at__range: List[datetime]
        :param worker: Filter results where worker matches value
        :type worker: str
        :param worker__in: Filter results where worker is in a comma-separated list of values
        :type worker__in: List[str]
        :param worker__isnull: Filter results where worker has a null value
        :type worker__isnull: bool
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            child_tasks=child_tasks,
            created_resources=created_resources,
            exclusive_resources=exclusive_resources,
            exclusive_resources__in=exclusive_resources__in,
            finished_at=finished_at,
            finished_at__gt=finished_at__gt,
            finished_at__gte=finished_at__gte,
            finished_at__isnull=finished_at__isnull,
            finished_at__lt=finished_at__lt,
            finished_at__lte=finished_at__lte,
            finished_at__range=finished_at__range,
            limit=limit,
            logging_cid=logging_cid,
            logging_cid__contains=logging_cid__contains,
            name=name,
            name__contains=name__contains,
            name__in=name__in,
            name__ne=name__ne,
            offset=offset,
            ordering=ordering,
            parent_task=parent_task,
            prn__in=prn__in,
            pulp_created=pulp_created,
            pulp_created__gt=pulp_created__gt,
            pulp_created__gte=pulp_created__gte,
            pulp_created__isnull=pulp_created__isnull,
            pulp_created__lt=pulp_created__lt,
            pulp_created__lte=pulp_created__lte,
            pulp_created__range=pulp_created__range,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            q=q,
            reserved_resources=reserved_resources,
            reserved_resources__in=reserved_resources__in,
            shared_resources=shared_resources,
            shared_resources__in=shared_resources__in,
            started_at=started_at,
            started_at__gt=started_at__gt,
            started_at__gte=started_at__gte,
            started_at__isnull=started_at__isnull,
            started_at__lt=started_at__lt,
            started_at__lte=started_at__lte,
            started_at__range=started_at__range,
            state=state,
            state__in=state__in,
            state__ne=state__ne,
            task_group=task_group,
            unblocked_at=unblocked_at,
            unblocked_at__gt=unblocked_at__gt,
            unblocked_at__gte=unblocked_at__gte,
            unblocked_at__isnull=unblocked_at__isnull,
            unblocked_at__lt=unblocked_at__lt,
            unblocked_at__lte=unblocked_at__lte,
            unblocked_at__range=unblocked_at__range,
            worker=worker,
            worker__in=worker__in,
            worker__isnull=worker__isnull,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedTaskResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        pulp_domain,
        x_task_diagnostics,
        child_tasks,
        created_resources,
        exclusive_resources,
        exclusive_resources__in,
        finished_at,
        finished_at__gt,
        finished_at__gte,
        finished_at__isnull,
        finished_at__lt,
        finished_at__lte,
        finished_at__range,
        limit,
        logging_cid,
        logging_cid__contains,
        name,
        name__contains,
        name__in,
        name__ne,
        offset,
        ordering,
        parent_task,
        prn__in,
        pulp_created,
        pulp_created__gt,
        pulp_created__gte,
        pulp_created__isnull,
        pulp_created__lt,
        pulp_created__lte,
        pulp_created__range,
        pulp_href__in,
        pulp_id__in,
        q,
        reserved_resources,
        reserved_resources__in,
        shared_resources,
        shared_resources__in,
        started_at,
        started_at__gt,
        started_at__gte,
        started_at__isnull,
        started_at__lt,
        started_at__lte,
        started_at__range,
        state,
        state__in,
        state__ne,
        task_group,
        unblocked_at,
        unblocked_at__gt,
        unblocked_at__gte,
        unblocked_at__isnull,
        unblocked_at__lt,
        unblocked_at__lte,
        unblocked_at__range,
        worker,
        worker__in,
        worker__isnull,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'exclusive_resources__in': 'csv',
            'finished_at__range': 'csv',
            'name__in': 'csv',
            'ordering': 'csv',
            'prn__in': 'csv',
            'pulp_created__range': 'csv',
            'pulp_href__in': 'csv',
            'pulp_id__in': 'csv',
            'reserved_resources__in': 'csv',
            'shared_resources__in': 'csv',
            'started_at__range': 'csv',
            'state__in': 'csv',
            'unblocked_at__range': 'csv',
            'worker__in': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pulp_domain is not None:
            _path_params['pulp_domain'] = pulp_domain
        # process the query parameters
        if child_tasks is not None:
            
            _query_params.append(('child_tasks', child_tasks))
            
        if created_resources is not None:
            
            _query_params.append(('created_resources', created_resources))
            
        if exclusive_resources is not None:
            
            _query_params.append(('exclusive_resources', exclusive_resources))
            
        if exclusive_resources__in is not None:
            
            _query_params.append(('exclusive_resources__in', exclusive_resources__in))
            
        if finished_at is not None:
            if isinstance(finished_at, datetime):
                _query_params.append(
                    (
                        'finished_at',
                        finished_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('finished_at', finished_at))
            
        if finished_at__gt is not None:
            if isinstance(finished_at__gt, datetime):
                _query_params.append(
                    (
                        'finished_at__gt',
                        finished_at__gt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('finished_at__gt', finished_at__gt))
            
        if finished_at__gte is not None:
            if isinstance(finished_at__gte, datetime):
                _query_params.append(
                    (
                        'finished_at__gte',
                        finished_at__gte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('finished_at__gte', finished_at__gte))
            
        if finished_at__isnull is not None:
            
            _query_params.append(('finished_at__isnull', finished_at__isnull))
            
        if finished_at__lt is not None:
            if isinstance(finished_at__lt, datetime):
                _query_params.append(
                    (
                        'finished_at__lt',
                        finished_at__lt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('finished_at__lt', finished_at__lt))
            
        if finished_at__lte is not None:
            if isinstance(finished_at__lte, datetime):
                _query_params.append(
                    (
                        'finished_at__lte',
                        finished_at__lte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('finished_at__lte', finished_at__lte))
            
        if finished_at__range is not None:
            
            _query_params.append(('finished_at__range', finished_at__range))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if logging_cid is not None:
            
            _query_params.append(('logging_cid', logging_cid))
            
        if logging_cid__contains is not None:
            
            _query_params.append(('logging_cid__contains', logging_cid__contains))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__contains is not None:
            
            _query_params.append(('name__contains', name__contains))
            
        if name__in is not None:
            
            _query_params.append(('name__in', name__in))
            
        if name__ne is not None:
            
            _query_params.append(('name__ne', name__ne))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if parent_task is not None:
            
            _query_params.append(('parent_task', parent_task))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_created is not None:
            if isinstance(pulp_created, datetime):
                _query_params.append(
                    (
                        'pulp_created',
                        pulp_created.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created', pulp_created))
            
        if pulp_created__gt is not None:
            if isinstance(pulp_created__gt, datetime):
                _query_params.append(
                    (
                        'pulp_created__gt',
                        pulp_created__gt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__gt', pulp_created__gt))
            
        if pulp_created__gte is not None:
            if isinstance(pulp_created__gte, datetime):
                _query_params.append(
                    (
                        'pulp_created__gte',
                        pulp_created__gte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__gte', pulp_created__gte))
            
        if pulp_created__isnull is not None:
            
            _query_params.append(('pulp_created__isnull', pulp_created__isnull))
            
        if pulp_created__lt is not None:
            if isinstance(pulp_created__lt, datetime):
                _query_params.append(
                    (
                        'pulp_created__lt',
                        pulp_created__lt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__lt', pulp_created__lt))
            
        if pulp_created__lte is not None:
            if isinstance(pulp_created__lte, datetime):
                _query_params.append(
                    (
                        'pulp_created__lte',
                        pulp_created__lte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__lte', pulp_created__lte))
            
        if pulp_created__range is not None:
            
            _query_params.append(('pulp_created__range', pulp_created__range))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if pulp_id__in is not None:
            
            _query_params.append(('pulp_id__in', pulp_id__in))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if reserved_resources is not None:
            
            _query_params.append(('reserved_resources', reserved_resources))
            
        if reserved_resources__in is not None:
            
            _query_params.append(('reserved_resources__in', reserved_resources__in))
            
        if shared_resources is not None:
            
            _query_params.append(('shared_resources', shared_resources))
            
        if shared_resources__in is not None:
            
            _query_params.append(('shared_resources__in', shared_resources__in))
            
        if started_at is not None:
            if isinstance(started_at, datetime):
                _query_params.append(
                    (
                        'started_at',
                        started_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started_at', started_at))
            
        if started_at__gt is not None:
            if isinstance(started_at__gt, datetime):
                _query_params.append(
                    (
                        'started_at__gt',
                        started_at__gt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started_at__gt', started_at__gt))
            
        if started_at__gte is not None:
            if isinstance(started_at__gte, datetime):
                _query_params.append(
                    (
                        'started_at__gte',
                        started_at__gte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started_at__gte', started_at__gte))
            
        if started_at__isnull is not None:
            
            _query_params.append(('started_at__isnull', started_at__isnull))
            
        if started_at__lt is not None:
            if isinstance(started_at__lt, datetime):
                _query_params.append(
                    (
                        'started_at__lt',
                        started_at__lt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started_at__lt', started_at__lt))
            
        if started_at__lte is not None:
            if isinstance(started_at__lte, datetime):
                _query_params.append(
                    (
                        'started_at__lte',
                        started_at__lte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started_at__lte', started_at__lte))
            
        if started_at__range is not None:
            
            _query_params.append(('started_at__range', started_at__range))
            
        if state is not None:
            
            _query_params.append(('state', state))
            
        if state__in is not None:
            
            _query_params.append(('state__in', state__in))
            
        if state__ne is not None:
            
            _query_params.append(('state__ne', state__ne))
            
        if task_group is not None:
            
            _query_params.append(('task_group', task_group))
            
        if unblocked_at is not None:
            if isinstance(unblocked_at, datetime):
                _query_params.append(
                    (
                        'unblocked_at',
                        unblocked_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('unblocked_at', unblocked_at))
            
        if unblocked_at__gt is not None:
            if isinstance(unblocked_at__gt, datetime):
                _query_params.append(
                    (
                        'unblocked_at__gt',
                        unblocked_at__gt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('unblocked_at__gt', unblocked_at__gt))
            
        if unblocked_at__gte is not None:
            if isinstance(unblocked_at__gte, datetime):
                _query_params.append(
                    (
                        'unblocked_at__gte',
                        unblocked_at__gte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('unblocked_at__gte', unblocked_at__gte))
            
        if unblocked_at__isnull is not None:
            
            _query_params.append(('unblocked_at__isnull', unblocked_at__isnull))
            
        if unblocked_at__lt is not None:
            if isinstance(unblocked_at__lt, datetime):
                _query_params.append(
                    (
                        'unblocked_at__lt',
                        unblocked_at__lt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('unblocked_at__lt', unblocked_at__lt))
            
        if unblocked_at__lte is not None:
            if isinstance(unblocked_at__lte, datetime):
                _query_params.append(
                    (
                        'unblocked_at__lte',
                        unblocked_at__lte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('unblocked_at__lte', unblocked_at__lte))
            
        if unblocked_at__range is not None:
            
            _query_params.append(('unblocked_at__range', unblocked_at__range))
            
        if worker is not None:
            
            _query_params.append(('worker', worker))
            
        if worker__in is not None:
            
            _query_params.append(('worker__in', worker__in))
            
        if worker__isnull is not None:
            
            _query_params.append(('worker__isnull', worker__isnull))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/pulp/{pulp_domain}/api/v3/tasks/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_roles(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ObjectRolesResponse:
        """List roles

        List roles assigned to this object.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ObjectRolesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_roles_with_http_info(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ObjectRolesResponse]:
        """List roles

        List roles assigned to this object.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ObjectRolesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_roles_without_preload_content(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List roles

        List roles assigned to this object.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ObjectRolesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_roles_serialize(
        self,
        task_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{task_href}list_roles/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def my_permissions(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MyPermissionsResponse:
        """List user permissions

        List permissions available to the current user on this object.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._my_permissions_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MyPermissionsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def my_permissions_with_http_info(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MyPermissionsResponse]:
        """List user permissions

        List permissions available to the current user on this object.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._my_permissions_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MyPermissionsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def my_permissions_without_preload_content(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List user permissions

        List permissions available to the current user on this object.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._my_permissions_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MyPermissionsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _my_permissions_serialize(
        self,
        task_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{task_href}my_permissions/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def profile_artifacts(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProfileArtifactResponse:
        """Fetch downloadable links for profile artifacts

        Return pre-signed URLs used for downloading raw profile artifacts.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._profile_artifacts_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProfileArtifactResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def profile_artifacts_with_http_info(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProfileArtifactResponse]:
        """Fetch downloadable links for profile artifacts

        Return pre-signed URLs used for downloading raw profile artifacts.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._profile_artifacts_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProfileArtifactResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def profile_artifacts_without_preload_content(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Fetch downloadable links for profile artifacts

        Return pre-signed URLs used for downloading raw profile artifacts.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._profile_artifacts_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProfileArtifactResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _profile_artifacts_serialize(
        self,
        task_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{task_href}profile_artifacts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def purge(
        self,
        purge: Purge,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """Purge Completed Tasks

        Trigger an asynchronous task that deletes completed tasks that finished prior to a specified timestamp.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param purge: (required)
        :type purge: Purge
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._purge_serialize(
            pulp_domain=pulp_domain,
            purge=purge,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def purge_with_http_info(
        self,
        purge: Purge,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """Purge Completed Tasks

        Trigger an asynchronous task that deletes completed tasks that finished prior to a specified timestamp.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param purge: (required)
        :type purge: Purge
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._purge_serialize(
            pulp_domain=pulp_domain,
            purge=purge,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def purge_without_preload_content(
        self,
        purge: Purge,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Purge Completed Tasks

        Trigger an asynchronous task that deletes completed tasks that finished prior to a specified timestamp.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param purge: (required)
        :type purge: Purge
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._purge_serialize(
            pulp_domain=pulp_domain,
            purge=purge,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _purge_serialize(
        self,
        pulp_domain,
        purge,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pulp_domain is not None:
            _path_params['pulp_domain'] = pulp_domain
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if purge is not None:
            _body_params = purge


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/pulp/{pulp_domain}/api/v3/tasks/purge/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TaskResponse:
        """Inspect a task

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TaskResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TaskResponse]:
        """Inspect a task

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TaskResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        task_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Inspect a task

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.

        :param task_href: (required)
        :type task_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            task_href=task_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TaskResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        task_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{task_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def remove_role(
        self,
        task_href: StrictStr,
        nested_role: NestedRole,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> NestedRoleResponse:
        """Remove a role

        Remove a role for this object from users/groups.

        :param task_href: (required)
        :type task_href: str
        :param nested_role: (required)
        :type nested_role: NestedRole
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_role_serialize(
            task_href=task_href,
            nested_role=nested_role,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "NestedRoleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def remove_role_with_http_info(
        self,
        task_href: StrictStr,
        nested_role: NestedRole,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[NestedRoleResponse]:
        """Remove a role

        Remove a role for this object from users/groups.

        :param task_href: (required)
        :type task_href: str
        :param nested_role: (required)
        :type nested_role: NestedRole
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_role_serialize(
            task_href=task_href,
            nested_role=nested_role,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "NestedRoleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def remove_role_without_preload_content(
        self,
        task_href: StrictStr,
        nested_role: NestedRole,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove a role

        Remove a role for this object from users/groups.

        :param task_href: (required)
        :type task_href: str
        :param nested_role: (required)
        :type nested_role: NestedRole
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_role_serialize(
            task_href=task_href,
            nested_role=nested_role,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "NestedRoleResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _remove_role_serialize(
        self,
        task_href,
        nested_role,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if nested_role is not None:
            _body_params = nested_role


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{task_href}remove_role/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def tasks_cancel(
        self,
        task_href: StrictStr,
        patched_task_cancel: PatchedTaskCancel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TaskResponse:
        """Cancel a task

        This operation cancels a task.

        :param task_href: (required)
        :type task_href: str
        :param patched_task_cancel: (required)
        :type patched_task_cancel: PatchedTaskCancel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._tasks_cancel_serialize(
            task_href=task_href,
            patched_task_cancel=patched_task_cancel,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TaskResponse",
            '409': "TaskResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def tasks_cancel_with_http_info(
        self,
        task_href: StrictStr,
        patched_task_cancel: PatchedTaskCancel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TaskResponse]:
        """Cancel a task

        This operation cancels a task.

        :param task_href: (required)
        :type task_href: str
        :param patched_task_cancel: (required)
        :type patched_task_cancel: PatchedTaskCancel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._tasks_cancel_serialize(
            task_href=task_href,
            patched_task_cancel=patched_task_cancel,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TaskResponse",
            '409': "TaskResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def tasks_cancel_without_preload_content(
        self,
        task_href: StrictStr,
        patched_task_cancel: PatchedTaskCancel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Cancel a task

        This operation cancels a task.

        :param task_href: (required)
        :type task_href: str
        :param patched_task_cancel: (required)
        :type patched_task_cancel: PatchedTaskCancel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._tasks_cancel_serialize(
            task_href=task_href,
            patched_task_cancel=patched_task_cancel,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TaskResponse",
            '409': "TaskResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _tasks_cancel_serialize(
        self,
        task_href,
        patched_task_cancel,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_href is not None:
            _path_params['task_href'] = task_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if patched_task_cancel is not None:
            _body_params = patched_task_cancel


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='{task_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


