# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from services-pulpcore-client.models.paginated_user_response_list import PaginatedUserResponseList
from services-pulpcore-client.models.patched_user import PatchedUser
from services-pulpcore-client.models.user import User
from services-pulpcore-client.models.user_response import UserResponse

from services-pulpcore-client.api_client import ApiClient, RequestSerialized
from services-pulpcore-client.api_response import ApiResponse
from services-pulpcore-client.rest import RESTResponseType


class UsersApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create(
        self,
        user: User,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UserResponse:
        """Create an user

        ViewSet for User.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param user: (required)
        :type user: User
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            pulp_domain=pulp_domain,
            user=user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_with_http_info(
        self,
        user: User,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UserResponse]:
        """Create an user

        ViewSet for User.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param user: (required)
        :type user: User
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            pulp_domain=pulp_domain,
            user=user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_without_preload_content(
        self,
        user: User,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create an user

        ViewSet for User.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param user: (required)
        :type user: User
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            pulp_domain=pulp_domain,
            user=user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_serialize(
        self,
        pulp_domain,
        user,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pulp_domain is not None:
            _path_params['pulp_domain'] = pulp_domain
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if user is not None:
            _body_params = user


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/pulp/{pulp_domain}/api/v3/users/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete(
        self,
        auth_user_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            auth_user_href=auth_user_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_with_http_info(
        self,
        auth_user_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            auth_user_href=auth_user_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_without_preload_content(
        self,
        auth_user_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            auth_user_href=auth_user_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_serialize(
        self,
        auth_user_href,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_user_href is not None:
            _path_params['auth_user_href'] = auth_user_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='{auth_user_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        email: Annotated[Optional[StrictStr], Field(description="Filter results where email matches value")] = None,
        email__contains: Annotated[Optional[StrictStr], Field(description="Filter results where email contains value")] = None,
        email__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where email contains value")] = None,
        email__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where email matches value")] = None,
        email__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where email is in a comma-separated list of values")] = None,
        first_name: Annotated[Optional[StrictStr], Field(description="Filter results where first_name matches value")] = None,
        first_name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where first_name contains value")] = None,
        first_name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where first_name contains value")] = None,
        first_name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where first_name matches value")] = None,
        first_name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where first_name is in a comma-separated list of values")] = None,
        is_active: Annotated[Optional[StrictBool], Field(description="Filter results where is_active matches value")] = None,
        is_staff: Annotated[Optional[StrictBool], Field(description="Filter results where is_staff matches value")] = None,
        last_name: Annotated[Optional[StrictStr], Field(description="Filter results where last_name matches value")] = None,
        last_name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where last_name contains value")] = None,
        last_name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where last_name contains value")] = None,
        last_name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where last_name matches value")] = None,
        last_name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where last_name is in a comma-separated list of values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `id` - Id * `-id` - Id (descending) * `password` - Password * `-password` - Password (descending) * `last_login` - Last login * `-last_login` - Last login (descending) * `is_superuser` - Is superuser * `-is_superuser` - Is superuser (descending) * `username` - Username * `-username` - Username (descending) * `first_name` - First name * `-first_name` - First name (descending) * `last_name` - Last name * `-last_name` - Last name (descending) * `email` - Email * `-email` - Email (descending) * `is_staff` - Is staff * `-is_staff` - Is staff (descending) * `is_active` - Is active * `-is_active` - Is active (descending) * `date_joined` - Date joined * `-date_joined` - Date joined (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        username: Annotated[Optional[StrictStr], Field(description="Filter results where username matches value")] = None,
        username__contains: Annotated[Optional[StrictStr], Field(description="Filter results where username contains value")] = None,
        username__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where username contains value")] = None,
        username__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where username matches value")] = None,
        username__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where username is in a comma-separated list of values")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedUserResponseList:
        """List users

        ViewSet for User.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param email: Filter results where email matches value
        :type email: str
        :param email__contains: Filter results where email contains value
        :type email__contains: str
        :param email__icontains: Filter results where email contains value
        :type email__icontains: str
        :param email__iexact: Filter results where email matches value
        :type email__iexact: str
        :param email__in: Filter results where email is in a comma-separated list of values
        :type email__in: List[str]
        :param first_name: Filter results where first_name matches value
        :type first_name: str
        :param first_name__contains: Filter results where first_name contains value
        :type first_name__contains: str
        :param first_name__icontains: Filter results where first_name contains value
        :type first_name__icontains: str
        :param first_name__iexact: Filter results where first_name matches value
        :type first_name__iexact: str
        :param first_name__in: Filter results where first_name is in a comma-separated list of values
        :type first_name__in: List[str]
        :param is_active: Filter results where is_active matches value
        :type is_active: bool
        :param is_staff: Filter results where is_staff matches value
        :type is_staff: bool
        :param last_name: Filter results where last_name matches value
        :type last_name: str
        :param last_name__contains: Filter results where last_name contains value
        :type last_name__contains: str
        :param last_name__icontains: Filter results where last_name contains value
        :type last_name__icontains: str
        :param last_name__iexact: Filter results where last_name matches value
        :type last_name__iexact: str
        :param last_name__in: Filter results where last_name is in a comma-separated list of values
        :type last_name__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `id` - Id * `-id` - Id (descending) * `password` - Password * `-password` - Password (descending) * `last_login` - Last login * `-last_login` - Last login (descending) * `is_superuser` - Is superuser * `-is_superuser` - Is superuser (descending) * `username` - Username * `-username` - Username (descending) * `first_name` - First name * `-first_name` - First name (descending) * `last_name` - Last name * `-last_name` - Last name (descending) * `email` - Email * `-email` - Email (descending) * `is_staff` - Is staff * `-is_staff` - Is staff (descending) * `is_active` - Is active * `-is_active` - Is active (descending) * `date_joined` - Date joined * `-date_joined` - Date joined (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param username: Filter results where username matches value
        :type username: str
        :param username__contains: Filter results where username contains value
        :type username__contains: str
        :param username__icontains: Filter results where username contains value
        :type username__icontains: str
        :param username__iexact: Filter results where username matches value
        :type username__iexact: str
        :param username__in: Filter results where username is in a comma-separated list of values
        :type username__in: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            email=email,
            email__contains=email__contains,
            email__icontains=email__icontains,
            email__iexact=email__iexact,
            email__in=email__in,
            first_name=first_name,
            first_name__contains=first_name__contains,
            first_name__icontains=first_name__icontains,
            first_name__iexact=first_name__iexact,
            first_name__in=first_name__in,
            is_active=is_active,
            is_staff=is_staff,
            last_name=last_name,
            last_name__contains=last_name__contains,
            last_name__icontains=last_name__icontains,
            last_name__iexact=last_name__iexact,
            last_name__in=last_name__in,
            limit=limit,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            q=q,
            username=username,
            username__contains=username__contains,
            username__icontains=username__icontains,
            username__iexact=username__iexact,
            username__in=username__in,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        email: Annotated[Optional[StrictStr], Field(description="Filter results where email matches value")] = None,
        email__contains: Annotated[Optional[StrictStr], Field(description="Filter results where email contains value")] = None,
        email__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where email contains value")] = None,
        email__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where email matches value")] = None,
        email__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where email is in a comma-separated list of values")] = None,
        first_name: Annotated[Optional[StrictStr], Field(description="Filter results where first_name matches value")] = None,
        first_name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where first_name contains value")] = None,
        first_name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where first_name contains value")] = None,
        first_name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where first_name matches value")] = None,
        first_name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where first_name is in a comma-separated list of values")] = None,
        is_active: Annotated[Optional[StrictBool], Field(description="Filter results where is_active matches value")] = None,
        is_staff: Annotated[Optional[StrictBool], Field(description="Filter results where is_staff matches value")] = None,
        last_name: Annotated[Optional[StrictStr], Field(description="Filter results where last_name matches value")] = None,
        last_name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where last_name contains value")] = None,
        last_name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where last_name contains value")] = None,
        last_name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where last_name matches value")] = None,
        last_name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where last_name is in a comma-separated list of values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `id` - Id * `-id` - Id (descending) * `password` - Password * `-password` - Password (descending) * `last_login` - Last login * `-last_login` - Last login (descending) * `is_superuser` - Is superuser * `-is_superuser` - Is superuser (descending) * `username` - Username * `-username` - Username (descending) * `first_name` - First name * `-first_name` - First name (descending) * `last_name` - Last name * `-last_name` - Last name (descending) * `email` - Email * `-email` - Email (descending) * `is_staff` - Is staff * `-is_staff` - Is staff (descending) * `is_active` - Is active * `-is_active` - Is active (descending) * `date_joined` - Date joined * `-date_joined` - Date joined (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        username: Annotated[Optional[StrictStr], Field(description="Filter results where username matches value")] = None,
        username__contains: Annotated[Optional[StrictStr], Field(description="Filter results where username contains value")] = None,
        username__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where username contains value")] = None,
        username__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where username matches value")] = None,
        username__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where username is in a comma-separated list of values")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedUserResponseList]:
        """List users

        ViewSet for User.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param email: Filter results where email matches value
        :type email: str
        :param email__contains: Filter results where email contains value
        :type email__contains: str
        :param email__icontains: Filter results where email contains value
        :type email__icontains: str
        :param email__iexact: Filter results where email matches value
        :type email__iexact: str
        :param email__in: Filter results where email is in a comma-separated list of values
        :type email__in: List[str]
        :param first_name: Filter results where first_name matches value
        :type first_name: str
        :param first_name__contains: Filter results where first_name contains value
        :type first_name__contains: str
        :param first_name__icontains: Filter results where first_name contains value
        :type first_name__icontains: str
        :param first_name__iexact: Filter results where first_name matches value
        :type first_name__iexact: str
        :param first_name__in: Filter results where first_name is in a comma-separated list of values
        :type first_name__in: List[str]
        :param is_active: Filter results where is_active matches value
        :type is_active: bool
        :param is_staff: Filter results where is_staff matches value
        :type is_staff: bool
        :param last_name: Filter results where last_name matches value
        :type last_name: str
        :param last_name__contains: Filter results where last_name contains value
        :type last_name__contains: str
        :param last_name__icontains: Filter results where last_name contains value
        :type last_name__icontains: str
        :param last_name__iexact: Filter results where last_name matches value
        :type last_name__iexact: str
        :param last_name__in: Filter results where last_name is in a comma-separated list of values
        :type last_name__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `id` - Id * `-id` - Id (descending) * `password` - Password * `-password` - Password (descending) * `last_login` - Last login * `-last_login` - Last login (descending) * `is_superuser` - Is superuser * `-is_superuser` - Is superuser (descending) * `username` - Username * `-username` - Username (descending) * `first_name` - First name * `-first_name` - First name (descending) * `last_name` - Last name * `-last_name` - Last name (descending) * `email` - Email * `-email` - Email (descending) * `is_staff` - Is staff * `-is_staff` - Is staff (descending) * `is_active` - Is active * `-is_active` - Is active (descending) * `date_joined` - Date joined * `-date_joined` - Date joined (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param username: Filter results where username matches value
        :type username: str
        :param username__contains: Filter results where username contains value
        :type username__contains: str
        :param username__icontains: Filter results where username contains value
        :type username__icontains: str
        :param username__iexact: Filter results where username matches value
        :type username__iexact: str
        :param username__in: Filter results where username is in a comma-separated list of values
        :type username__in: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            email=email,
            email__contains=email__contains,
            email__icontains=email__icontains,
            email__iexact=email__iexact,
            email__in=email__in,
            first_name=first_name,
            first_name__contains=first_name__contains,
            first_name__icontains=first_name__icontains,
            first_name__iexact=first_name__iexact,
            first_name__in=first_name__in,
            is_active=is_active,
            is_staff=is_staff,
            last_name=last_name,
            last_name__contains=last_name__contains,
            last_name__icontains=last_name__icontains,
            last_name__iexact=last_name__iexact,
            last_name__in=last_name__in,
            limit=limit,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            q=q,
            username=username,
            username__contains=username__contains,
            username__icontains=username__icontains,
            username__iexact=username__iexact,
            username__in=username__in,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        email: Annotated[Optional[StrictStr], Field(description="Filter results where email matches value")] = None,
        email__contains: Annotated[Optional[StrictStr], Field(description="Filter results where email contains value")] = None,
        email__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where email contains value")] = None,
        email__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where email matches value")] = None,
        email__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where email is in a comma-separated list of values")] = None,
        first_name: Annotated[Optional[StrictStr], Field(description="Filter results where first_name matches value")] = None,
        first_name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where first_name contains value")] = None,
        first_name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where first_name contains value")] = None,
        first_name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where first_name matches value")] = None,
        first_name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where first_name is in a comma-separated list of values")] = None,
        is_active: Annotated[Optional[StrictBool], Field(description="Filter results where is_active matches value")] = None,
        is_staff: Annotated[Optional[StrictBool], Field(description="Filter results where is_staff matches value")] = None,
        last_name: Annotated[Optional[StrictStr], Field(description="Filter results where last_name matches value")] = None,
        last_name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where last_name contains value")] = None,
        last_name__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where last_name contains value")] = None,
        last_name__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where last_name matches value")] = None,
        last_name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where last_name is in a comma-separated list of values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `id` - Id * `-id` - Id (descending) * `password` - Password * `-password` - Password (descending) * `last_login` - Last login * `-last_login` - Last login (descending) * `is_superuser` - Is superuser * `-is_superuser` - Is superuser (descending) * `username` - Username * `-username` - Username (descending) * `first_name` - First name * `-first_name` - First name (descending) * `last_name` - Last name * `-last_name` - Last name (descending) * `email` - Email * `-email` - Email (descending) * `is_staff` - Is staff * `-is_staff` - Is staff (descending) * `is_active` - Is active * `-is_active` - Is active (descending) * `date_joined` - Date joined * `-date_joined` - Date joined (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        username: Annotated[Optional[StrictStr], Field(description="Filter results where username matches value")] = None,
        username__contains: Annotated[Optional[StrictStr], Field(description="Filter results where username contains value")] = None,
        username__icontains: Annotated[Optional[StrictStr], Field(description="Filter results where username contains value")] = None,
        username__iexact: Annotated[Optional[StrictStr], Field(description="Filter results where username matches value")] = None,
        username__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where username is in a comma-separated list of values")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List users

        ViewSet for User.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param email: Filter results where email matches value
        :type email: str
        :param email__contains: Filter results where email contains value
        :type email__contains: str
        :param email__icontains: Filter results where email contains value
        :type email__icontains: str
        :param email__iexact: Filter results where email matches value
        :type email__iexact: str
        :param email__in: Filter results where email is in a comma-separated list of values
        :type email__in: List[str]
        :param first_name: Filter results where first_name matches value
        :type first_name: str
        :param first_name__contains: Filter results where first_name contains value
        :type first_name__contains: str
        :param first_name__icontains: Filter results where first_name contains value
        :type first_name__icontains: str
        :param first_name__iexact: Filter results where first_name matches value
        :type first_name__iexact: str
        :param first_name__in: Filter results where first_name is in a comma-separated list of values
        :type first_name__in: List[str]
        :param is_active: Filter results where is_active matches value
        :type is_active: bool
        :param is_staff: Filter results where is_staff matches value
        :type is_staff: bool
        :param last_name: Filter results where last_name matches value
        :type last_name: str
        :param last_name__contains: Filter results where last_name contains value
        :type last_name__contains: str
        :param last_name__icontains: Filter results where last_name contains value
        :type last_name__icontains: str
        :param last_name__iexact: Filter results where last_name matches value
        :type last_name__iexact: str
        :param last_name__in: Filter results where last_name is in a comma-separated list of values
        :type last_name__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `id` - Id * `-id` - Id (descending) * `password` - Password * `-password` - Password (descending) * `last_login` - Last login * `-last_login` - Last login (descending) * `is_superuser` - Is superuser * `-is_superuser` - Is superuser (descending) * `username` - Username * `-username` - Username (descending) * `first_name` - First name * `-first_name` - First name (descending) * `last_name` - Last name * `-last_name` - Last name (descending) * `email` - Email * `-email` - Email (descending) * `is_staff` - Is staff * `-is_staff` - Is staff (descending) * `is_active` - Is active * `-is_active` - Is active (descending) * `date_joined` - Date joined * `-date_joined` - Date joined (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param username: Filter results where username matches value
        :type username: str
        :param username__contains: Filter results where username contains value
        :type username__contains: str
        :param username__icontains: Filter results where username contains value
        :type username__icontains: str
        :param username__iexact: Filter results where username matches value
        :type username__iexact: str
        :param username__in: Filter results where username is in a comma-separated list of values
        :type username__in: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            email=email,
            email__contains=email__contains,
            email__icontains=email__icontains,
            email__iexact=email__iexact,
            email__in=email__in,
            first_name=first_name,
            first_name__contains=first_name__contains,
            first_name__icontains=first_name__icontains,
            first_name__iexact=first_name__iexact,
            first_name__in=first_name__in,
            is_active=is_active,
            is_staff=is_staff,
            last_name=last_name,
            last_name__contains=last_name__contains,
            last_name__icontains=last_name__icontains,
            last_name__iexact=last_name__iexact,
            last_name__in=last_name__in,
            limit=limit,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            q=q,
            username=username,
            username__contains=username__contains,
            username__icontains=username__icontains,
            username__iexact=username__iexact,
            username__in=username__in,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        pulp_domain,
        x_task_diagnostics,
        email,
        email__contains,
        email__icontains,
        email__iexact,
        email__in,
        first_name,
        first_name__contains,
        first_name__icontains,
        first_name__iexact,
        first_name__in,
        is_active,
        is_staff,
        last_name,
        last_name__contains,
        last_name__icontains,
        last_name__iexact,
        last_name__in,
        limit,
        offset,
        ordering,
        prn__in,
        pulp_href__in,
        pulp_id__in,
        q,
        username,
        username__contains,
        username__icontains,
        username__iexact,
        username__in,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'email__in': 'csv',
            'first_name__in': 'csv',
            'last_name__in': 'csv',
            'ordering': 'csv',
            'prn__in': 'csv',
            'pulp_href__in': 'csv',
            'pulp_id__in': 'csv',
            'username__in': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pulp_domain is not None:
            _path_params['pulp_domain'] = pulp_domain
        # process the query parameters
        if email is not None:
            
            _query_params.append(('email', email))
            
        if email__contains is not None:
            
            _query_params.append(('email__contains', email__contains))
            
        if email__icontains is not None:
            
            _query_params.append(('email__icontains', email__icontains))
            
        if email__iexact is not None:
            
            _query_params.append(('email__iexact', email__iexact))
            
        if email__in is not None:
            
            _query_params.append(('email__in', email__in))
            
        if first_name is not None:
            
            _query_params.append(('first_name', first_name))
            
        if first_name__contains is not None:
            
            _query_params.append(('first_name__contains', first_name__contains))
            
        if first_name__icontains is not None:
            
            _query_params.append(('first_name__icontains', first_name__icontains))
            
        if first_name__iexact is not None:
            
            _query_params.append(('first_name__iexact', first_name__iexact))
            
        if first_name__in is not None:
            
            _query_params.append(('first_name__in', first_name__in))
            
        if is_active is not None:
            
            _query_params.append(('is_active', is_active))
            
        if is_staff is not None:
            
            _query_params.append(('is_staff', is_staff))
            
        if last_name is not None:
            
            _query_params.append(('last_name', last_name))
            
        if last_name__contains is not None:
            
            _query_params.append(('last_name__contains', last_name__contains))
            
        if last_name__icontains is not None:
            
            _query_params.append(('last_name__icontains', last_name__icontains))
            
        if last_name__iexact is not None:
            
            _query_params.append(('last_name__iexact', last_name__iexact))
            
        if last_name__in is not None:
            
            _query_params.append(('last_name__in', last_name__in))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if pulp_id__in is not None:
            
            _query_params.append(('pulp_id__in', pulp_id__in))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if username__contains is not None:
            
            _query_params.append(('username__contains', username__contains))
            
        if username__icontains is not None:
            
            _query_params.append(('username__icontains', username__icontains))
            
        if username__iexact is not None:
            
            _query_params.append(('username__iexact', username__iexact))
            
        if username__in is not None:
            
            _query_params.append(('username__in', username__in))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/pulp/{pulp_domain}/api/v3/users/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def partial_update(
        self,
        auth_user_href: StrictStr,
        patched_user: PatchedUser,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UserResponse:
        """Update an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param patched_user: (required)
        :type patched_user: PatchedUser
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._partial_update_serialize(
            auth_user_href=auth_user_href,
            patched_user=patched_user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def partial_update_with_http_info(
        self,
        auth_user_href: StrictStr,
        patched_user: PatchedUser,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UserResponse]:
        """Update an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param patched_user: (required)
        :type patched_user: PatchedUser
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._partial_update_serialize(
            auth_user_href=auth_user_href,
            patched_user=patched_user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def partial_update_without_preload_content(
        self,
        auth_user_href: StrictStr,
        patched_user: PatchedUser,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param patched_user: (required)
        :type patched_user: PatchedUser
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._partial_update_serialize(
            auth_user_href=auth_user_href,
            patched_user=patched_user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _partial_update_serialize(
        self,
        auth_user_href,
        patched_user,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_user_href is not None:
            _path_params['auth_user_href'] = auth_user_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if patched_user is not None:
            _body_params = patched_user


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='{auth_user_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read(
        self,
        auth_user_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UserResponse:
        """Inspect an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            auth_user_href=auth_user_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        auth_user_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UserResponse]:
        """Inspect an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            auth_user_href=auth_user_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        auth_user_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Inspect an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            auth_user_href=auth_user_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        auth_user_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_user_href is not None:
            _path_params['auth_user_href'] = auth_user_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{auth_user_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update(
        self,
        auth_user_href: StrictStr,
        user: User,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UserResponse:
        """Update an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param user: (required)
        :type user: User
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_serialize(
            auth_user_href=auth_user_href,
            user=user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_with_http_info(
        self,
        auth_user_href: StrictStr,
        user: User,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UserResponse]:
        """Update an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param user: (required)
        :type user: User
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_serialize(
            auth_user_href=auth_user_href,
            user=user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_without_preload_content(
        self,
        auth_user_href: StrictStr,
        user: User,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an user

        ViewSet for User.

        :param auth_user_href: (required)
        :type auth_user_href: str
        :param user: (required)
        :type user: User
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_serialize(
            auth_user_href=auth_user_href,
            user=user,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_serialize(
        self,
        auth_user_href,
        user,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_user_href is not None:
            _path_params['auth_user_href'] = auth_user_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if user is not None:
            _body_params = user


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='{auth_user_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


