# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from services-pulpcore-client.models.generic_remote_response_hidden_fields_inner import GenericRemoteResponseHiddenFieldsInner
from services-pulpcore-client.models.user_group_response import UserGroupResponse
from typing import Optional, Set
from typing_extensions import Self

class UserResponse(BaseModel):
    """
    Serializer for User.
    """ # noqa: E501
    pulp_href: Optional[StrictStr] = None
    prn: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    username: Annotated[str, Field(strict=True, max_length=150)] = Field(description="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    first_name: Optional[Annotated[str, Field(strict=True, max_length=150)]] = Field(default=None, description="First name")
    last_name: Optional[Annotated[str, Field(strict=True, max_length=150)]] = Field(default=None, description="Last name")
    email: Optional[StrictStr] = Field(default=None, description="Email address")
    is_staff: Optional[StrictBool] = Field(default=False, description="Designates whether the user can log into this admin site.")
    is_active: Optional[StrictBool] = Field(default=True, description="Designates whether this user should be treated as active.")
    date_joined: Optional[datetime] = Field(default=None, description="Date joined")
    groups: Optional[List[UserGroupResponse]] = None
    hidden_fields: Optional[List[GenericRemoteResponseHiddenFieldsInner]] = Field(default=None, description="List of hidden (write only) fields")
    __properties: ClassVar[List[str]] = ["pulp_href", "prn", "id", "username", "first_name", "last_name", "email", "is_staff", "is_active", "date_joined", "groups", "hidden_fields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pulp_href",
            "prn",
            "id",
            "date_joined",
            "groups",
            "hidden_fields",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in hidden_fields (list)
        _items = []
        if self.hidden_fields:
            for _item_hidden_fields in self.hidden_fields:
                if _item_hidden_fields:
                    _items.append(_item_hidden_fields.to_dict())
            _dict['hidden_fields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_href": obj.get("pulp_href"),
            "prn": obj.get("prn"),
            "id": obj.get("id"),
            "username": obj.get("username"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email": obj.get("email"),
            "is_staff": obj.get("is_staff") if obj.get("is_staff") is not None else False,
            "is_active": obj.get("is_active") if obj.get("is_active") is not None else True,
            "date_joined": obj.get("date_joined"),
            "groups": [UserGroupResponse.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "hidden_fields": [GenericRemoteResponseHiddenFieldsInner.from_dict(_item) for _item in obj["hidden_fields"]] if obj.get("hidden_fields") is not None else None
        })
        return _obj


