#!/bin/sh
#
# geninfocontrib_h.sh - infocontrib.h generator script
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>

# use system echo as it supports backslash expansion
ECHO=/bin/echo

$ECHO "/*"
$ECHO " * infocontrib.h - Text of contributors to VICE, as used in info.c"
$ECHO " *"
$ECHO " * Autogenerated by geninfocontrib_h.sh, DO NOT EDIT !!!"
$ECHO " *"
$ECHO " * Written by"
$ECHO " *  Marco van den Heuvel <blackystardust68@yahoo.com>"
$ECHO " *"
$ECHO " * This file is part of VICE, the Versatile Commodore Emulator."
$ECHO " * See README for copyright notice."
$ECHO " *"
$ECHO " *  This program is free software; you can redistribute it and/or modify"
$ECHO " *  it under the terms of the GNU General Public License as published by"
$ECHO " *  the Free Software Foundation; either version 2 of the License, or"
$ECHO " *  (at your option) any later version."
$ECHO " *"
$ECHO " *  This program is distributed in the hope that it will be useful,"
$ECHO " *  but WITHOUT ANY WARRANTY; without even the implied warranty of"
$ECHO " *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
$ECHO " *  GNU General Public License for more details."
$ECHO " *"
$ECHO " *  You should have received a copy of the GNU General Public License"
$ECHO " *  along with this program; if not, write to the Free Software"
$ECHO " *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA"
$ECHO " *  02111-1307  USA."
$ECHO " *"
$ECHO " */"
$ECHO ""
$ECHO "#ifndef VICE_INFOCONTRIB_H"
$ECHO "#define VICE_INFOCONTRIB_H"
$ECHO ""
$ECHO "const char info_contrib_text[] ="

checkoutput()
{
  dooutput=yes
  case "$data" in
      @c*|"@itemize @bullet"|@item|"@end itemize") dooutput=no ;;
  esac
}

outputok=no
while read data
do
  if test x"$data" = "x@node Copyright, Contacts, Acknowledgments, Top"; then
    $ECHO "\"\\n\";"
    $ECHO "#endif"
    outputok=no
  fi
  if test x"$outputok" = "xyes"; then
    checkoutput
    if test x"$dooutput" = "xyes"; then
      if test x"$data" = "x"; then
        $ECHO "\"\\n\""
      else
        $ECHO "\"  $data\\n\""
      fi
    fi
  fi
  if test x"$data" = "x@chapter Acknowledgments"; then
    outputok=yes
  fi
done
