"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const iam = require("../lib");
test('use of cross-stack role reference does not lead to URLSuffix being exported', () => {
    // GIVEN
    const app = new core_1.App();
    const first = new core_1.Stack(app, 'First');
    const second = new core_1.Stack(app, 'Second');
    // WHEN
    const role = new iam.Role(first, 'Role', {
        assumedBy: new iam.ServicePrincipal('s3.amazonaws.com')
    });
    new core_1.CfnOutput(second, 'Output', {
        value: role.roleArn
    });
    // THEN
    app.synth();
    expect(first).toMatchTemplate({
        Resources: {
            Role1ABCC5F0: {
                Type: "AWS::IAM::Role",
                Properties: {
                    AssumeRolePolicyDocument: {
                        Statement: [
                            {
                                Action: "sts:AssumeRole",
                                Effect: "Allow",
                                Principal: { Service: "s3.amazonaws.com" }
                            }
                        ],
                        Version: "2012-10-17"
                    }
                }
            }
        },
        Outputs: {
            ExportsOutputFnGetAttRole1ABCC5F0ArnB4C0B73E: {
                Value: { "Fn::GetAtt": ["Role1ABCC5F0", "Arn"] },
                Export: {
                    Name: "First:ExportsOutputFnGetAttRole1ABCC5F0ArnB4C0B73E"
                }
            }
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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