/*
 * Decompiled with CFR 0.152.
 */
package utils;

import config.Config;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.TaskRunner;
import utils.TaskRunnerKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015J\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lutils/TaskRunner;", "", "()V", "DEFAULT_TIMEOUT_SECS", "", "getDEFAULT_TIMEOUT_SECS", "()I", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "subExecutor", "getSubExecutor", "addTask", "", "task", "Ljava/lang/Runnable;", "name", "", "addTaskAndWait", "Ljava/util/concurrent/Callable;", "bye", "runInThread", "Shared"})
public final class TaskRunner {
    @NotNull
    public static final TaskRunner INSTANCE = new TaskRunner();
    private static final int DEFAULT_TIMEOUT_SECS = ((Number)Config.INSTANCE.getSimpleTaskTimeout().get()).intValue();
    private static final ExecutorService executor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() - 2));
    private static final ExecutorService subExecutor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() - 2));

    private TaskRunner() {
    }

    public final int getDEFAULT_TIMEOUT_SECS() {
        return DEFAULT_TIMEOUT_SECS;
    }

    public final ExecutorService getExecutor() {
        return executor;
    }

    public final ExecutorService getSubExecutor() {
        return subExecutor;
    }

    public final void runInThread(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(task, "task");
        new Thread(task).start();
    }

    public final void addTask(@NotNull Runnable task, @NotNull String name) {
        Intrinsics.checkNotNullParameter(task, "task");
        Intrinsics.checkNotNullParameter(name, "name");
        Function0 wrappingTask2 = new Function0<Unit>(task, name){
            final /* synthetic */ Runnable $task;
            final /* synthetic */ String $name;
            {
                this.$task = $task;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$task.run();
                }
                catch (InterruptedException interrupt) {
                    TaskRunnerKt.access$getLogger$p().info((Function0<? extends Object>)new Function0<Object>(interrupt){
                        final /* synthetic */ InterruptedException $interrupt;
                        {
                            this.$interrupt = $interrupt;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            return "Got interrupt " + this.$interrupt;
                        }
                    });
                }
                catch (Exception t) {
                    TaskRunnerKt.access$getLogger$p().error((Throwable)t, (Function0<? extends Object>)new Function0<Object>(this.$name){
                        final /* synthetic */ String $name;
                        {
                            this.$name = $name;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            return "Task " + this.$name + " had error";
                        }
                    });
                }
            }
        };
        try {
            executor.submit(() -> TaskRunner.addTask$lambda-0(wrappingTask2));
        }
        catch (RejectedExecutionException e) {
            TaskRunnerKt.access$getLogger$p().error((Throwable)e, (Function0<? extends Object>)new Function0<Object>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Rejected task " + this.$name;
                }
            });
        }
    }

    @NotNull
    public final String addTaskAndWait(@NotNull Callable<String> task) {
        Intrinsics.checkNotNullParameter(task, "task");
        Function0 wrappingTask2 = new Function0<String>(task){
            final /* synthetic */ Callable<String> $task;
            {
                this.$task = $task;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string;
                try {
                    string = this.$task.call();
                }
                catch (InterruptedException interrupt) {
                    TaskRunnerKt.access$getLogger$p().info((Function0<? extends Object>)new Function0<Object>(interrupt){
                        final /* synthetic */ InterruptedException $interrupt;
                        {
                            this.$interrupt = $interrupt;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            return "Got interrupt " + this.$interrupt;
                        }
                    });
                    string = null;
                }
                return string;
            }
        };
        Future<String> futureResult = subExecutor.submit(() -> TaskRunner.addTaskAndWait$lambda-1(wrappingTask2));
        try {
            String result2 = futureResult.get(DEFAULT_TIMEOUT_SECS, TimeUnit.SECONDS);
            if (result2 != null) {
                return result2;
            }
            return "GraphViz timed out";
        }
        catch (Exception e) {
            TaskRunnerKt.access$getLogger$p().info((Function0<? extends Object>)new Function0<Object>(e){
                final /* synthetic */ Exception $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Got exception " + this.$e + " when getting future result";
                }
            });
            return "GraphViz timed out";
        }
    }

    public final void bye() {
        TaskRunnerKt.access$getLogger$p().info(bye.1.INSTANCE);
        Ref.LongRef currentCompleted1 = new Ref.LongRef();
        currentCompleted1.element = TaskRunner.bye$getCompletedCount1();
        Ref.LongRef currentCompleted2 = new Ref.LongRef();
        currentCompleted2.element = TaskRunner.bye$getCompletedCount2();
        Ref.IntRef attemptNumber = new Ref.IntRef();
        attemptNumber.element = 1;
        while (!(Thread.interrupted() || currentCompleted1.element <= 0L && currentCompleted2.element <= 0L && attemptNumber.element > 5)) {
            Thread.sleep((long)((Number)Config.INSTANCE.getPatienceSeconds().get()).intValue() * (long)1000);
            long newCompleted1 = TaskRunner.bye$getCompletedCount1();
            long newCompleted2 = TaskRunner.bye$getCompletedCount2();
            if ((TaskRunner.bye$getCurrentActive1() != 0 || TaskRunner.bye$getCurrentActive2() != 0) && currentCompleted1.element == newCompleted1 && currentCompleted2.element == newCompleted2) {
                TaskRunnerKt.access$getLogger$p().info((Function0<? extends Object>)new Function0<Object>(currentCompleted1, newCompleted1, currentCompleted2, newCompleted2, attemptNumber){
                    final /* synthetic */ Ref.LongRef $currentCompleted1;
                    final /* synthetic */ long $newCompleted1;
                    final /* synthetic */ Ref.LongRef $currentCompleted2;
                    final /* synthetic */ long $newCompleted2;
                    final /* synthetic */ Ref.IntRef $attemptNumber;
                    {
                        this.$currentCompleted1 = $currentCompleted1;
                        this.$newCompleted1 = $newCompleted1;
                        this.$currentCompleted2 = $currentCompleted2;
                        this.$newCompleted2 = $newCompleted2;
                        this.$attemptNumber = $attemptNumber;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Not all tasks may have ended in time. (1) Completed (before,after) the wait (" + this.$currentCompleted1.element + "," + this.$newCompleted1 + "), (2) Completed (before,after) the wait (" + this.$currentCompleted2.element + "," + this.$newCompleted2 + "). Active: (1) " + TaskRunner.access$bye$getCurrentActive1() + ", (2) " + TaskRunner.access$bye$getCurrentActive2() + ". Attempt number " + this.$attemptNumber.element;
                    }
                });
                if (attemptNumber.element > 5) break;
                ++attemptNumber.element;
                int cfr_ignored_0 = attemptNumber.element;
            } else {
                currentCompleted1.element = newCompleted1;
                currentCompleted2.element = newCompleted2;
            }
            if (TaskRunner.bye$getCurrentActive1() != 0 || TaskRunner.bye$getCurrentActive2() != 0) continue;
            TaskRunnerKt.access$getLogger$p().info(bye.3.INSTANCE);
            break;
        }
        executor.shutdownNow();
        subExecutor.shutdownNow();
    }

    private static final void addTask$lambda-0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke();
    }

    private static final String addTaskAndWait$lambda-1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke();
    }

    private static final int bye$getCurrentActive1() {
        ExecutorService executorService2 = executor;
        if (executorService2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.concurrent.ThreadPoolExecutor");
        }
        return ((ThreadPoolExecutor)executorService2).getActiveCount();
    }

    private static final int bye$getCurrentActive2() {
        ExecutorService executorService2 = subExecutor;
        if (executorService2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.concurrent.ThreadPoolExecutor");
        }
        return ((ThreadPoolExecutor)executorService2).getActiveCount();
    }

    private static final long bye$getCompletedCount1() {
        ExecutorService executorService2 = executor;
        if (executorService2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.concurrent.ThreadPoolExecutor");
        }
        return ((ThreadPoolExecutor)executorService2).getCompletedTaskCount();
    }

    private static final long bye$getCompletedCount2() {
        ExecutorService executorService2 = subExecutor;
        if (executorService2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.concurrent.ThreadPoolExecutor");
        }
        return ((ThreadPoolExecutor)executorService2).getCompletedTaskCount();
    }

    public static final /* synthetic */ int access$bye$getCurrentActive1() {
        return TaskRunner.bye$getCurrentActive1();
    }

    public static final /* synthetic */ int access$bye$getCurrentActive2() {
        return TaskRunner.bye$getCurrentActive2();
    }

    static {
        TaskRunnerKt.access$getLogger$p().info(1.INSTANCE);
    }
}

