/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.PersistentStack;
import datastructures.PersistentStackKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0003\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldatastructures/LinkedPersistentStack;", "T", "Ldatastructures/PersistentStack;", "top", "size", "", "next", "(Ljava/lang/Object;ILdatastructures/PersistentStack;)V", "getSize", "()I", "getTop", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "isEmpty", "pop", "push", "value", "(Ljava/lang/Object;)Ldatastructures/PersistentStack;", "toString", "", "GeneralUtils"})
final class LinkedPersistentStack<T>
implements PersistentStack<T> {
    private final T top;
    private final int size;
    @NotNull
    private final PersistentStack<T> next;

    public LinkedPersistentStack(T top, int size, @NotNull PersistentStack<T> next) {
        Intrinsics.checkNotNullParameter(next, "next");
        this.top = top;
        this.size = size;
        this.next = next;
    }

    @Override
    public T getTop() {
        return this.top;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public PersistentStack<T> pop() {
        return this.next;
    }

    @Override
    @NotNull
    public PersistentStack<T> push(T value2) {
        return new LinkedPersistentStack<T>(value2, this.getSize() + 1, this);
    }

    public boolean equals(@Nullable Object other) {
        return PersistentStackKt.access$persistentStackEquals(this, other);
    }

    public int hashCode() {
        return PersistentStackKt.access$persistentStackHashCode(this);
    }

    @NotNull
    public String toString() {
        return PersistentStackKt.access$persistentStackToString(this);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return PersistentStack.DefaultImpls.iterator(this);
    }

    @Override
    @NotNull
    public PersistentStack.Builder<T> builder() {
        return PersistentStack.DefaultImpls.builder(this);
    }
}

