/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import algorithms.TopologicalOrderException;
import algorithms.TopologicalSortKt;
import datastructures.stdcollections.IterablesKt;
import datastructures.stdcollections.MapsKt;
import datastructures.stdcollections.SetsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpModifiesReads;
import spec.cvlast.CVLGhostFunction;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.MonadicCVLAstTransformer;
import spec.cvlast.MonadicCVLCmdTransformer;
import spec.cvlast.ResolvedCallableName;
import spec.cvlast.monadiccvlexptransformer.MonadicSelfCVLExpTransformer;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lspec/cvlast/DefinitionDependencyChecker;", "Lspec/cvlast/MonadicCVLAstTransformer;", "Lspec/cvlast/typechecker/CVLError;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "(Lspec/cvlast/CVLSymbolTable;)V", "getSymbolTable", "()Lspec/cvlast/CVLSymbolTable;", "defs", "Lutils/CollectingResult;", "", "Lspec/cvlast/CVLDefinition;", "Shared"})
public final class DefinitionDependencyChecker
extends MonadicCVLAstTransformer<CVLError> {
    @NotNull
    private final CVLSymbolTable symbolTable;

    public DefinitionDependencyChecker(@NotNull CVLSymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        super(new MonadicCVLCmdTransformer(new MonadicSelfCVLExpTransformer()));
        this.symbolTable = symbolTable;
    }

    @NotNull
    public final CVLSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CollectingResult<List<CVLDefinition>, CVLError> defs(@NotNull List<CVLDefinition> defs2) {
        CollectingResult collectingResult;
        Intrinsics.checkNotNullParameter(defs2, "defs");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Object element$iv2;
            Map definitionDependencies = MapsKt.mutableMapOf();
            Map<CVLDefinition, CVLDefinition> astDefinitionVersion = MapsKt.mutableMapOf();
            Iterable $this$forEach$iv = defs2;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                CVLDefinition definition2 = (CVLDefinition)element$iv2;
                boolean bl = false;
                CVLSymbolTable cVLSymbolTable = this.getSymbolTable();
                String string = definition2.getId();
                CVLScope cVLScope = definition2.getScope();
                Intrinsics.checkNotNull(cVLScope);
                CVLSymbolTable.SymbolInfo symbolInfo = cVLSymbolTable.lookUpFunctionLikeSymbol(string, cVLScope);
                Object object2 = symbolInfo == null ? null : symbolInfo.getSymbolValue();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type spec.cvlast.CVLDefinition");
                }
                CVLDefinition defInSymbolTable = (CVLDefinition)object2;
                Set<CVLDefinition> deps = SetsKt.mutableSetOf();
                MonadicSelfCVLExpTransformer transformer2 = new MonadicSelfCVLExpTransformer(this, definition2, deps){
                    final /* synthetic */ DefinitionDependencyChecker this$0;
                    final /* synthetic */ CVLDefinition $definition;
                    final /* synthetic */ Set<CVLDefinition> $deps;
                    {
                        this.this$0 = $receiver;
                        this.$definition = $definition;
                        this.$deps = $deps;
                    }

                    @NotNull
                    public CollectingResult definition(@NotNull CVLExp.ApplyExp.Definition exp) {
                        CVLSymbolTable.SymbolInfo definitionInfo;
                        Intrinsics.checkNotNullParameter(exp, "exp");
                        CVLSymbolTable.SymbolInfo symbolInfo = definitionInfo = this.this$0.getSymbolTable().lookUpWithMethodIdWithCallContext((ResolvedCallableName)exp.getMethodIdWithCallContext(), this.$definition.getScope());
                        Object dep = symbolInfo == null ? null : symbolInfo.getSymbolValue();
                        if (!(dep != null && dep instanceof CVLDefinition)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        this.$deps.add((CVLDefinition)dep);
                        return CollectingResult.Companion.lift(exp);
                    }
                };
                transformer2.expr(definition2.getBody());
                Map map2 = definitionDependencies;
                object = IterablesKt.toSet((Iterable)deps);
                map2.put(defInSymbolTable, object);
                astDefinitionVersion.put(defInSymbolTable, definition2);
            }
            List definitionTopoSort = CollectionsKt.reversed(TopologicalSortKt.topologicalOrder$default(definitionDependencies, false, 2, null));
            Map<void, Set<CVLGhostFunction>> modifiesMap = MapsKt.mutableMapOf();
            Map readsMap = MapsKt.mutableMapOf();
            element$iv2 = CollectionsKt.reversed(definitionTopoSort);
            CollectingResult.Companion companion = CollectingResult.Companion;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$fold$iv;
                void defInSymbolTable;
                object = (CVLDefinition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object v = astDefinitionVersion.get(defInSymbolTable);
                Intrinsics.checkNotNull(v);
                CVLDefinition definition3 = (CVLDefinition)v;
                CVLSymbolTable cVLSymbolTable = this.getSymbolTable();
                CVLRange cVLRange = definition3.getCvlRange();
                CVLScope cVLScope = definition3.getScope();
                Intrinsics.checkNotNull(cVLScope);
                Pair<Set<CVLGhostFunction>, Set<CVLGhostFunction>> pair2 = CVLExpModifiesReads.Companion.getModifiedAndRead(cVLSymbolTable, cVLRange, cVLScope, definition3.getBody());
                Set<CVLGhostFunction> modified = pair2.component1();
                Set<CVLGhostFunction> read = pair2.component2();
                Object v2 = definitionDependencies.get(defInSymbolTable);
                Intrinsics.checkNotNull(v2);
                Iterable iterable = (Iterable)v2;
                Pair initial$iv = TuplesKt.to(SetsKt.setOf(), SetsKt.setOf());
                boolean $i$f$fold = false;
                Pair accumulator$iv = initial$iv;
                for (Object element$iv3 : $this$fold$iv) {
                    void el;
                    CVLDefinition cVLDefinition = (CVLDefinition)element$iv3;
                    Pair $dstr$modifiedAcc$readAcc = accumulator$iv;
                    boolean bl3 = false;
                    Set modifiedAcc = $dstr$modifiedAcc$readAcc.component1();
                    Set readAcc = $dstr$modifiedAcc$readAcc.component2();
                    CVLSymbolTable cVLSymbolTable2 = this.getSymbolTable();
                    String string = el.getId();
                    CVLScope cVLScope2 = el.getScope();
                    Intrinsics.checkNotNull(cVLScope2);
                    CVLSymbolTable.SymbolInfo symbolInfo = cVLSymbolTable2.lookUpFunctionLikeSymbol(string, cVLScope2);
                    Object object3 = symbolInfo == null ? null : symbolInfo.getSymbolValue();
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type spec.cvlast.CVLDefinition");
                    }
                    CVLDefinition dep = (CVLDefinition)object3;
                    Object v3 = modifiesMap.get(dep);
                    Intrinsics.checkNotNull(v3);
                    Set set = SetsKt.plus(modifiedAcc, (Set)v3);
                    Object v4 = readsMap.get(dep);
                    Intrinsics.checkNotNull(v4);
                    accumulator$iv = TuplesKt.to(set, SetsKt.plus(readAcc, (Set)v4));
                }
                Pair pair3 = accumulator$iv;
                Set depsModified = pair3.component1();
                Set depsRead = pair3.component2();
                definition3.setModifies(SetsKt.plus(modified, depsModified));
                definition3.setReads(SetsKt.plus(read, depsRead));
                Map<void, Set<CVLGhostFunction>> map3 = modifiesMap;
                Set<CVLGhostFunction> set = definition3.getModifies();
                map3.put(defInSymbolTable, set);
                map3 = readsMap;
                set = definition3.getReads();
                map3.put(defInSymbolTable, set);
                collection.add(CollectingResult.Companion.lift(definition3));
            }
            collectingResult = companion.flatten((List)destination$iv$iv);
        }
        catch (TopologicalOrderException e) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.General(new CVLRange.Empty(null, 1, null), "A circular dependency was found in a definition: this is not allowed. Topo sort error: " + e.getMsg()));
        }
        return collectingResult;
    }
}

