# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import typing
import platform

# Used for default argument values
DEFAULT = object()


class RustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_int32),
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def alloc(size):
        return rust_call(_UniFFILib.ffi_c2pa_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return rust_call(_UniFFILib.ffi_c2pa_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return rust_call(_UniFFILib.ffi_c2pa_rustbuffer_free, self)

    def __str__(self):
        return "RustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def allocWithBuilder(*args):
        """Context-manger to allocate a buffer using a RustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = RustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consumeWithStream(self):
        """Context-manager to consume a buffer using a RustBufferStream.

        The RustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = RustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consumeWithStream")
        finally:
            self.free()

    @contextlib.contextmanager
    def readWithStream(self):
        """Context-manager to read a buffer using a RustBufferStream.

        This is like consumeWithStream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `RustBuffer` data.
        """
        s = RustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of readWithStream")

class ForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "ForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class RustBufferStream:
    """
    Helper for structured reading of bytes from a RustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def readI8(self):
        return self._unpack_from(1, ">b")

    def readU8(self):
        return self._unpack_from(1, ">B")

    def readI16(self):
        return self._unpack_from(2, ">h")

    def readU16(self):
        return self._unpack_from(2, ">H")

    def readI32(self):
        return self._unpack_from(4, ">i")

    def readU32(self):
        return self._unpack_from(4, ">I")

    def readI64(self):
        return self._unpack_from(8, ">q")

    def readU64(self):
        return self._unpack_from(8, ">Q")

    def readFloat(self):
        v = self._unpack_from(4, ">f")
        return v

    def readDouble(self):
        return self._unpack_from(8, ">d")

    def readCSizeT(self):
        return self._unpack_from(ctypes.sizeof(ctypes.c_size_t) , "@N")

class RustBufferBuilder:
    """
    Helper for structured writing of bytes into a RustBuffer.
    """

    def __init__(self):
        self.rbuf = RustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, numBytes):
        if self.rbuf.len + numBytes > self.rbuf.capacity:
            self.rbuf = RustBuffer.reserve(self.rbuf, numBytes)
        yield None
        self.rbuf.len += numBytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def writeI8(self, v):
        self._pack_into(1, ">b", v)

    def writeU8(self, v):
        self._pack_into(1, ">B", v)

    def writeI16(self, v):
        self._pack_into(2, ">h", v)

    def writeU16(self, v):
        self._pack_into(2, ">H", v)

    def writeI32(self, v):
        self._pack_into(4, ">i", v)

    def writeU32(self, v):
        self._pack_into(4, ">I", v)

    def writeI64(self, v):
        self._pack_into(8, ">q", v)

    def writeU64(self, v):
        self._pack_into(8, ">Q", v)

    def writeFloat(self, v):
        self._pack_into(4, ">f", v)

    def writeDouble(self, v):
        self._pack_into(8, ">d", v)

    def writeCSizeT(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class RustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", RustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_PANIC = 2

    def __str__(self):
        if self.code == RustCallStatus.CALL_SUCCESS:
            return "RustCallStatus(CALL_SUCCESS)"
        elif self.code == RustCallStatus.CALL_ERROR:
            return "RustCallStatus(CALL_ERROR)"
        elif self.code == RustCallStatus.CALL_PANIC:
            return "RustCallStatus(CALL_PANIC)"
        else:
            return "RustCallStatus(<invalid code>)"

def rust_call(fn, *args):
    # Call a rust function
    return rust_call_with_error(None, fn, *args)

def rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the FfiConverter for the error class that corresponds to the result.
    call_status = RustCallStatus(code=RustCallStatus.CALL_SUCCESS, error_buf=RustBuffer(0, 0, None))

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def rust_call_async(scaffolding_fn, callback_fn, *args):
    # Call the scaffolding function, passing it a callback handler for `AsyncTypes.py` and a pointer
    # to a python Future object.  The async function then awaits the Future.
    uniffi_eventloop = asyncio.get_running_loop()
    uniffi_py_future = uniffi_eventloop.create_future()
    uniffi_call_status = RustCallStatus(code=RustCallStatus.CALL_SUCCESS, error_buf=RustBuffer(0, 0, None))
    scaffolding_fn(*args,
       FfiConverterForeignExecutor._pointer_manager.new_pointer(uniffi_eventloop),
       callback_fn,
       # Note: It's tempting to skip the pointer manager and just use a `py_object` pointing to a
       # local variable like we do in Swift.  However, Python doesn't use cooperative cancellation
       # -- asyncio can cancel a task at anytime.  This means if we use a local variable, the Rust
       # callback could fire with a dangling pointer.
       UniFfiPyFuturePointerManager.new_pointer(uniffi_py_future),
       ctypes.byref(uniffi_call_status),
    )
    uniffi_check_call_status(None, uniffi_call_status)
    return uniffi_py_future

def uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == RustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == RustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == RustCallStatus.CALL_PANIC:
        # When the rust code sees a panic, it tries to construct a RustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = FfiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid RustCallStatus code: {}".format(
            call_status.code))

# A function pointer for a callback as defined by UniFFI.
# Rust definition `fn(handle: u64, method: u32, args: RustBuffer, buf_ptr: *mut RustBuffer) -> int`
FOREIGN_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_ulonglong, ctypes.c_ulong, ctypes.POINTER(ctypes.c_char), ctypes.c_int, ctypes.POINTER(RustBuffer))
class UniFfiPointerManagerCPython:
    """
    Manage giving out pointers to Python objects on CPython

    This class is used to generate opaque pointers that reference Python objects to pass to Rust.
    It assumes a CPython platform.  See UniFfiPointerManagerGeneral for the alternative.
    """

    def new_pointer(self, obj):
        """
        Get a pointer for an object as a ctypes.c_size_t instance

        Each call to new_pointer() must be balanced with exactly one call to release_pointer()

        This returns a ctypes.c_size_t.  This is always the same size as a pointer and can be
        interchanged with pointers for FFI function arguments and return values.
        """
        # IncRef the object since we're going to pass a pointer to Rust
        ctypes.pythonapi.Py_IncRef(ctypes.py_object(obj))
        # id() is the object address on CPython
        # (https://docs.python.org/3/library/functions.html#id)
        return id(obj)

    def release_pointer(self, address):
        py_obj = ctypes.cast(address, ctypes.py_object)
        obj = py_obj.value
        ctypes.pythonapi.Py_DecRef(py_obj)
        return obj

    def lookup(self, address):
        return ctypes.cast(address, ctypes.py_object).value

class UniFfiPointerManagerGeneral:
    """
    Manage giving out pointers to Python objects on non-CPython platforms

    This has the same API as UniFfiPointerManagerCPython, but doesn't assume we're running on
    CPython and is slightly slower.

    Instead of using real pointers, it maps integer values to objects and returns the keys as
    c_size_t values.
    """

    def __init__(self):
        self._map = {}
        self._lock = threading.Lock()
        self._current_handle = 0

    def new_pointer(self, obj):
        with self._lock:
            handle = self._current_handle
            self._current_handle += 1
            self._map[handle] = obj
        return handle

    def release_pointer(self, handle):
        with self._lock:
            return self._map.pop(handle)

    def lookup(self, handle):
        with self._lock:
            return self._map[handle]

# Pick an pointer manager implementation based on the platform
if platform.python_implementation() == 'CPython':
    UniFfiPointerManager = UniFfiPointerManagerCPython  # type: ignore
else:
    UniFfiPointerManager = UniFfiPointerManagerGeneral  # type: ignore
# Types conforming to `FfiConverterPrimitive` pass themselves directly over the FFI.
class FfiConverterPrimitive:
    @classmethod
    def check(cls, value):
        return value

    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return cls.lowerUnchecked(cls.check(value))

    @classmethod
    def lowerUnchecked(cls, value):
        return value

    @classmethod
    def write(cls, value, buf):
        cls.writeUnchecked(cls.check(value), buf)

class FfiConverterPrimitiveInt(FfiConverterPrimitive):
    @classmethod
    def check(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))
        return super().check(value)

class FfiConverterPrimitiveFloat(FfiConverterPrimitive):
    @classmethod
    def check(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))
        return super().check(value)

# Helper class for wrapper types that will always go through a RustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class FfiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consumeWithStream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with RustBuffer.allocWithBuilder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code,
# and the FFI Function declarations in a com.sun.jna.Library.
# Define some ctypes FFI types that we use in the library

"""
ctypes type for the foreign executor callback.  This is a built-in interface for scheduling
tasks

Args:
  executor: opaque c_size_t value representing the eventloop
  delay: delay in ms
  task: function pointer to the task callback
  task_data: void pointer to the task callback data

Normally we should call task(task_data) after the detail.
However, when task is NULL this indicates that Rust has dropped the ForeignExecutor and we should
decrease the EventLoop refcount.
"""
UNIFFI_FOREIGN_EXECUTOR_CALLBACK_T = ctypes.CFUNCTYPE(None, ctypes.c_size_t, ctypes.c_uint32, ctypes.c_void_p, ctypes.c_void_p)

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p)

def uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_size_t, return_type, RustCallStatus)

from pathlib import Path

def loadIndirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("uniffi_c2pa")
    path = str(Path(__file__).parent / libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 22
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_c2pa_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def uniffi_check_api_checksums(lib):
    if lib.uniffi_c2pa_checksum_func_version() != 31632:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_func_sdk_version() != 32199:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_func_read_file() != 31565:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_func_read_ingredient_file() != 52271:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_func_sign_file() != 18611:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniFFILib = loadIndirect()
_UniFFILib.uniffi_c2pa_fn_func_version.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_func_version.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_func_sdk_version.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_func_sdk_version.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_func_read_file.argtypes = (
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_func_read_file.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_func_read_ingredient_file.argtypes = (
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_func_read_ingredient_file.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_func_sign_file.argtypes = (
    RustBuffer,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_func_sign_file.restype = RustBuffer
_UniFFILib.ffi_c2pa_rustbuffer_alloc.argtypes = (
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_alloc.restype = RustBuffer
_UniFFILib.ffi_c2pa_rustbuffer_from_bytes.argtypes = (
    ForeignBytes,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_from_bytes.restype = RustBuffer
_UniFFILib.ffi_c2pa_rustbuffer_free.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_free.restype = None
_UniFFILib.ffi_c2pa_rustbuffer_reserve.argtypes = (
    RustBuffer,
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_reserve.restype = RustBuffer
_UniFFILib.uniffi_c2pa_checksum_func_version.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_func_version.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_func_sdk_version.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_func_sdk_version.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_func_read_file.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_func_read_file.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_func_read_ingredient_file.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_func_read_ingredient_file.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_func_sign_file.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_func_sign_file.restype = ctypes.c_uint16
_UniFFILib.ffi_c2pa_uniffi_contract_version.argtypes = (
)
_UniFFILib.ffi_c2pa_uniffi_contract_version.restype = ctypes.c_uint32
uniffi_check_contract_api_version(_UniFFILib)
uniffi_check_api_checksums(_UniFFILib)

# Public interface members begin here.


class FfiConverterUInt8(FfiConverterPrimitiveInt):
    CLASS_NAME = "u8"
    VALUE_MIN = 0
    VALUE_MAX = 2**8

    @staticmethod
    def read(buf):
        return buf.readU8()

    @staticmethod
    def writeUnchecked(value, buf):
        buf.writeU8(value)

class FfiConverterString:
    @staticmethod
    def check(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.readI32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8Bytes = buf.read(size)
        return utf8Bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        value = FfiConverterString.check(value)
        utf8Bytes = value.encode("utf-8")
        buf.writeI32(len(utf8Bytes))
        buf.write(utf8Bytes)

    @staticmethod
    def lift(buf):
        with buf.consumeWithStream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        value = FfiConverterString.check(value)
        with RustBuffer.allocWithBuilder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()


class SignerInfo:

    def __init__(self, alg, sign_cert, private_key, ta_url):
        self.alg = alg
        self.sign_cert = sign_cert
        self.private_key = private_key
        self.ta_url = ta_url

    def __str__(self):
        return "SignerInfo(alg={}, sign_cert={}, private_key={}, ta_url={})".format(self.alg, self.sign_cert, self.private_key, self.ta_url)

    def __eq__(self, other):
        if self.alg != other.alg:
            return False
        if self.sign_cert != other.sign_cert:
            return False
        if self.private_key != other.private_key:
            return False
        if self.ta_url != other.ta_url:
            return False
        return True

class FfiConverterTypeSignerInfo(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SignerInfo(
            alg=FfiConverterString.read(buf),
            sign_cert=FfiConverterSequenceUInt8.read(buf),
            private_key=FfiConverterSequenceUInt8.read(buf),
            ta_url=FfiConverterOptionalString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.alg, buf)
        FfiConverterSequenceUInt8.write(value.sign_cert, buf)
        FfiConverterSequenceUInt8.write(value.private_key, buf)
        FfiConverterOptionalString.write(value.ta_url, buf)


# Error
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class Error(Exception):
    pass

UniFFITempError = Error

class Error:  # type: ignore
    class Assertion(UniFFITempError):
        def __repr__(self):
            return "Error.Assertion({})".format(repr(str(self)))
    UniFFITempError.Assertion = Assertion  # type: ignore
    class AssertionNotFound(UniFFITempError):
        def __repr__(self):
            return "Error.AssertionNotFound({})".format(repr(str(self)))
    UniFFITempError.AssertionNotFound = AssertionNotFound  # type: ignore
    class Decoding(UniFFITempError):
        def __repr__(self):
            return "Error.Decoding({})".format(repr(str(self)))
    UniFFITempError.Decoding = Decoding  # type: ignore
    class Encoding(UniFFITempError):
        def __repr__(self):
            return "Error.Encoding({})".format(repr(str(self)))
    UniFFITempError.Encoding = Encoding  # type: ignore
    class FileNotFound(UniFFITempError):
        def __repr__(self):
            return "Error.FileNotFound({})".format(repr(str(self)))
    UniFFITempError.FileNotFound = FileNotFound  # type: ignore
    class Io(UniFFITempError):
        def __repr__(self):
            return "Error.Io({})".format(repr(str(self)))
    UniFFITempError.Io = Io  # type: ignore
    class Json(UniFFITempError):
        def __repr__(self):
            return "Error.Json({})".format(repr(str(self)))
    UniFFITempError.Json = Json  # type: ignore
    class Manifest(UniFFITempError):
        def __repr__(self):
            return "Error.Manifest({})".format(repr(str(self)))
    UniFFITempError.Manifest = Manifest  # type: ignore
    class ManifestNotFound(UniFFITempError):
        def __repr__(self):
            return "Error.ManifestNotFound({})".format(repr(str(self)))
    UniFFITempError.ManifestNotFound = ManifestNotFound  # type: ignore
    class NotSupported(UniFFITempError):
        def __repr__(self):
            return "Error.NotSupported({})".format(repr(str(self)))
    UniFFITempError.NotSupported = NotSupported  # type: ignore
    class Other(UniFFITempError):
        def __repr__(self):
            return "Error.Other({})".format(repr(str(self)))
    UniFFITempError.Other = Other  # type: ignore
    class NullParameter(UniFFITempError):
        def __repr__(self):
            return "Error.NullParameter({})".format(repr(str(self)))
    UniFFITempError.NullParameter = NullParameter  # type: ignore
    class RemoteManifest(UniFFITempError):
        def __repr__(self):
            return "Error.RemoteManifest({})".format(repr(str(self)))
    UniFFITempError.RemoteManifest = RemoteManifest  # type: ignore
    class ResourceNotFound(UniFFITempError):
        def __repr__(self):
            return "Error.ResourceNotFound({})".format(repr(str(self)))
    UniFFITempError.ResourceNotFound = ResourceNotFound  # type: ignore
    class Signature(UniFFITempError):
        def __repr__(self):
            return "Error.Signature({})".format(repr(str(self)))
    UniFFITempError.Signature = Signature  # type: ignore
    class Verify(UniFFITempError):
        def __repr__(self):
            return "Error.Verify({})".format(repr(str(self)))
    UniFFITempError.Verify = Verify  # type: ignore

Error = UniFFITempError  # type: ignore
del UniFFITempError


class FfiConverterTypeError(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return Error.Assertion(
                FfiConverterString.read(buf),
            )
        if variant == 2:
            return Error.AssertionNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 3:
            return Error.Decoding(
                FfiConverterString.read(buf),
            )
        if variant == 4:
            return Error.Encoding(
                FfiConverterString.read(buf),
            )
        if variant == 5:
            return Error.FileNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 6:
            return Error.Io(
                FfiConverterString.read(buf),
            )
        if variant == 7:
            return Error.Json(
                FfiConverterString.read(buf),
            )
        if variant == 8:
            return Error.Manifest(
                FfiConverterString.read(buf),
            )
        if variant == 9:
            return Error.ManifestNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 10:
            return Error.NotSupported(
                FfiConverterString.read(buf),
            )
        if variant == 11:
            return Error.Other(
                FfiConverterString.read(buf),
            )
        if variant == 12:
            return Error.NullParameter(
                FfiConverterString.read(buf),
            )
        if variant == 13:
            return Error.RemoteManifest(
                FfiConverterString.read(buf),
            )
        if variant == 14:
            return Error.ResourceNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 15:
            return Error.Signature(
                FfiConverterString.read(buf),
            )
        if variant == 16:
            return Error.Verify(
                FfiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def write(value, buf):
        if isinstance(value, Error.Assertion):
            buf.writeI32(1)
        if isinstance(value, Error.AssertionNotFound):
            buf.writeI32(2)
        if isinstance(value, Error.Decoding):
            buf.writeI32(3)
        if isinstance(value, Error.Encoding):
            buf.writeI32(4)
        if isinstance(value, Error.FileNotFound):
            buf.writeI32(5)
        if isinstance(value, Error.Io):
            buf.writeI32(6)
        if isinstance(value, Error.Json):
            buf.writeI32(7)
        if isinstance(value, Error.Manifest):
            buf.writeI32(8)
        if isinstance(value, Error.ManifestNotFound):
            buf.writeI32(9)
        if isinstance(value, Error.NotSupported):
            buf.writeI32(10)
        if isinstance(value, Error.Other):
            buf.writeI32(11)
        if isinstance(value, Error.NullParameter):
            buf.writeI32(12)
        if isinstance(value, Error.RemoteManifest):
            buf.writeI32(13)
        if isinstance(value, Error.ResourceNotFound):
            buf.writeI32(14)
        if isinstance(value, Error.Signature):
            buf.writeI32(15)
        if isinstance(value, Error.Verify):
            buf.writeI32(16)



class FfiConverterOptionalString(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterSequenceUInt8(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterUInt8.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterUInt8.read(buf) for i in range(count)
        ]

def version():
    return FfiConverterString.lift(rust_call(_UniFFILib.uniffi_c2pa_fn_func_version,))


def sdk_version():
    return FfiConverterString.lift(rust_call(_UniFFILib.uniffi_c2pa_fn_func_sdk_version,))


def read_file(path: "str",data_dir: "typing.Optional[str]"):
    
    
    return FfiConverterString.lift(rust_call_with_error(FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_func_read_file,
        FfiConverterString.lower(path),
        FfiConverterOptionalString.lower(data_dir)))


def read_ingredient_file(path: "str",data_dir: "str"):
    
    
    return FfiConverterString.lift(rust_call_with_error(FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_func_read_ingredient_file,
        FfiConverterString.lower(path),
        FfiConverterString.lower(data_dir)))


def sign_file(source: "str",dest: "str",manifest: "str",signer_info: "SignerInfo",data_dir: "typing.Optional[str]"):
    
    
    
    
    
    return FfiConverterSequenceUInt8.lift(rust_call_with_error(FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_func_sign_file,
        FfiConverterString.lower(source),
        FfiConverterString.lower(dest),
        FfiConverterString.lower(manifest),
        FfiConverterTypeSignerInfo.lower(signer_info),
        FfiConverterOptionalString.lower(data_dir)))


__all__ = [
    "InternalError",
    "Error",
    "SignerInfo",
    "version",
    "sdk_version",
    "read_file",
    "read_ingredient_file",
    "sign_file",
]

