# Generated by PyGodot binding generator
<%!
    from godot_tools.binding_generator import (
        python_module_name, is_class_type,
        CORE_TYPES, SPECIAL_ESCAPES,
        remove_nested_type_prefix, clean_signature, make_cython_gdnative_type
    )

    singleton_map = {}

    def get_class_name(name, cls):
        if cls['singleton']:
            singleton_map[name] = name + 'Class'
            return name + 'Class'
        return name

    def get_base_name(name):
        if not name:
            return '_Wrapped'

        if name in singleton_map:
            return singleton_map[name]

        return name

    def make_arg(arg):
        t = arg[2]['type']
        if arg[3] is not None:
            assert arg[1].startswith('_')
            return arg[1][1:]
        elif is_class_type(arg[2]['type']):
            return '%s._owner' % arg[1]
        elif t == 'String':
            return 'cpp.String(%s)' % arg[1]
        elif t == 'Variant' and arg[2]['has_default_value']:
            return 'cpp.Variant(%s)' % arg[1]
        elif t == 'Array' and arg[2]['has_default_value']:
            return 'cpp.Array(%s)' % arg[1]
        elif t == 'Dictionary' and arg[2]['has_default_value']:
            return 'cpp.Dictionary(%s)' % arg[1]
        elif t in CORE_TYPES and arg[2]['has_default_value']:
            return '%s.to_cpp()' % arg[1]
        else:
            return arg[1]

    def make_default_arg_type(arg_type):
        return arg_type.rstrip('*').rstrip().replace('const ', '')
%>
from godot_headers.gdnative_api cimport godot_object, godot_variant
from ..globals cimport Godot, WARN_PRINT, gdapi, nativescript_1_1_api as ns11api, _cython_language_index as CYTHON_IDX

from ..core cimport cpp_types as cpp
from ..core cimport types as py
from ..core.defs cimport *
from ..core._wrapped cimport _Wrapped
from ..core.tag_db cimport (
    register_global_cython_type, get_python_instance,
    register_godot_instance, unregister_godot_instance
)
from .cython cimport __icalls

from cpython.ref cimport Py_DECREF

from cython.operator cimport dereference as deref
% for class_name, class_def, includes, forwards, methods in classes:


% if class_def['singleton']:
cdef ${class_name}Class ${class_name} = None

% endif
% if methods:
cdef __${class_name}__method_bindings __${class_name}__mb

% endif
cdef class ${get_class_name(class_name, class_def)}(${get_base_name(class_def['base_class'])}):
    % if class_def['singleton']:
    @staticmethod
    cdef object get_singleton():
        global ${class_name}

        if ${class_name} is None:
            ${class_name} = ${class_name}Class.__new__(${class_name}Class)

        return ${class_name}

    % endif
    % if class_def['singleton']:
    def __cinit__(self):
        % if class_name == 'GlobalConstants':
        self._owner = NULL
        % else:
        self._owner = gdapi.godot_global_get_singleton("${class_name}")
        % endif
        self._owner_allocated = False
        self.___CLASS_IS_SCRIPT = False
        self.___CLASS_IS_SINGLETON = True
        self.___CLASS_BINDING_LEVEL = 1
    % else:
    % if not class_def['base_class']:
    def __cinit__(self):
        self._owner = NULL
        self._owner_allocated = False
        self.___CLASS_IS_SCRIPT = False
        self.___CLASS_IS_SINGLETON = False
        self.___CLASS_BINDING_LEVEL = 1
    % if class_def['instanciable']:

    def __dealloc__(self):
        cdef godot_object *owner = self._owner

        if owner and self._owner_allocated:
            # print('DESTROY %s %r' % (hex(<size_t>self._owner), self))
            self._owner = NULL
            gdapi.godot_object_destroy(owner)
            unregister_godot_instance(owner)
    % endif  ## instanciable
    % elif class_def['name'] == 'Reference':
    def __dealloc__(self):
        cdef bint should_destroy = False
        cdef godot_object *owner = self._owner

        # print('REF DEALLOC', hex(<size_t>owner), self, self._owner_allocated)

        if owner and self._owner_allocated:
            # print('UNREF', hex(<size_t>owner), self)
            should_destroy = self.unreference()

        if owner and should_destroy:
            # print('DESTROY REF', hex(<size_t>owner), self)
            self._owner = NULL
            gdapi.godot_object_destroy(owner)
            unregister_godot_instance(owner)
    % endif  ## not base_class/elif reference
    % endif  ## singleton/else

    % if class_def['instanciable']:
    def __init__(self, own_memory=False):
        if '_preinit' in self.__class__.__dict__:
            self.__class__._preinit(self)
        elif self.__class__ is ${class_name}:
            self._owner = gdapi.godot_get_class_constructor("${class_name}")()
            self._owner_allocated = own_memory
            register_godot_instance(self._owner, self)
            # print('INIT %s %r' % (hex(<size_t>self._owner), self))
        else:
            raise RuntimeError("Improperly configured or unregistered '${class_name}' subclass %r." % self.__class__)

    % else:
    def __init__(self):
        raise RuntimeError('${class_name} is not instanciable')

    % endif
    % for method_name, method, return_type, pxd_signature, signature, args, return_stmt, init_args in methods:
    % if method['__func_type'] == 'def':
    def ${method_name}(self${', ' if signature else ''}${clean_signature(signature, class_name)}):
    % else:
    cdef ${return_type}${method_name}(self${', ' if signature else ''}${clean_signature(signature, class_name)}):
    % endif
    % if method_name == 'free':
        cdef godot_object *owner = self._owner
        if owner:
            if not self._owner_allocated:
                # WARN_PRINT("Can't free Godot-managed instance %r (godot_object *%s)" % (self, hex(<size_t>self._owner)))
                pass
            self._owner = NULL
            # print('DESTROY %s %r' % (hex(<size_t>owner), self))
            gdapi.godot_object_destroy(owner)
            unregister_godot_instance(owner)

    % elif method['has_varargs']:
        % if is_class_type(method['return_type']):
        cdef cpp.Variant __owner = __icalls.${icall_names[class_name + '#' + method_name]}(__${class_name}__mb.mb_${method_name}, self._owner${', %s' % ', '.join(make_arg(a) for a in args) if args else ''}, cpp.Array(__var_args))
        return get_python_instance(<godot_object *>__owner)
        % else:
        ${return_stmt}__icalls.${icall_names[class_name + '#' + method_name]}(__${class_name}__mb.mb_${method_name}, self._owner${', %s' % ', '.join(make_arg(a) for a in args) if args else ''}, cpp.Array(__var_args))
        % endif
        % if method_name == '__call__' and class_name == 'NativeScript':

    cdef godot_object *_new_instance(self):
        return <godot_object *>__icalls.${icall_names[class_name + '#' + method_name]}(__${class_name}__mb.mb_${method_name}, self._owner, cpp.Array())
        % endif
    % else:
        ## not has_varargs
        ${return_stmt}__icalls.${icall_names[class_name + '#' + method_name]}(__${class_name}__mb.mb_${method_name}, self._owner${', %s' % ', '.join(make_arg(a) for a in args) if args else ''})${'.py_str()' if method['return_type'] == 'String' else ''}
    % endif

    % endfor

    @staticmethod
    cdef __init_method_bindings():
    % if class_def['singleton']:
        global ${class_name}

        ${class_name} = ${class_name}Class.__new__(${class_name}Class)
        assert ${class_name} is not None
    % endif
    % for method_name, method, return_type, pxd_signature, signature, args, return_stmt, init_args in methods:
        __${class_name}__mb.mb_${method_name} = gdapi.godot_method_bind_get_method("${class_def['name']}", "${method['name']}")
    % endfor
    % if not methods and not class_def['singleton']:
        pass
    % endif
% endfor


cdef __init_method_bindings():
% for class_name, class_def, includes, forwards, methods in classes:
    ${get_class_name(class_name, class_def)}.__init_method_bindings()
% endfor


cdef __register_types():
% for class_name, class_def, includes, forwards, methods in classes:
    register_global_cython_type(${get_class_name(class_name, class_def)}, ${repr(class_def['name'])})
% endfor
