"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import scimuser as shared_scimuser
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class CreateScimUsersRequestTypedDict(TypedDict):
    scim_user: shared_scimuser.ScimUserTypedDict
    connection_id: str
    r"""ID of the connection"""
    count: NotRequired[float]
    filter_: NotRequired[str]
    sort_by: NotRequired[str]
    sort_order: NotRequired[str]
    start_index: NotRequired[float]


class CreateScimUsersRequest(BaseModel):
    scim_user: Annotated[
        shared_scimuser.ScimUser,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    count: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    filter_: Annotated[
        Optional[str],
        pydantic.Field(alias="filter"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    sort_by: Annotated[
        Optional[str],
        pydantic.Field(alias="sortBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    sort_order: Annotated[
        Optional[str],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    start_index: Annotated[
        Optional[float],
        pydantic.Field(alias="startIndex"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class CreateScimUsersResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    scim_user: NotRequired[shared_scimuser.ScimUserTypedDict]
    r"""Successful"""


class CreateScimUsersResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    scim_user: Optional[shared_scimuser.ScimUser] = None
    r"""Successful"""
