"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import crmevent as shared_crmevent
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdateCrmEventRequestTypedDict(TypedDict):
    crm_event: shared_crmevent.CrmEventTypedDict
    r"""An event represents an event, activity, or engagement and is always associated with a deal, contact, or company"""
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Event"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""
    raw: NotRequired[str]
    r"""Raw parameters to include in the 3rd-party request. Encoded as a URL component. eg. raw parameters: foo=bar&zoo=bar -> raw=foo%3Dbar%26zoo%3Dbar"""


class UpdateCrmEventRequest(BaseModel):
    crm_event: Annotated[
        shared_crmevent.CrmEvent,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""An event represents an event, activity, or engagement and is always associated with a deal, contact, or company"""

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Event"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""

    raw: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Raw parameters to include in the 3rd-party request. Encoded as a URL component. eg. raw parameters: foo=bar&zoo=bar -> raw=foo%3Dbar%26zoo%3Dbar"""


class UpdateCrmEventResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    crm_event: NotRequired[shared_crmevent.CrmEventTypedDict]
    r"""Successful"""


class UpdateCrmEventResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    crm_event: Optional[shared_crmevent.CrmEvent] = None
    r"""Successful"""
