"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountingattachment import AccountingAttachment, AccountingAttachmentTypedDict
from .accountinglineitem import AccountingLineitem, AccountingLineitemTypedDict
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class PaymentCollectionMethod(str, Enum, metaclass=utils.OpenEnumMeta):
    SEND_INVOICE = "send_invoice"
    CHARGE_AUTOMATICALLY = "charge_automatically"


class AccountingBillStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    DRAFT = "DRAFT"
    VOIDED = "VOIDED"
    AUTHORIZED = "AUTHORIZED"
    PAID = "PAID"
    PARTIALLY_PAID = "PARTIALLY_PAID"
    PARTIALLY_REFUNDED = "PARTIALLY_REFUNDED"
    REFUNDED = "REFUNDED"


class AccountingBillTypedDict(TypedDict):
    attachments: NotRequired[List[AccountingAttachmentTypedDict]]
    balance_amount: NotRequired[float]
    bill_number: NotRequired[str]
    cancelled_at: NotRequired[datetime]
    contact_id: NotRequired[str]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    discount_amount: NotRequired[float]
    due_at: NotRequired[datetime]
    id: NotRequired[str]
    lineitems: NotRequired[List[AccountingLineitemTypedDict]]
    notes: NotRequired[str]
    paid_amount: NotRequired[float]
    paid_at: NotRequired[datetime]
    payment_collection_method: NotRequired[PaymentCollectionMethod]
    posted_at: NotRequired[datetime]
    raw: NotRequired[Dict[str, Any]]
    refund_amount: NotRequired[float]
    refund_reason: NotRequired[str]
    refunded_at: NotRequired[datetime]
    send: NotRequired[bool]
    status: NotRequired[AccountingBillStatus]
    tax_amount: NotRequired[float]
    total_amount: NotRequired[float]
    updated_at: NotRequired[datetime]
    url: NotRequired[str]


class AccountingBill(BaseModel):
    attachments: Optional[List[AccountingAttachment]] = None

    balance_amount: Optional[float] = None

    bill_number: Optional[str] = None

    cancelled_at: Optional[datetime] = None

    contact_id: Optional[str] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    discount_amount: Optional[float] = None

    due_at: Optional[datetime] = None

    id: Optional[str] = None

    lineitems: Optional[List[AccountingLineitem]] = None

    notes: Optional[str] = None

    paid_amount: Optional[float] = None

    paid_at: Optional[datetime] = None

    payment_collection_method: Annotated[
        Optional[PaymentCollectionMethod], PlainValidator(validate_open_enum(False))
    ] = None

    posted_at: Optional[datetime] = None

    raw: Optional[Dict[str, Any]] = None

    refund_amount: Optional[float] = None

    refund_reason: Optional[str] = None

    refunded_at: Optional[datetime] = None

    send: Optional[bool] = None

    status: Annotated[
        Optional[AccountingBillStatus], PlainValidator(validate_open_enum(False))
    ] = None

    tax_amount: Optional[float] = None

    total_amount: Optional[float] = None

    updated_at: Optional[datetime] = None

    url: Optional[str] = None
