"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .property_calendareventrecurrence_on_days import (
    PropertyCalendarEventRecurrenceOnDays,
)
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class CalendarEventRecurrenceFrequency(str, Enum, metaclass=utils.OpenEnumMeta):
    DAILY = "DAILY"
    WEEKLY = "WEEKLY"
    MONTHLY = "MONTHLY"
    YEARLY = "YEARLY"


class CalendarEventRecurrenceTypedDict(TypedDict):
    frequency: CalendarEventRecurrenceFrequency
    count: NotRequired[float]
    end_at: NotRequired[datetime]
    excluded_dates: NotRequired[List[str]]
    r"""dates to exclude from the recurrence, defaults to undefined (no exclusions)"""
    interval: NotRequired[float]
    on_days: NotRequired[List[PropertyCalendarEventRecurrenceOnDays]]
    r"""days of the week to repeat on, defaults to undefined (every day), only used if frequency is WEEKLY"""
    on_month_days: NotRequired[List[float]]
    r"""days of the month to repeat on, defaults to undefined (every day), only used if frequency is MONTHLY"""
    on_months: NotRequired[List[float]]
    r"""months of the year to repeat on, defaults to undefined (every month), only used if frequency is YEARLY, January is 1"""


class CalendarEventRecurrence(BaseModel):
    frequency: Annotated[
        CalendarEventRecurrenceFrequency, PlainValidator(validate_open_enum(False))
    ]

    count: Optional[float] = None

    end_at: Optional[datetime] = None

    excluded_dates: Optional[List[str]] = None
    r"""dates to exclude from the recurrence, defaults to undefined (no exclusions)"""

    interval: Optional[float] = None

    on_days: Optional[
        List[
            Annotated[
                PropertyCalendarEventRecurrenceOnDays,
                PlainValidator(validate_open_enum(False)),
            ]
        ]
    ] = None
    r"""days of the week to repeat on, defaults to undefined (every day), only used if frequency is WEEKLY"""

    on_month_days: Optional[List[float]] = None
    r"""days of the month to repeat on, defaults to undefined (every day), only used if frequency is MONTHLY"""

    on_months: Optional[List[float]] = None
    r"""months of the year to repeat on, defaults to undefined (every month), only used if frequency is YEARLY, January is 1"""
