"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from enum import Enum
import io
from typing import Any, IO, Mapping, Optional, Union, cast
from unified_python_sdk import utils
from unified_python_sdk._hooks import HookContext
from unified_python_sdk.models import errors, operations
from unified_python_sdk.types import BaseModel, OptionalNullable, UNSET


class CreatePassthroughJsonAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class CreatePassthroughRawAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class ListPassthroughsAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class PatchPassthroughJsonAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class PatchPassthroughRawAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class RemovePassthroughAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class UpdatePassthroughJsonAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class UpdatePassthroughRawAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_CSV = "text/csv"
    TEXT_PLAIN = "text/plain"
    APPLICATION_XML = "application/xml"
    WILDCARD_ROOT_WILDCARD_ = "*/*"


class Passthrough(BaseSDK):
    def create_passthrough_json(
        self,
        *,
        request: Union[
            operations.CreatePassthroughJSONRequest,
            operations.CreatePassthroughJSONRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[CreatePassthroughJsonAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.CreatePassthroughJSONResponse:
        r"""Passthrough POST

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.CreatePassthroughJSONRequest)
        request = cast(operations.CreatePassthroughJSONRequest, request)

        req = self._build_request(
            method="POST",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createPassthrough_json",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.CreatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.CreatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.CreatePassthroughJSONResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def create_passthrough_json_async(
        self,
        *,
        request: Union[
            operations.CreatePassthroughJSONRequest,
            operations.CreatePassthroughJSONRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[CreatePassthroughJsonAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.CreatePassthroughJSONResponse:
        r"""Passthrough POST

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.CreatePassthroughJSONRequest)
        request = cast(operations.CreatePassthroughJSONRequest, request)

        req = self._build_request_async(
            method="POST",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createPassthrough_json",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.CreatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.CreatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughJSONResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.CreatePassthroughJSONResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    def create_passthrough_raw(
        self,
        *,
        request: Union[
            operations.CreatePassthroughRawRequest,
            operations.CreatePassthroughRawRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[CreatePassthroughRawAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.CreatePassthroughRawResponse:
        r"""Passthrough POST

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.CreatePassthroughRawRequest)
        request = cast(operations.CreatePassthroughRawRequest, request)

        req = self._build_request(
            method="POST",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "raw",
                Optional[Union[bytes, IO[bytes], io.BufferedReader]],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createPassthrough_raw",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.CreatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.CreatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughRawResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughRawResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughRawResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.CreatePassthroughRawResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.CreatePassthroughRawResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def create_passthrough_raw_async(
        self,
        *,
        request: Union[
            operations.CreatePassthroughRawRequest,
            operations.CreatePassthroughRawRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[CreatePassthroughRawAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.CreatePassthroughRawResponse:
        r"""Passthrough POST

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.CreatePassthroughRawRequest)
        request = cast(operations.CreatePassthroughRawRequest, request)

        req = self._build_request_async(
            method="POST",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "raw",
                Optional[Union[bytes, IO[bytes], io.BufferedReader]],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createPassthrough_raw",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.CreatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.CreatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughRawResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughRawResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughRawResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.CreatePassthroughRawResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.CreatePassthroughRawResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    def list_passthroughs(
        self,
        *,
        request: Union[
            operations.ListPassthroughsRequest,
            operations.ListPassthroughsRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[ListPassthroughsAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.ListPassthroughsResponse:
        r"""Passthrough GET

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.ListPassthroughsRequest)
        request = cast(operations.ListPassthroughsRequest, request)

        req = self._build_request(
            method="GET",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listPassthroughs",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.ListPassthroughsResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.ListPassthroughsResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.ListPassthroughsResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.ListPassthroughsResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.ListPassthroughsResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.ListPassthroughsResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.ListPassthroughsResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def list_passthroughs_async(
        self,
        *,
        request: Union[
            operations.ListPassthroughsRequest,
            operations.ListPassthroughsRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[ListPassthroughsAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.ListPassthroughsResponse:
        r"""Passthrough GET

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.ListPassthroughsRequest)
        request = cast(operations.ListPassthroughsRequest, request)

        req = self._build_request_async(
            method="GET",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listPassthroughs",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.ListPassthroughsResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.ListPassthroughsResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.ListPassthroughsResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.ListPassthroughsResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.ListPassthroughsResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.ListPassthroughsResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.ListPassthroughsResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    def patch_passthrough_json(
        self,
        *,
        request: Union[
            operations.PatchPassthroughJSONRequest,
            operations.PatchPassthroughJSONRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[PatchPassthroughJsonAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.PatchPassthroughJSONResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.PatchPassthroughJSONRequest)
        request = cast(operations.PatchPassthroughJSONRequest, request)

        req = self._build_request(
            method="PATCH",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patchPassthrough_json",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.PatchPassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.PatchPassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.PatchPassthroughJSONResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def patch_passthrough_json_async(
        self,
        *,
        request: Union[
            operations.PatchPassthroughJSONRequest,
            operations.PatchPassthroughJSONRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[PatchPassthroughJsonAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.PatchPassthroughJSONResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.PatchPassthroughJSONRequest)
        request = cast(operations.PatchPassthroughJSONRequest, request)

        req = self._build_request_async(
            method="PATCH",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patchPassthrough_json",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.PatchPassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.PatchPassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughJSONResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.PatchPassthroughJSONResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    def patch_passthrough_raw(
        self,
        *,
        request: Union[
            operations.PatchPassthroughRawRequest,
            operations.PatchPassthroughRawRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[PatchPassthroughRawAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.PatchPassthroughRawResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.PatchPassthroughRawRequest)
        request = cast(operations.PatchPassthroughRawRequest, request)

        req = self._build_request(
            method="PATCH",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "raw",
                Optional[Union[bytes, IO[bytes], io.BufferedReader]],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patchPassthrough_raw",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.PatchPassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.PatchPassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughRawResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughRawResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughRawResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.PatchPassthroughRawResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.PatchPassthroughRawResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def patch_passthrough_raw_async(
        self,
        *,
        request: Union[
            operations.PatchPassthroughRawRequest,
            operations.PatchPassthroughRawRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[PatchPassthroughRawAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.PatchPassthroughRawResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.PatchPassthroughRawRequest)
        request = cast(operations.PatchPassthroughRawRequest, request)

        req = self._build_request_async(
            method="PATCH",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "raw",
                Optional[Union[bytes, IO[bytes], io.BufferedReader]],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patchPassthrough_raw",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.PatchPassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.PatchPassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughRawResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughRawResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughRawResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.PatchPassthroughRawResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.PatchPassthroughRawResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    def remove_passthrough(
        self,
        *,
        request: Union[
            operations.RemovePassthroughRequest,
            operations.RemovePassthroughRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[RemovePassthroughAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.RemovePassthroughResponse:
        r"""Passthrough DELETE

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.RemovePassthroughRequest)
        request = cast(operations.RemovePassthroughRequest, request)

        req = self._build_request(
            method="DELETE",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="removePassthrough",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.RemovePassthroughResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.RemovePassthroughResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.RemovePassthroughResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.RemovePassthroughResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.RemovePassthroughResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.RemovePassthroughResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.RemovePassthroughResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def remove_passthrough_async(
        self,
        *,
        request: Union[
            operations.RemovePassthroughRequest,
            operations.RemovePassthroughRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[RemovePassthroughAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.RemovePassthroughResponse:
        r"""Passthrough DELETE

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.RemovePassthroughRequest)
        request = cast(operations.RemovePassthroughRequest, request)

        req = self._build_request_async(
            method="DELETE",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="removePassthrough",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.RemovePassthroughResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.RemovePassthroughResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.RemovePassthroughResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.RemovePassthroughResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.RemovePassthroughResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.RemovePassthroughResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.RemovePassthroughResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    def update_passthrough_json(
        self,
        *,
        request: Union[
            operations.UpdatePassthroughJSONRequest,
            operations.UpdatePassthroughJSONRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[UpdatePassthroughJsonAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.UpdatePassthroughJSONResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.UpdatePassthroughJSONRequest)
        request = cast(operations.UpdatePassthroughJSONRequest, request)

        req = self._build_request(
            method="PUT",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updatePassthrough_json",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.UpdatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.UpdatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.UpdatePassthroughJSONResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def update_passthrough_json_async(
        self,
        *,
        request: Union[
            operations.UpdatePassthroughJSONRequest,
            operations.UpdatePassthroughJSONRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[UpdatePassthroughJsonAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.UpdatePassthroughJSONResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.UpdatePassthroughJSONRequest)
        request = cast(operations.UpdatePassthroughJSONRequest, request)

        req = self._build_request_async(
            method="PUT",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updatePassthrough_json",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.UpdatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.UpdatePassthroughJSONResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughJSONResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.UpdatePassthroughJSONResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    def update_passthrough_raw(
        self,
        *,
        request: Union[
            operations.UpdatePassthroughRawRequest,
            operations.UpdatePassthroughRawRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[UpdatePassthroughRawAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.UpdatePassthroughRawResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.UpdatePassthroughRawRequest)
        request = cast(operations.UpdatePassthroughRawRequest, request)

        req = self._build_request(
            method="PUT",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "raw",
                Optional[Union[bytes, IO[bytes], io.BufferedReader]],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updatePassthrough_raw",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.UpdatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.UpdatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = utils.stream_to_text(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.UpdatePassthroughRawResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)

    async def update_passthrough_raw_async(
        self,
        *,
        request: Union[
            operations.UpdatePassthroughRawRequest,
            operations.UpdatePassthroughRawRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[UpdatePassthroughRawAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.UpdatePassthroughRawResponse:
        r"""Passthrough PUT

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.UpdatePassthroughRawRequest)
        request = cast(operations.UpdatePassthroughRawRequest, request)

        req = self._build_request_async(
            method="PUT",
            path="/passthrough/{connection_id}/{path}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/csv;q=0.8, text/plain;q=0.6, application/xml;q=0.4, */*;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "raw",
                Optional[Union[bytes, IO[bytes], io.BufferedReader]],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updatePassthrough_raw",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, ["204", "205"], "*"):
            return operations.UpdatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "304", "*"):
            return operations.UpdatePassthroughRawResponse(
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_application_json_any=utils.unmarshal_json_response(
                    Optional[Any], http_res, http_res_text
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "application/xml"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_application_xml_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/csv"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_text_csv_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "text/plain"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return operations.UpdatePassthroughRawResponse(
                default_text_plain_res=http_res_text,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "default", "*/*"):
            return operations.UpdatePassthroughRawResponse(
                default_wildcard_wildcard_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
                headers=utils.get_response_headers(http_res.headers),
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError("Unexpected response received", http_res, http_res_text)
