import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppConfigurationKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#configuration_store_id AppConfigurationKey#configuration_store_id}.
     *
     * @stability stable
     */
    readonly configurationStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#content_type AppConfigurationKey#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#etag AppConfigurationKey#etag}.
     *
     * @stability stable
     */
    readonly etag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#key AppConfigurationKey#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#label AppConfigurationKey#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#locked AppConfigurationKey#locked}.
     *
     * @stability stable
     */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#tags AppConfigurationKey#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#type AppConfigurationKey#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#value AppConfigurationKey#value}.
     *
     * @stability stable
     */
    readonly value?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#vault_key_reference AppConfigurationKey#vault_key_reference}.
     *
     * @stability stable
     */
    readonly vaultKeyReference?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#timeouts AppConfigurationKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppConfigurationKeyTimeouts;
}
/**
 * @stability stable
 */
export interface AppConfigurationKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#create AppConfigurationKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#delete AppConfigurationKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#read AppConfigurationKey#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html#update AppConfigurationKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appConfigurationKeyTimeoutsToTerraform(struct?: AppConfigurationKeyTimeoutsOutputReference | AppConfigurationKeyTimeouts): any;
/**
 * @stability stable
 */
export declare class AppConfigurationKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppConfigurationKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppConfigurationKeyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html azurerm_app_configuration_key}.
 *
 * @stability stable
 */
export declare class AppConfigurationKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_key.html azurerm_app_configuration_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppConfigurationKeyConfig);
    private _configurationStoreId?;
    /**
     * @stability stable
     */
    get configurationStoreId(): string;
    /**
     * @stability stable
     */
    set configurationStoreId(value: string);
    /**
     * @stability stable
     */
    get configurationStoreIdInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _etag?;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    set etag(value: string);
    /**
     * @stability stable
     */
    resetEtag(): void;
    /**
     * @stability stable
     */
    get etagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _locked?;
    /**
     * @stability stable
     */
    get locked(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set locked(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocked(): void;
    /**
     * @stability stable
     */
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    resetValue(): void;
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _vaultKeyReference?;
    /**
     * @stability stable
     */
    get vaultKeyReference(): string;
    /**
     * @stability stable
     */
    set vaultKeyReference(value: string);
    /**
     * @stability stable
     */
    resetVaultKeyReference(): void;
    /**
     * @stability stable
     */
    get vaultKeyReferenceInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppConfigurationKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppConfigurationKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppConfigurationKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
