import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceHybridConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#app_service_name AppServiceHybridConnection#app_service_name}.
     *
     * @stability stable
     */
    readonly appServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#hostname AppServiceHybridConnection#hostname}.
     *
     * @stability stable
     */
    readonly hostname: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#port AppServiceHybridConnection#port}.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#relay_id AppServiceHybridConnection#relay_id}.
     *
     * @stability stable
     */
    readonly relayId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#resource_group_name AppServiceHybridConnection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#send_key_name AppServiceHybridConnection#send_key_name}.
     *
     * @stability stable
     */
    readonly sendKeyName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#timeouts AppServiceHybridConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceHybridConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface AppServiceHybridConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#create AppServiceHybridConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#delete AppServiceHybridConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#read AppServiceHybridConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html#update AppServiceHybridConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceHybridConnectionTimeoutsToTerraform(struct?: AppServiceHybridConnectionTimeoutsOutputReference | AppServiceHybridConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceHybridConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceHybridConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceHybridConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html azurerm_app_service_hybrid_connection}.
 *
 * @stability stable
 */
export declare class AppServiceHybridConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_hybrid_connection.html azurerm_app_service_hybrid_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceHybridConnectionConfig);
    private _appServiceName?;
    /**
     * @stability stable
     */
    get appServiceName(): string;
    /**
     * @stability stable
     */
    set appServiceName(value: string);
    /**
     * @stability stable
     */
    get appServiceNameInput(): string | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _relayId?;
    /**
     * @stability stable
     */
    get relayId(): string;
    /**
     * @stability stable
     */
    set relayId(value: string);
    /**
     * @stability stable
     */
    get relayIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get relayName(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sendKeyName?;
    /**
     * @stability stable
     */
    get sendKeyName(): string;
    /**
     * @stability stable
     */
    set sendKeyName(value: string);
    /**
     * @stability stable
     */
    resetSendKeyName(): void;
    /**
     * @stability stable
     */
    get sendKeyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sendKeyValue(): string;
    /**
     * @stability stable
     */
    get serviceBusNamespace(): string;
    /**
     * @stability stable
     */
    get serviceBusSuffix(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceHybridConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceHybridConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceHybridConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
