import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDevTestLabConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab.html#name DataAzurermDevTestLab#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab.html#resource_group_name DataAzurermDevTestLab#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab.html#timeouts DataAzurermDevTestLab#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDevTestLabTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDevTestLabTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab.html#read DataAzurermDevTestLab#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDevTestLabTimeoutsToTerraform(struct?: DataAzurermDevTestLabTimeoutsOutputReference | DataAzurermDevTestLabTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermDevTestLabTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDevTestLabTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDevTestLabTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab.html azurerm_dev_test_lab}.
 *
 * @stability stable
 */
export declare class DataAzurermDevTestLab extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab.html azurerm_dev_test_lab} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDevTestLabConfig);
    /**
     * @stability stable
     */
    get artifactsStorageAccountId(): string;
    /**
     * @stability stable
     */
    get defaultPremiumStorageAccountId(): string;
    /**
     * @stability stable
     */
    get defaultStorageAccountId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get premiumDataDiskStorageAccountId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get storageType(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get uniqueIdentifier(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDevTestLabTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDevTestLabTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDevTestLabTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
