import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermFunctionAppHostKeysConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app_host_keys.html#name DataAzurermFunctionAppHostKeys#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app_host_keys.html#resource_group_name DataAzurermFunctionAppHostKeys#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app_host_keys.html#timeouts DataAzurermFunctionAppHostKeys#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermFunctionAppHostKeysTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermFunctionAppHostKeysTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app_host_keys.html#read DataAzurermFunctionAppHostKeys#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermFunctionAppHostKeysTimeoutsToTerraform(struct?: DataAzurermFunctionAppHostKeysTimeoutsOutputReference | DataAzurermFunctionAppHostKeysTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppHostKeysTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermFunctionAppHostKeysTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermFunctionAppHostKeysTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/function_app_host_keys.html azurerm_function_app_host_keys}.
 *
 * @stability stable
 */
export declare class DataAzurermFunctionAppHostKeys extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/function_app_host_keys.html azurerm_function_app_host_keys} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermFunctionAppHostKeysConfig);
    /**
     * @stability stable
     */
    get defaultFunctionKey(): string;
    /**
     * @stability stable
     */
    get eventGridExtensionConfigKey(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get masterKey(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermFunctionAppHostKeysTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermFunctionAppHostKeysTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermFunctionAppHostKeysTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
