import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceKustoConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#additional_properties DataFactoryLinkedServiceKusto#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#annotations DataFactoryLinkedServiceKusto#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#data_factory_id DataFactoryLinkedServiceKusto#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#description DataFactoryLinkedServiceKusto#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#integration_runtime_name DataFactoryLinkedServiceKusto#integration_runtime_name}.
     *
     * @stability stable
     */
    readonly integrationRuntimeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#kusto_database_name DataFactoryLinkedServiceKusto#kusto_database_name}.
     *
     * @stability stable
     */
    readonly kustoDatabaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#kusto_endpoint DataFactoryLinkedServiceKusto#kusto_endpoint}.
     *
     * @stability stable
     */
    readonly kustoEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#name DataFactoryLinkedServiceKusto#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#parameters DataFactoryLinkedServiceKusto#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#service_principal_id DataFactoryLinkedServiceKusto#service_principal_id}.
     *
     * @stability stable
     */
    readonly servicePrincipalId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#service_principal_key DataFactoryLinkedServiceKusto#service_principal_key}.
     *
     * @stability stable
     */
    readonly servicePrincipalKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#tenant DataFactoryLinkedServiceKusto#tenant}.
     *
     * @stability stable
     */
    readonly tenant?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#use_managed_identity DataFactoryLinkedServiceKusto#use_managed_identity}.
     *
     * @stability stable
     */
    readonly useManagedIdentity?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#timeouts DataFactoryLinkedServiceKusto#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryLinkedServiceKustoTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceKustoTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#create DataFactoryLinkedServiceKusto#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#delete DataFactoryLinkedServiceKusto#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#read DataFactoryLinkedServiceKusto#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html#update DataFactoryLinkedServiceKusto#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceKustoTimeoutsToTerraform(struct?: DataFactoryLinkedServiceKustoTimeoutsOutputReference | DataFactoryLinkedServiceKustoTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceKustoTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceKustoTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceKustoTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html azurerm_data_factory_linked_service_kusto}.
 *
 * @stability stable
 */
export declare class DataFactoryLinkedServiceKusto extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_kusto.html azurerm_data_factory_linked_service_kusto} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceKustoConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationRuntimeName?;
    /**
     * @stability stable
     */
    get integrationRuntimeName(): string;
    /**
     * @stability stable
     */
    set integrationRuntimeName(value: string);
    /**
     * @stability stable
     */
    resetIntegrationRuntimeName(): void;
    /**
     * @stability stable
     */
    get integrationRuntimeNameInput(): string | undefined;
    private _kustoDatabaseName?;
    /**
     * @stability stable
     */
    get kustoDatabaseName(): string;
    /**
     * @stability stable
     */
    set kustoDatabaseName(value: string);
    /**
     * @stability stable
     */
    get kustoDatabaseNameInput(): string | undefined;
    private _kustoEndpoint?;
    /**
     * @stability stable
     */
    get kustoEndpoint(): string;
    /**
     * @stability stable
     */
    set kustoEndpoint(value: string);
    /**
     * @stability stable
     */
    get kustoEndpointInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _servicePrincipalId?;
    /**
     * @stability stable
     */
    get servicePrincipalId(): string;
    /**
     * @stability stable
     */
    set servicePrincipalId(value: string);
    /**
     * @stability stable
     */
    resetServicePrincipalId(): void;
    /**
     * @stability stable
     */
    get servicePrincipalIdInput(): string | undefined;
    private _servicePrincipalKey?;
    /**
     * @stability stable
     */
    get servicePrincipalKey(): string;
    /**
     * @stability stable
     */
    set servicePrincipalKey(value: string);
    /**
     * @stability stable
     */
    resetServicePrincipalKey(): void;
    /**
     * @stability stable
     */
    get servicePrincipalKeyInput(): string | undefined;
    private _tenant?;
    /**
     * @stability stable
     */
    get tenant(): string;
    /**
     * @stability stable
     */
    set tenant(value: string);
    /**
     * @stability stable
     */
    resetTenant(): void;
    /**
     * @stability stable
     */
    get tenantInput(): string | undefined;
    private _useManagedIdentity?;
    /**
     * @stability stable
     */
    get useManagedIdentity(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useManagedIdentity(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseManagedIdentity(): void;
    /**
     * @stability stable
     */
    get useManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryLinkedServiceKustoTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryLinkedServiceKustoTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryLinkedServiceKustoTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
