import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DevTestVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#description DevTestVirtualNetwork#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#lab_name DevTestVirtualNetwork#lab_name}.
     *
     * @stability stable
     */
    readonly labName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#name DevTestVirtualNetwork#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#resource_group_name DevTestVirtualNetwork#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#tags DevTestVirtualNetwork#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * subnet block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#subnet DevTestVirtualNetwork#subnet}
     *
     * @stability stable
     */
    readonly subnet?: DevTestVirtualNetworkSubnet;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#timeouts DevTestVirtualNetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DevTestVirtualNetworkTimeouts;
}
/**
 * @stability stable
 */
export interface DevTestVirtualNetworkSubnet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#use_in_virtual_machine_creation DevTestVirtualNetwork#use_in_virtual_machine_creation}.
     *
     * @stability stable
     */
    readonly useInVirtualMachineCreation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#use_public_ip_address DevTestVirtualNetwork#use_public_ip_address}.
     *
     * @stability stable
     */
    readonly usePublicIpAddress?: string;
}
export declare function devTestVirtualNetworkSubnetToTerraform(struct?: DevTestVirtualNetworkSubnetOutputReference | DevTestVirtualNetworkSubnet): any;
/**
 * @stability stable
 */
export declare class DevTestVirtualNetworkSubnetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestVirtualNetworkSubnet | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestVirtualNetworkSubnet | undefined);
    private _useInVirtualMachineCreation?;
    /**
     * @stability stable
     */
    get useInVirtualMachineCreation(): string;
    /**
     * @stability stable
     */
    set useInVirtualMachineCreation(value: string);
    /**
     * @stability stable
     */
    resetUseInVirtualMachineCreation(): void;
    /**
     * @stability stable
     */
    get useInVirtualMachineCreationInput(): string | undefined;
    private _usePublicIpAddress?;
    /**
     * @stability stable
     */
    get usePublicIpAddress(): string;
    /**
     * @stability stable
     */
    set usePublicIpAddress(value: string);
    /**
     * @stability stable
     */
    resetUsePublicIpAddress(): void;
    /**
     * @stability stable
     */
    get usePublicIpAddressInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DevTestVirtualNetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#create DevTestVirtualNetwork#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#delete DevTestVirtualNetwork#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#read DevTestVirtualNetwork#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html#update DevTestVirtualNetwork#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function devTestVirtualNetworkTimeoutsToTerraform(struct?: DevTestVirtualNetworkTimeoutsOutputReference | DevTestVirtualNetworkTimeouts): any;
/**
 * @stability stable
 */
export declare class DevTestVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestVirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestVirtualNetworkTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html azurerm_dev_test_virtual_network}.
 *
 * @stability stable
 */
export declare class DevTestVirtualNetwork extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_virtual_network.html azurerm_dev_test_virtual_network} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DevTestVirtualNetworkConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labName?;
    /**
     * @stability stable
     */
    get labName(): string;
    /**
     * @stability stable
     */
    set labName(value: string);
    /**
     * @stability stable
     */
    get labNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get uniqueIdentifier(): string;
    private _subnet;
    /**
     * @stability stable
     */
    get subnet(): DevTestVirtualNetworkSubnetOutputReference;
    /**
     * @stability stable
     */
    putSubnet(value: DevTestVirtualNetworkSubnet): void;
    /**
     * @stability stable
     */
    resetSubnet(): void;
    /**
     * @stability stable
     */
    get subnetInput(): DevTestVirtualNetworkSubnet | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DevTestVirtualNetworkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DevTestVirtualNetworkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DevTestVirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
