import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LinuxVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#admin_password LinuxVirtualMachine#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#admin_username LinuxVirtualMachine#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#allow_extension_operations LinuxVirtualMachine#allow_extension_operations}.
     *
     * @stability stable
     */
    readonly allowExtensionOperations?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#availability_set_id LinuxVirtualMachine#availability_set_id}.
     *
     * @stability stable
     */
    readonly availabilitySetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#computer_name LinuxVirtualMachine#computer_name}.
     *
     * @stability stable
     */
    readonly computerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#custom_data LinuxVirtualMachine#custom_data}.
     *
     * @stability stable
     */
    readonly customData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#dedicated_host_id LinuxVirtualMachine#dedicated_host_id}.
     *
     * @stability stable
     */
    readonly dedicatedHostId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#disable_password_authentication LinuxVirtualMachine#disable_password_authentication}.
     *
     * @stability stable
     */
    readonly disablePasswordAuthentication?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#encryption_at_host_enabled LinuxVirtualMachine#encryption_at_host_enabled}.
     *
     * @stability stable
     */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#eviction_policy LinuxVirtualMachine#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#extensions_time_budget LinuxVirtualMachine#extensions_time_budget}.
     *
     * @stability stable
     */
    readonly extensionsTimeBudget?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#license_type LinuxVirtualMachine#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#location LinuxVirtualMachine#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#max_bid_price LinuxVirtualMachine#max_bid_price}.
     *
     * @stability stable
     */
    readonly maxBidPrice?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#name LinuxVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#network_interface_ids LinuxVirtualMachine#network_interface_ids}.
     *
     * @stability stable
     */
    readonly networkInterfaceIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#patch_mode LinuxVirtualMachine#patch_mode}.
     *
     * @stability stable
     */
    readonly patchMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#platform_fault_domain LinuxVirtualMachine#platform_fault_domain}.
     *
     * @stability stable
     */
    readonly platformFaultDomain?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#priority LinuxVirtualMachine#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#provision_vm_agent LinuxVirtualMachine#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#proximity_placement_group_id LinuxVirtualMachine#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#resource_group_name LinuxVirtualMachine#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#secure_boot_enabled LinuxVirtualMachine#secure_boot_enabled}.
     *
     * @stability stable
     */
    readonly secureBootEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#size LinuxVirtualMachine#size}.
     *
     * @stability stable
     */
    readonly size: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#source_image_id LinuxVirtualMachine#source_image_id}.
     *
     * @stability stable
     */
    readonly sourceImageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#tags LinuxVirtualMachine#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#virtual_machine_scale_set_id LinuxVirtualMachine#virtual_machine_scale_set_id}.
     *
     * @stability stable
     */
    readonly virtualMachineScaleSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#vtpm_enabled LinuxVirtualMachine#vtpm_enabled}.
     *
     * @stability stable
     */
    readonly vtpmEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#zone LinuxVirtualMachine#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * additional_capabilities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#additional_capabilities LinuxVirtualMachine#additional_capabilities}
     *
     * @stability stable
     */
    readonly additionalCapabilities?: LinuxVirtualMachineAdditionalCapabilities;
    /**
     * admin_ssh_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#admin_ssh_key LinuxVirtualMachine#admin_ssh_key}
     *
     * @stability stable
     */
    readonly adminSshKey?: LinuxVirtualMachineAdminSshKey[];
    /**
     * boot_diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#boot_diagnostics LinuxVirtualMachine#boot_diagnostics}
     *
     * @stability stable
     */
    readonly bootDiagnostics?: LinuxVirtualMachineBootDiagnostics;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#identity LinuxVirtualMachine#identity}
     *
     * @stability stable
     */
    readonly identity?: LinuxVirtualMachineIdentity;
    /**
     * os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#os_disk LinuxVirtualMachine#os_disk}
     *
     * @stability stable
     */
    readonly osDisk: LinuxVirtualMachineOsDisk;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#plan LinuxVirtualMachine#plan}
     *
     * @stability stable
     */
    readonly plan?: LinuxVirtualMachinePlan;
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#secret LinuxVirtualMachine#secret}
     *
     * @stability stable
     */
    readonly secret?: LinuxVirtualMachineSecret[];
    /**
     * source_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#source_image_reference LinuxVirtualMachine#source_image_reference}
     *
     * @stability stable
     */
    readonly sourceImageReference?: LinuxVirtualMachineSourceImageReference;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#timeouts LinuxVirtualMachine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LinuxVirtualMachineTimeouts;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineAdditionalCapabilities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#ultra_ssd_enabled LinuxVirtualMachine#ultra_ssd_enabled}.
     *
     * @stability stable
     */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineAdditionalCapabilitiesToTerraform(struct?: LinuxVirtualMachineAdditionalCapabilitiesOutputReference | LinuxVirtualMachineAdditionalCapabilities): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineAdditionalCapabilities | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    /**
     * @stability stable
     */
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUltraSsdEnabled(): void;
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineAdminSshKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#public_key LinuxVirtualMachine#public_key}.
     *
     * @stability stable
     */
    readonly publicKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#username LinuxVirtualMachine#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function linuxVirtualMachineAdminSshKeyToTerraform(struct?: LinuxVirtualMachineAdminSshKey): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineBootDiagnostics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#storage_account_uri LinuxVirtualMachine#storage_account_uri}.
     *
     * @stability stable
     */
    readonly storageAccountUri?: string;
}
export declare function linuxVirtualMachineBootDiagnosticsToTerraform(struct?: LinuxVirtualMachineBootDiagnosticsOutputReference | LinuxVirtualMachineBootDiagnostics): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineBootDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineBootDiagnostics | undefined);
    private _storageAccountUri?;
    /**
     * @stability stable
     */
    get storageAccountUri(): string;
    /**
     * @stability stable
     */
    set storageAccountUri(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountUri(): void;
    /**
     * @stability stable
     */
    get storageAccountUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#identity_ids LinuxVirtualMachine#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#type LinuxVirtualMachine#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function linuxVirtualMachineIdentityToTerraform(struct?: LinuxVirtualMachineIdentityOutputReference | LinuxVirtualMachineIdentity): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineOsDiskDiffDiskSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#option LinuxVirtualMachine#option}.
     *
     * @stability stable
     */
    readonly option: string;
}
export declare function linuxVirtualMachineOsDiskDiffDiskSettingsToTerraform(struct?: LinuxVirtualMachineOsDiskDiffDiskSettingsOutputReference | LinuxVirtualMachineOsDiskDiffDiskSettings): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineOsDiskDiffDiskSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineOsDiskDiffDiskSettings | undefined);
    private _option?;
    /**
     * @stability stable
     */
    get option(): string;
    /**
     * @stability stable
     */
    set option(value: string);
    /**
     * @stability stable
     */
    get optionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#caching LinuxVirtualMachine#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#disk_encryption_set_id LinuxVirtualMachine#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#disk_size_gb LinuxVirtualMachine#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#name LinuxVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#storage_account_type LinuxVirtualMachine#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#write_accelerator_enabled LinuxVirtualMachine#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
     * diff_disk_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#diff_disk_settings LinuxVirtualMachine#diff_disk_settings}
     *
     * @stability stable
     */
    readonly diffDiskSettings?: LinuxVirtualMachineOsDiskDiffDiskSettings;
}
export declare function linuxVirtualMachineOsDiskToTerraform(struct?: LinuxVirtualMachineOsDiskOutputReference | LinuxVirtualMachineOsDisk): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineOsDisk | undefined);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    set diskEncryptionSetId(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionSetId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountType?;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    set storageAccountType(value: string);
    /**
     * @stability stable
     */
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWriteAcceleratorEnabled(): void;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    /**
     * @stability stable
     */
    get diffDiskSettings(): LinuxVirtualMachineOsDiskDiffDiskSettingsOutputReference;
    /**
     * @stability stable
     */
    putDiffDiskSettings(value: LinuxVirtualMachineOsDiskDiffDiskSettings): void;
    /**
     * @stability stable
     */
    resetDiffDiskSettings(): void;
    /**
     * @stability stable
     */
    get diffDiskSettingsInput(): LinuxVirtualMachineOsDiskDiffDiskSettings | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachinePlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#name LinuxVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#product LinuxVirtualMachine#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#publisher LinuxVirtualMachine#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function linuxVirtualMachinePlanToTerraform(struct?: LinuxVirtualMachinePlanOutputReference | LinuxVirtualMachinePlan): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachinePlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachinePlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachinePlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineSecretCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#url LinuxVirtualMachine#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function linuxVirtualMachineSecretCertificateToTerraform(struct?: LinuxVirtualMachineSecretCertificate): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineSecret {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#key_vault_id LinuxVirtualMachine#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#certificate LinuxVirtualMachine#certificate}
     *
     * @stability stable
     */
    readonly certificate: LinuxVirtualMachineSecretCertificate[];
}
export declare function linuxVirtualMachineSecretToTerraform(struct?: LinuxVirtualMachineSecret): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineSourceImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#offer LinuxVirtualMachine#offer}.
     *
     * @stability stable
     */
    readonly offer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#publisher LinuxVirtualMachine#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#sku LinuxVirtualMachine#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#version LinuxVirtualMachine#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function linuxVirtualMachineSourceImageReferenceToTerraform(struct?: LinuxVirtualMachineSourceImageReferenceOutputReference | LinuxVirtualMachineSourceImageReference): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineSourceImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineSourceImageReference | undefined);
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#create LinuxVirtualMachine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#delete LinuxVirtualMachine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#read LinuxVirtualMachine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html#update LinuxVirtualMachine#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function linuxVirtualMachineTimeoutsToTerraform(struct?: LinuxVirtualMachineTimeoutsOutputReference | LinuxVirtualMachineTimeouts): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html azurerm_linux_virtual_machine}.
 *
 * @stability stable
 */
export declare class LinuxVirtualMachine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine.html azurerm_linux_virtual_machine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LinuxVirtualMachineConfig);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    resetAdminPassword(): void;
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _allowExtensionOperations?;
    /**
     * @stability stable
     */
    get allowExtensionOperations(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowExtensionOperations(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowExtensionOperations(): void;
    /**
     * @stability stable
     */
    get allowExtensionOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilitySetId?;
    /**
     * @stability stable
     */
    get availabilitySetId(): string;
    /**
     * @stability stable
     */
    set availabilitySetId(value: string);
    /**
     * @stability stable
     */
    resetAvailabilitySetId(): void;
    /**
     * @stability stable
     */
    get availabilitySetIdInput(): string | undefined;
    private _computerName?;
    /**
     * @stability stable
     */
    get computerName(): string;
    /**
     * @stability stable
     */
    set computerName(value: string);
    /**
     * @stability stable
     */
    resetComputerName(): void;
    /**
     * @stability stable
     */
    get computerNameInput(): string | undefined;
    private _customData?;
    /**
     * @stability stable
     */
    get customData(): string;
    /**
     * @stability stable
     */
    set customData(value: string);
    /**
     * @stability stable
     */
    resetCustomData(): void;
    /**
     * @stability stable
     */
    get customDataInput(): string | undefined;
    private _dedicatedHostId?;
    /**
     * @stability stable
     */
    get dedicatedHostId(): string;
    /**
     * @stability stable
     */
    set dedicatedHostId(value: string);
    /**
     * @stability stable
     */
    resetDedicatedHostId(): void;
    /**
     * @stability stable
     */
    get dedicatedHostIdInput(): string | undefined;
    private _disablePasswordAuthentication?;
    /**
     * @stability stable
     */
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisablePasswordAuthentication(): void;
    /**
     * @stability stable
     */
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionAtHostEnabled?;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionAtHostEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    private _extensionsTimeBudget?;
    /**
     * @stability stable
     */
    get extensionsTimeBudget(): string;
    /**
     * @stability stable
     */
    set extensionsTimeBudget(value: string);
    /**
     * @stability stable
     */
    resetExtensionsTimeBudget(): void;
    /**
     * @stability stable
     */
    get extensionsTimeBudgetInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    /**
     * @stability stable
     */
    get maxBidPrice(): number;
    /**
     * @stability stable
     */
    set maxBidPrice(value: number);
    /**
     * @stability stable
     */
    resetMaxBidPrice(): void;
    /**
     * @stability stable
     */
    get maxBidPriceInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkInterfaceIds?;
    /**
     * @stability stable
     */
    get networkInterfaceIds(): string[];
    /**
     * @stability stable
     */
    set networkInterfaceIds(value: string[]);
    /**
     * @stability stable
     */
    get networkInterfaceIdsInput(): string[] | undefined;
    private _patchMode?;
    /**
     * @stability stable
     */
    get patchMode(): string;
    /**
     * @stability stable
     */
    set patchMode(value: string);
    /**
     * @stability stable
     */
    resetPatchMode(): void;
    /**
     * @stability stable
     */
    get patchModeInput(): string | undefined;
    private _platformFaultDomain?;
    /**
     * @stability stable
     */
    get platformFaultDomain(): number;
    /**
     * @stability stable
     */
    set platformFaultDomain(value: number);
    /**
     * @stability stable
     */
    resetPlatformFaultDomain(): void;
    /**
     * @stability stable
     */
    get platformFaultDomainInput(): number | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicIpAddress(): string;
    /**
     * @stability stable
     */
    get publicIpAddresses(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _secureBootEnabled?;
    /**
     * @stability stable
     */
    get secureBootEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secureBootEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecureBootEnabled(): void;
    /**
     * @stability stable
     */
    get secureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): string;
    /**
     * @stability stable
     */
    set size(value: string);
    /**
     * @stability stable
     */
    get sizeInput(): string | undefined;
    private _sourceImageId?;
    /**
     * @stability stable
     */
    get sourceImageId(): string;
    /**
     * @stability stable
     */
    set sourceImageId(value: string);
    /**
     * @stability stable
     */
    resetSourceImageId(): void;
    /**
     * @stability stable
     */
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    private _virtualMachineScaleSetId?;
    /**
     * @stability stable
     */
    get virtualMachineScaleSetId(): string;
    /**
     * @stability stable
     */
    set virtualMachineScaleSetId(value: string);
    /**
     * @stability stable
     */
    resetVirtualMachineScaleSetId(): void;
    /**
     * @stability stable
     */
    get virtualMachineScaleSetIdInput(): string | undefined;
    private _vtpmEnabled?;
    /**
     * @stability stable
     */
    get vtpmEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vtpmEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVtpmEnabled(): void;
    /**
     * @stability stable
     */
    get vtpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _additionalCapabilities;
    /**
     * @stability stable
     */
    get additionalCapabilities(): LinuxVirtualMachineAdditionalCapabilitiesOutputReference;
    /**
     * @stability stable
     */
    putAdditionalCapabilities(value: LinuxVirtualMachineAdditionalCapabilities): void;
    /**
     * @stability stable
     */
    resetAdditionalCapabilities(): void;
    /**
     * @stability stable
     */
    get additionalCapabilitiesInput(): LinuxVirtualMachineAdditionalCapabilities | undefined;
    private _adminSshKey?;
    /**
     * @stability stable
     */
    get adminSshKey(): LinuxVirtualMachineAdminSshKey[];
    /**
     * @stability stable
     */
    set adminSshKey(value: LinuxVirtualMachineAdminSshKey[]);
    /**
     * @stability stable
     */
    resetAdminSshKey(): void;
    /**
     * @stability stable
     */
    get adminSshKeyInput(): LinuxVirtualMachineAdminSshKey[] | undefined;
    private _bootDiagnostics;
    /**
     * @stability stable
     */
    get bootDiagnostics(): LinuxVirtualMachineBootDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putBootDiagnostics(value: LinuxVirtualMachineBootDiagnostics): void;
    /**
     * @stability stable
     */
    resetBootDiagnostics(): void;
    /**
     * @stability stable
     */
    get bootDiagnosticsInput(): LinuxVirtualMachineBootDiagnostics | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): LinuxVirtualMachineIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: LinuxVirtualMachineIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): LinuxVirtualMachineIdentity | undefined;
    private _osDisk;
    /**
     * @stability stable
     */
    get osDisk(): LinuxVirtualMachineOsDiskOutputReference;
    /**
     * @stability stable
     */
    putOsDisk(value: LinuxVirtualMachineOsDisk): void;
    /**
     * @stability stable
     */
    get osDiskInput(): LinuxVirtualMachineOsDisk | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): LinuxVirtualMachinePlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: LinuxVirtualMachinePlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): LinuxVirtualMachinePlan | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): LinuxVirtualMachineSecret[];
    /**
     * @stability stable
     */
    set secret(value: LinuxVirtualMachineSecret[]);
    /**
     * @stability stable
     */
    resetSecret(): void;
    /**
     * @stability stable
     */
    get secretInput(): LinuxVirtualMachineSecret[] | undefined;
    private _sourceImageReference;
    /**
     * @stability stable
     */
    get sourceImageReference(): LinuxVirtualMachineSourceImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putSourceImageReference(value: LinuxVirtualMachineSourceImageReference): void;
    /**
     * @stability stable
     */
    resetSourceImageReference(): void;
    /**
     * @stability stable
     */
    get sourceImageReferenceInput(): LinuxVirtualMachineSourceImageReference | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LinuxVirtualMachineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LinuxVirtualMachineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LinuxVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
