import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MachineLearningComputeClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#description MachineLearningComputeCluster#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#local_auth_enabled MachineLearningComputeCluster#local_auth_enabled}.
     *
     * @stability stable
     */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#location MachineLearningComputeCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#machine_learning_workspace_id MachineLearningComputeCluster#machine_learning_workspace_id}.
     *
     * @stability stable
     */
    readonly machineLearningWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#name MachineLearningComputeCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#ssh_public_access_enabled MachineLearningComputeCluster#ssh_public_access_enabled}.
     *
     * @stability stable
     */
    readonly sshPublicAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#subnet_resource_id MachineLearningComputeCluster#subnet_resource_id}.
     *
     * @stability stable
     */
    readonly subnetResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#tags MachineLearningComputeCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#vm_priority MachineLearningComputeCluster#vm_priority}.
     *
     * @stability stable
     */
    readonly vmPriority: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#vm_size MachineLearningComputeCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#identity MachineLearningComputeCluster#identity}
     *
     * @stability stable
     */
    readonly identity?: MachineLearningComputeClusterIdentity;
    /**
     * scale_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#scale_settings MachineLearningComputeCluster#scale_settings}
     *
     * @stability stable
     */
    readonly scaleSettings: MachineLearningComputeClusterScaleSettings;
    /**
     * ssh block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#ssh MachineLearningComputeCluster#ssh}
     *
     * @stability stable
     */
    readonly ssh?: MachineLearningComputeClusterSsh;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#timeouts MachineLearningComputeCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MachineLearningComputeClusterTimeouts;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeClusterIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#identity_ids MachineLearningComputeCluster#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#type MachineLearningComputeCluster#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function machineLearningComputeClusterIdentityToTerraform(struct?: MachineLearningComputeClusterIdentityOutputReference | MachineLearningComputeClusterIdentity): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeClusterIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeClusterIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeClusterScaleSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#max_node_count MachineLearningComputeCluster#max_node_count}.
     *
     * @stability stable
     */
    readonly maxNodeCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#min_node_count MachineLearningComputeCluster#min_node_count}.
     *
     * @stability stable
     */
    readonly minNodeCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#scale_down_nodes_after_idle_duration MachineLearningComputeCluster#scale_down_nodes_after_idle_duration}.
     *
     * @stability stable
     */
    readonly scaleDownNodesAfterIdleDuration: string;
}
export declare function machineLearningComputeClusterScaleSettingsToTerraform(struct?: MachineLearningComputeClusterScaleSettingsOutputReference | MachineLearningComputeClusterScaleSettings): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeClusterScaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeClusterScaleSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeClusterScaleSettings | undefined);
    private _maxNodeCount?;
    /**
     * @stability stable
     */
    get maxNodeCount(): number;
    /**
     * @stability stable
     */
    set maxNodeCount(value: number);
    /**
     * @stability stable
     */
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    /**
     * @stability stable
     */
    get minNodeCount(): number;
    /**
     * @stability stable
     */
    set minNodeCount(value: number);
    /**
     * @stability stable
     */
    get minNodeCountInput(): number | undefined;
    private _scaleDownNodesAfterIdleDuration?;
    /**
     * @stability stable
     */
    get scaleDownNodesAfterIdleDuration(): string;
    /**
     * @stability stable
     */
    set scaleDownNodesAfterIdleDuration(value: string);
    /**
     * @stability stable
     */
    get scaleDownNodesAfterIdleDurationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeClusterSsh {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#admin_password MachineLearningComputeCluster#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#admin_username MachineLearningComputeCluster#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#key_value MachineLearningComputeCluster#key_value}.
     *
     * @stability stable
     */
    readonly keyValue?: string;
}
export declare function machineLearningComputeClusterSshToTerraform(struct?: MachineLearningComputeClusterSshOutputReference | MachineLearningComputeClusterSsh): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeClusterSshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeClusterSsh | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeClusterSsh | undefined);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    resetAdminPassword(): void;
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _keyValue?;
    /**
     * @stability stable
     */
    get keyValue(): string;
    /**
     * @stability stable
     */
    set keyValue(value: string);
    /**
     * @stability stable
     */
    resetKeyValue(): void;
    /**
     * @stability stable
     */
    get keyValueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#create MachineLearningComputeCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#delete MachineLearningComputeCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html#read MachineLearningComputeCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function machineLearningComputeClusterTimeoutsToTerraform(struct?: MachineLearningComputeClusterTimeoutsOutputReference | MachineLearningComputeClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html azurerm_machine_learning_compute_cluster}.
 *
 * @stability stable
 */
export declare class MachineLearningComputeCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster.html azurerm_machine_learning_compute_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MachineLearningComputeClusterConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _localAuthEnabled?;
    /**
     * @stability stable
     */
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthEnabled(): void;
    /**
     * @stability stable
     */
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    /**
     * @stability stable
     */
    get machineLearningWorkspaceId(): string;
    /**
     * @stability stable
     */
    set machineLearningWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sshPublicAccessEnabled?;
    /**
     * @stability stable
     */
    get sshPublicAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sshPublicAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSshPublicAccessEnabled(): void;
    /**
     * @stability stable
     */
    get sshPublicAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetResourceId?;
    /**
     * @stability stable
     */
    get subnetResourceId(): string;
    /**
     * @stability stable
     */
    set subnetResourceId(value: string);
    /**
     * @stability stable
     */
    resetSubnetResourceId(): void;
    /**
     * @stability stable
     */
    get subnetResourceIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vmPriority?;
    /**
     * @stability stable
     */
    get vmPriority(): string;
    /**
     * @stability stable
     */
    set vmPriority(value: string);
    /**
     * @stability stable
     */
    get vmPriorityInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MachineLearningComputeClusterIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MachineLearningComputeClusterIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): MachineLearningComputeClusterIdentity | undefined;
    private _scaleSettings;
    /**
     * @stability stable
     */
    get scaleSettings(): MachineLearningComputeClusterScaleSettingsOutputReference;
    /**
     * @stability stable
     */
    putScaleSettings(value: MachineLearningComputeClusterScaleSettings): void;
    /**
     * @stability stable
     */
    get scaleSettingsInput(): MachineLearningComputeClusterScaleSettings | undefined;
    private _ssh;
    /**
     * @stability stable
     */
    get ssh(): MachineLearningComputeClusterSshOutputReference;
    /**
     * @stability stable
     */
    putSsh(value: MachineLearningComputeClusterSsh): void;
    /**
     * @stability stable
     */
    resetSsh(): void;
    /**
     * @stability stable
     */
    get sshInput(): MachineLearningComputeClusterSsh | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MachineLearningComputeClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MachineLearningComputeClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MachineLearningComputeClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
