import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlServerVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#server_security_alert_policy_id MssqlServerVulnerabilityAssessment#server_security_alert_policy_id}.
     *
     * @stability stable
     */
    readonly serverSecurityAlertPolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#storage_account_access_key MssqlServerVulnerabilityAssessment#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#storage_container_path MssqlServerVulnerabilityAssessment#storage_container_path}.
     *
     * @stability stable
     */
    readonly storageContainerPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#storage_container_sas_key MssqlServerVulnerabilityAssessment#storage_container_sas_key}.
     *
     * @stability stable
     */
    readonly storageContainerSasKey?: string;
    /**
     * recurring_scans block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#recurring_scans MssqlServerVulnerabilityAssessment#recurring_scans}
     *
     * @stability stable
     */
    readonly recurringScans?: MssqlServerVulnerabilityAssessmentRecurringScans;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#timeouts MssqlServerVulnerabilityAssessment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlServerVulnerabilityAssessmentTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlServerVulnerabilityAssessmentRecurringScans {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#email_subscription_admins MssqlServerVulnerabilityAssessment#email_subscription_admins}.
     *
     * @stability stable
     */
    readonly emailSubscriptionAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#emails MssqlServerVulnerabilityAssessment#emails}.
     *
     * @stability stable
     */
    readonly emails?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#enabled MssqlServerVulnerabilityAssessment#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function mssqlServerVulnerabilityAssessmentRecurringScansToTerraform(struct?: MssqlServerVulnerabilityAssessmentRecurringScansOutputReference | MssqlServerVulnerabilityAssessmentRecurringScans): any;
/**
 * @stability stable
 */
export declare class MssqlServerVulnerabilityAssessmentRecurringScansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlServerVulnerabilityAssessmentRecurringScans | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlServerVulnerabilityAssessmentRecurringScans | undefined);
    private _emailSubscriptionAdmins?;
    /**
     * @stability stable
     */
    get emailSubscriptionAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailSubscriptionAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailSubscriptionAdmins(): void;
    /**
     * @stability stable
     */
    get emailSubscriptionAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _emails?;
    /**
     * @stability stable
     */
    get emails(): string[];
    /**
     * @stability stable
     */
    set emails(value: string[]);
    /**
     * @stability stable
     */
    resetEmails(): void;
    /**
     * @stability stable
     */
    get emailsInput(): string[] | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MssqlServerVulnerabilityAssessmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#create MssqlServerVulnerabilityAssessment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#delete MssqlServerVulnerabilityAssessment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#read MssqlServerVulnerabilityAssessment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html#update MssqlServerVulnerabilityAssessment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlServerVulnerabilityAssessmentTimeoutsToTerraform(struct?: MssqlServerVulnerabilityAssessmentTimeoutsOutputReference | MssqlServerVulnerabilityAssessmentTimeouts): any;
/**
 * @stability stable
 */
export declare class MssqlServerVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlServerVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlServerVulnerabilityAssessmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html azurerm_mssql_server_vulnerability_assessment}.
 *
 * @stability stable
 */
export declare class MssqlServerVulnerabilityAssessment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment.html azurerm_mssql_server_vulnerability_assessment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlServerVulnerabilityAssessmentConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _serverSecurityAlertPolicyId?;
    /**
     * @stability stable
     */
    get serverSecurityAlertPolicyId(): string;
    /**
     * @stability stable
     */
    set serverSecurityAlertPolicyId(value: string);
    /**
     * @stability stable
     */
    get serverSecurityAlertPolicyIdInput(): string | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageContainerPath?;
    /**
     * @stability stable
     */
    get storageContainerPath(): string;
    /**
     * @stability stable
     */
    set storageContainerPath(value: string);
    /**
     * @stability stable
     */
    get storageContainerPathInput(): string | undefined;
    private _storageContainerSasKey?;
    /**
     * @stability stable
     */
    get storageContainerSasKey(): string;
    /**
     * @stability stable
     */
    set storageContainerSasKey(value: string);
    /**
     * @stability stable
     */
    resetStorageContainerSasKey(): void;
    /**
     * @stability stable
     */
    get storageContainerSasKeyInput(): string | undefined;
    private _recurringScans;
    /**
     * @stability stable
     */
    get recurringScans(): MssqlServerVulnerabilityAssessmentRecurringScansOutputReference;
    /**
     * @stability stable
     */
    putRecurringScans(value: MssqlServerVulnerabilityAssessmentRecurringScans): void;
    /**
     * @stability stable
     */
    resetRecurringScans(): void;
    /**
     * @stability stable
     */
    get recurringScansInput(): MssqlServerVulnerabilityAssessmentRecurringScans | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlServerVulnerabilityAssessmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlServerVulnerabilityAssessmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlServerVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
