/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.frontend;

import com.alibaba.graphscope.common.client.HostsChannelFetcher;
import com.alibaba.graphscope.common.client.RpcChannelFetcher;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.alibaba.graphscope.common.config.GraphConfig;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.common.store.IrMetaFetcher;
import com.alibaba.graphscope.frontend.VineyardMetaFetcher;
import com.alibaba.graphscope.gremlin.integration.result.GraphProperties;
import com.alibaba.graphscope.gremlin.integration.result.TestGraphFactory;
import com.alibaba.graphscope.gremlin.service.IrGremlinServer;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frontend
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Frontend.class);
    private IrGremlinServer server;
    private Configs configs;

    public Frontend(String configFile) throws IOException {
        this(new Configs(configFile));
    }

    public Frontend(Configs configs) {
        this.configs = configs;
    }

    public void start() throws Exception {
        logger.info("Configs {}", (Object)this.configs.toString());
        String vineyardSchemaPath = (String)GraphConfig.GRAPH_SCHEMA.get(this.configs);
        logger.info("Read schema from vineyard schema file {}", (Object)vineyardSchemaPath);
        VineyardMetaFetcher irMetaFetcher = new VineyardMetaFetcher(vineyardSchemaPath);
        HostsChannelFetcher channelFetcher = new HostsChannelFetcher(this.configs);
        int port = (Integer)FrontendConfig.FRONTEND_SERVICE_PORT.get(this.configs);
        IrMetaQueryCallback queryCallback = new IrMetaQueryCallback((IrMetaFetcher)irMetaFetcher);
        this.server = new IrGremlinServer(port);
        this.server.start(this.configs, (IrMetaFetcher)irMetaFetcher, (RpcChannelFetcher)channelFetcher, queryCallback, (GraphProperties)TestGraphFactory.VINEYARD);
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.close();
        }
    }

    public static void main(String[] args) {
        logger.info("start to run Frontend.");
        if (args == null || args.length < 1) {
            logger.error("Please give the path of config file.");
            System.exit(1);
        }
        try (Frontend frontend = new Frontend(args[0]);){
            frontend.start();
            CountDownLatch shutdown = new CountDownLatch(1);
            shutdown.await();
        }
        catch (Throwable t) {
            logger.error("Error in frontend main:", t);
            System.exit(1);
        }
        System.exit(0);
    }
}

