/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.compiler.api.schema;

import com.alibaba.graphscope.proto.DataTypePb;
import com.alibaba.graphscope.sdkcommon.meta.InternalDataType;
import com.google.common.collect.Lists;
import java.util.Date;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public enum DataType {
    UNKNOWN(0),
    BOOL(1),
    CHAR(2),
    SHORT(3),
    INT(4),
    LONG(5),
    FLOAT(6),
    DOUBLE(7),
    STRING(8),
    BYTES(9),
    INT_LIST(10),
    LONG_LIST(11),
    FLOAT_LIST(12),
    DOUBLE_LIST(13),
    STRING_LIST(14),
    BYTES_LIST(15),
    DATE(16);

    private final byte type;
    private static final DataType[] TYPES;

    private DataType(int type) {
        this.type = (byte)type;
    }

    public static DataType fromId(byte id) {
        if (id < 0 || id >= TYPES.length) {
            throw new IllegalArgumentException("Unknown DataType: [" + id + "]");
        }
        return TYPES[id];
    }

    public static DataType parseProto(DataTypePb pb) {
        return DataType.fromId((byte)pb.getNumber());
    }

    public static DataType parseString(String type) {
        String upperType = StringUtils.upperCase((String)type);
        if (StringUtils.startsWith((CharSequence)upperType, (CharSequence)"LIST<")) {
            String typeValue = StringUtils.removeEnd((String)StringUtils.removeStart((String)upperType, (String)"LIST<"), (String)">") + "_LIST";
            return DataType.valueOf(typeValue);
        }
        return DataType.valueOf(type);
    }

    public DataTypePb toProto() {
        return DataTypePb.forNumber(this.type);
    }

    public String toString() {
        String dataTypeString = this.name();
        if (StringUtils.endsWith((CharSequence)dataTypeString, (CharSequence)"_LIST")) {
            String[] dataTypeArray = StringUtils.splitByWholeSeparator((String)dataTypeString, (String)"_");
            dataTypeString = "LIST<" + dataTypeArray[0] + ">";
        }
        return dataTypeString;
    }

    public boolean isFixedLength() {
        switch (this) {
            case BOOL: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public int getTypeLength() {
        switch (this) {
            case BOOL: {
                return 1;
            }
            case CHAR: {
                return 2;
            }
            case SHORT: {
                return 2;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
        }
        throw new UnsupportedOperationException("not a fixed length type [" + (Object)((Object)this) + "]");
    }

    public static DataType parseFromDataType(com.alibaba.graphscope.sdkcommon.meta.DataType dataType) {
        InternalDataType internalDataType = dataType.getType();
        switch (internalDataType) {
            case BOOL: {
                return BOOL;
            }
            case CHAR: {
                return CHAR;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case BYTES: {
                return BYTES;
            }
            case DATE: {
                return STRING;
            }
            case LIST: {
                switch (InternalDataType.valueOf(dataType.getExpression())) {
                    case INT: {
                        return INT_LIST;
                    }
                    case LONG: {
                        return LONG_LIST;
                    }
                    case FLOAT: {
                        return FLOAT_LIST;
                    }
                    case DOUBLE: {
                        return DOUBLE_LIST;
                    }
                    case STRING: {
                        return STRING_LIST;
                    }
                }
                throw new IllegalArgumentException("Unsupport property data type " + dataType.toString());
            }
        }
        throw new IllegalArgumentException("Unsupport property data type " + dataType.toString());
    }

    public Object getRandomValue() {
        switch (this) {
            case BOOL: {
                return RandomUtils.nextInt((int)0, (int)2) != 0;
            }
            case CHAR: {
                return (char)Math.abs(RandomUtils.nextInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE)) % 127;
            }
            case DATE: {
                return new Date().toString();
            }
            case SHORT: {
                return (short)RandomUtils.nextInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
            }
            case INT: {
                return RandomUtils.nextInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
            }
            case LONG: {
                return RandomUtils.nextLong((long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
            }
            case FLOAT: {
                return Float.valueOf(RandomUtils.nextFloat((float)Float.MIN_VALUE, (float)Float.MAX_VALUE));
            }
            case DOUBLE: {
                return RandomUtils.nextDouble((double)Double.MIN_VALUE, (double)Double.MAX_VALUE);
            }
            case STRING: {
                return RandomStringUtils.randomAlphanumeric((int)64);
            }
            case BYTES: {
                return RandomStringUtils.random((int)64).getBytes();
            }
            case INT_LIST: {
                return Lists.newArrayList((Object[])new Integer[]{RandomUtils.nextInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE), RandomUtils.nextInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE), RandomUtils.nextInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE)});
            }
            case LONG_LIST: {
                return Lists.newArrayList((Object[])new Long[]{RandomUtils.nextLong((long)Long.MIN_VALUE, (long)Long.MAX_VALUE), RandomUtils.nextLong((long)Long.MIN_VALUE, (long)Long.MAX_VALUE), RandomUtils.nextLong((long)Long.MIN_VALUE, (long)Long.MAX_VALUE)});
            }
            case FLOAT_LIST: {
                return Lists.newArrayList((Object[])new Float[]{Float.valueOf(RandomUtils.nextFloat((float)Float.MIN_VALUE, (float)Float.MAX_VALUE)), Float.valueOf(RandomUtils.nextFloat((float)Float.MIN_VALUE, (float)Float.MAX_VALUE)), Float.valueOf(RandomUtils.nextFloat((float)Float.MIN_VALUE, (float)Float.MAX_VALUE))});
            }
            case DOUBLE_LIST: {
                return Lists.newArrayList((Object[])new Double[]{RandomUtils.nextDouble((double)Double.MIN_VALUE, (double)Double.MAX_VALUE), RandomUtils.nextDouble((double)Double.MIN_VALUE, (double)Double.MAX_VALUE), RandomUtils.nextDouble((double)Double.MIN_VALUE, (double)Double.MAX_VALUE)});
            }
            case STRING_LIST: {
                return Lists.newArrayList((Object[])new String[]{RandomStringUtils.randomAlphanumeric((int)64), RandomStringUtils.randomAlphanumeric((int)64), RandomStringUtils.randomAlphanumeric((int)64)});
            }
            case BYTES_LIST: {
                return Lists.newArrayList((Object[])new byte[][]{RandomStringUtils.randomAlphanumeric((int)64).getBytes(), RandomStringUtils.randomAlphanumeric((int)64).getBytes(), RandomStringUtils.randomAlphanumeric((int)64).getBytes()});
            }
        }
        throw new IllegalArgumentException("Unknown prop data type " + (Object)((Object)this));
    }

    static {
        TYPES = DataType.values();
    }
}

