/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.compiler.api.schema;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.graphscope.compiler.api.exception.GraphElementNotFoundException;
import com.alibaba.graphscope.compiler.api.exception.GraphPropertyNotFoundException;
import com.alibaba.graphscope.compiler.api.schema.EdgeRelation;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphElement;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import java.util.List;
import java.util.Map;

public interface GraphSchema {
    public GraphElement getElement(String var1) throws GraphElementNotFoundException;

    public GraphElement getElement(int var1) throws GraphElementNotFoundException;

    public List<GraphVertex> getVertexList();

    public List<GraphEdge> getEdgeList();

    public Integer getPropertyId(String var1) throws GraphPropertyNotFoundException;

    public String getPropertyName(int var1) throws GraphPropertyNotFoundException;

    public Map<GraphElement, GraphProperty> getPropertyList(String var1);

    public Map<GraphElement, GraphProperty> getPropertyList(int var1);

    public int getVersion();

    default public String formatJson() {
        JSONObject propObject;
        JSONArray propArray;
        JSONObject typeObject;
        JSONObject jsonObject = new JSONObject();
        JSONArray typeArray = new JSONArray();
        for (GraphVertex vertex : this.getVertexList()) {
            typeObject = new JSONObject();
            typeObject.put("id", (Object)vertex.getLabelId());
            typeObject.put("label", (Object)vertex.getLabel());
            typeObject.put("type", (Object)"VERTEX");
            propArray = new JSONArray();
            for (GraphProperty property : vertex.getPropertyList()) {
                propObject = new JSONObject();
                propObject.put("name", (Object)property.getName());
                propObject.put("id", (Object)property.getId());
                propObject.put("data_type", (Object)property.getDataType().toString());
                propArray.add((Object)propObject);
            }
            typeObject.put("propertyDefList", (Object)propArray);
            JSONArray indexArray = new JSONArray();
            JSONObject indexObject = new JSONObject();
            JSONArray propertyNamesArray = new JSONArray();
            for (GraphProperty primaryKeyProp : vertex.getPrimaryKeyList()) {
                propertyNamesArray.add((Object)primaryKeyProp.getName());
            }
            indexObject.put("primaryKeyList", (Object)propertyNamesArray);
            indexArray.add((Object)indexObject);
            typeObject.put("indexes", (Object)indexArray);
            typeArray.add((Object)typeObject);
        }
        for (GraphEdge edge : this.getEdgeList()) {
            typeObject = new JSONObject();
            typeObject.put("id", (Object)edge.getLabelId());
            typeObject.put("label", (Object)edge.getLabel());
            typeObject.put("type", (Object)"EDGE");
            propArray = new JSONArray();
            for (GraphProperty property : edge.getPropertyList()) {
                propObject = new JSONObject();
                propObject.put("name", (Object)property.getName());
                propObject.put("id", (Object)property.getId());
                propObject.put("data_type", (Object)property.getDataType().toString());
                propArray.add((Object)propObject);
            }
            typeObject.put("propertyDefList", (Object)propArray);
            JSONArray relationArray = new JSONArray();
            for (EdgeRelation relation : edge.getRelationList()) {
                JSONObject relationObject = new JSONObject();
                relationObject.put("srcVertexLabel", (Object)relation.getSource().getLabel());
                relationObject.put("dstVertexLabel", (Object)relation.getTarget().getLabel());
                relationArray.add((Object)relationObject);
            }
            typeObject.put("rawRelationShips", (Object)relationArray);
            typeArray.add((Object)typeObject);
        }
        jsonObject.put("types", (Object)typeArray);
        return jsonObject.toJSONString();
    }
}

