/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.compiler.api.schema;

import com.alibaba.graphscope.compiler.api.exception.GraphSchemaException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class PrimaryKeyConstraint {
    private List<String> primaryKeyList;

    public PrimaryKeyConstraint(List<String> primaryKeyList) {
        if (primaryKeyList == null || primaryKeyList.isEmpty()) {
            throw new GraphSchemaException("primary key cant be null or empty");
        }
        this.primaryKeyList = primaryKeyList;
    }

    public List<String> getPrimaryKeyList() {
        return ImmutableList.copyOf(this.primaryKeyList);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("primaryKeyList", this.primaryKeyList).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimaryKeyConstraint that = (PrimaryKeyConstraint)o;
        return Objects.equals(this.primaryKeyList, that.primaryKeyList);
    }

    public int hashCode() {
        return Objects.hash(this.primaryKeyList);
    }
}

