/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.compiler.schema;

import com.alibaba.graphscope.compiler.api.schema.EdgeRelation;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultGraphEdge
implements GraphEdge {
    private int id;
    private String label;
    private List<GraphProperty> propertyList;
    private List<EdgeRelation> relationList;

    public DefaultGraphEdge(int id, String label, List<GraphProperty> propertyList, List<EdgeRelation> relationList) {
        this.id = id;
        this.label = label;
        this.propertyList = propertyList;
        this.relationList = relationList;
    }

    @Override
    public List<EdgeRelation> getRelationList() {
        return this.relationList;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.id;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public GraphProperty getProperty(int propId) {
        for (GraphProperty property : this.propertyList) {
            if (property.getId() != propId) continue;
            return property;
        }
        throw new IllegalArgumentException("Invalid property id " + propId);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        for (GraphProperty property : this.propertyList) {
            if (!StringUtils.equals((CharSequence)propName, (CharSequence)property.getName())) continue;
            return property;
        }
        throw new IllegalArgumentException("Invalid property name " + propName);
    }

    @Override
    public int getVersionId() {
        return 0;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        return null;
    }

    @Override
    public List<Integer> getPkPropertyIndices() {
        return null;
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("label", (Object)this.label).add("propertyList", this.propertyList).add("relationList", this.relationList).toString();
    }
}

