/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.compiler.schema;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.graphscope.compiler.api.exception.GraphElementNotFoundException;
import com.alibaba.graphscope.compiler.api.exception.GraphPropertyNotFoundException;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphElement;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphSchema;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.compiler.schema.DefaultEdgeRelation;
import com.alibaba.graphscope.compiler.schema.DefaultGraphEdge;
import com.alibaba.graphscope.compiler.schema.DefaultGraphProperty;
import com.alibaba.graphscope.compiler.schema.DefaultGraphVertex;
import com.alibaba.graphscope.sdkcommon.exception.GrootException;
import com.alibaba.graphscope.sdkcommon.meta.DataType;
import com.alibaba.graphscope.sdkcommon.meta.InternalDataType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphSchema
implements GraphSchema {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGraphSchema.class);
    private Map<String, GraphVertex> vertexList;
    private Map<String, GraphEdge> edgeList;
    private Map<String, Integer> propNameToIdList;
    private Map<Integer, String> idToLabelList = Maps.newHashMap();

    public DefaultGraphSchema(Map<String, GraphVertex> vertexList, Map<String, GraphEdge> edgeList, Map<String, Integer> propNameToIdList) {
        this.vertexList = vertexList;
        this.edgeList = edgeList;
        vertexList.forEach((key, value) -> this.idToLabelList.put(value.getLabelId(), (String)key));
        edgeList.forEach((key, value) -> this.idToLabelList.put(value.getLabelId(), (String)key));
        this.propNameToIdList = propNameToIdList;
    }

    @Override
    public GraphElement getElement(String label) throws GraphElementNotFoundException {
        if (this.vertexList.containsKey(label)) {
            return this.vertexList.get(label);
        }
        if (this.edgeList.containsKey(label)) {
            return this.edgeList.get(label);
        }
        throw new GraphElementNotFoundException("label " + label + " not exist");
    }

    @Override
    public GraphElement getElement(int labelId) throws GraphElementNotFoundException {
        if (this.idToLabelList.containsKey(labelId)) {
            return this.getElement(this.idToLabelList.get(labelId));
        }
        throw new GraphElementNotFoundException("label not exist for labelid " + labelId);
    }

    @Override
    public List<GraphVertex> getVertexList() {
        return Lists.newArrayList(this.vertexList.values());
    }

    @Override
    public List<GraphEdge> getEdgeList() {
        return Lists.newArrayList(this.edgeList.values());
    }

    @Override
    public Integer getPropertyId(String propName) throws GraphPropertyNotFoundException {
        if (this.propNameToIdList.containsKey(propName)) {
            return this.propNameToIdList.get(propName);
        }
        throw new GraphPropertyNotFoundException("property " + propName + " not exist");
    }

    @Override
    public String getPropertyName(int propId) throws GraphPropertyNotFoundException {
        for (Map.Entry<String, Integer> entry : this.propNameToIdList.entrySet()) {
            if (entry.getValue() != propId) continue;
            return entry.getKey();
        }
        throw new GraphPropertyNotFoundException("property not exist for property id " + propId);
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(String propName) {
        HashMap elementPropertyList = Maps.newHashMap();
        this.vertexList.forEach((key, value) -> {
            for (GraphProperty property : value.getPropertyList()) {
                if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)propName)) continue;
                elementPropertyList.put(value, property);
            }
        });
        this.edgeList.forEach((key, value) -> {
            for (GraphProperty property : value.getPropertyList()) {
                if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)propName)) continue;
                elementPropertyList.put(value, property);
            }
        });
        return elementPropertyList;
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(int propId) {
        try {
            String propName = this.getPropertyName(propId);
            return this.getPropertyList(propName);
        }
        catch (Exception ignored) {
            return Maps.newHashMap();
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    public static GraphSchema buildSchemaFromJson(String schemaJson) {
        JSONObject jsonObject = JSONObject.parseObject((String)schemaJson);
        HashMap vertexList = Maps.newHashMap();
        HashMap edgeList = Maps.newHashMap();
        HashMap propNameToIdList = Maps.newHashMap();
        JSONArray typeList = jsonObject.getJSONArray("types");
        if (null != typeList) {
            int propId = 1;
            for (int i = 0; i < typeList.size(); ++i) {
                JSONObject typeObject = typeList.getJSONObject(i);
                int labelId = typeObject.getInteger("id");
                String label = typeObject.getString("label");
                String type = typeObject.getString("type");
                HashMap namePropertyList = Maps.newHashMap();
                ArrayList propertyList = Lists.newArrayList();
                JSONArray propArray = typeObject.getJSONArray("propertyDefList");
                if (null != propArray) {
                    for (int j = 0; j < propArray.size(); ++j) {
                        DataType dataType;
                        String propDataTypeString;
                        JSONObject propObject = propArray.getJSONObject(j);
                        String propName = propObject.getString("name");
                        Integer currPropId = propObject.getInteger("id");
                        if (null == currPropId) {
                            currPropId = propId++;
                        }
                        if (StringUtils.startsWith((CharSequence)(propDataTypeString = propObject.getString("data_type")), (CharSequence)"LIST")) {
                            dataType = new DataType(InternalDataType.LIST);
                            try {
                                dataType.setExpression(StringUtils.removeEnd((String)StringUtils.removeStart((String)propDataTypeString, (String)"LIST<"), (String)">"));
                            }
                            catch (GrootException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            dataType = DataType.valueOf(propDataTypeString);
                        }
                        DefaultGraphProperty property = new DefaultGraphProperty(currPropId, propName, com.alibaba.graphscope.compiler.api.schema.DataType.parseFromDataType(dataType));
                        propertyList.add(property);
                        namePropertyList.put(propName, property);
                        propNameToIdList.put(propName, currPropId);
                    }
                } else {
                    logger.warn("There's no property def list in " + label);
                }
                if (StringUtils.equals((CharSequence)type, (CharSequence)"VERTEX")) {
                    ArrayList primaryPropertyList = Lists.newArrayList();
                    JSONArray indexArray = typeObject.getJSONArray("indexes");
                    if (indexArray != null) {
                        for (int k = 0; k < indexArray.size(); ++k) {
                            JSONObject indexObject = indexArray.getJSONObject(k);
                            JSONArray priNameList = indexObject.getJSONArray("propertyNames");
                            for (int j = 0; j < priNameList.size(); ++j) {
                                primaryPropertyList.add(namePropertyList.get(priNameList.getString(j)));
                            }
                        }
                    }
                    DefaultGraphVertex graphVertex = new DefaultGraphVertex(labelId, label, propertyList, primaryPropertyList);
                    vertexList.put(label, graphVertex);
                    continue;
                }
                ArrayList relationList = Lists.newArrayList();
                JSONArray relationArray = typeObject.getJSONArray("rawRelationShips");
                if (null != relationArray) {
                    for (int k = 0; k < relationArray.size(); ++k) {
                        JSONObject relationObject = relationArray.getJSONObject(k);
                        String sourceLabel = relationObject.getString("srcVertexLabel");
                        String targetLabel = relationObject.getString("dstVertexLabel");
                        relationList.add(new DefaultEdgeRelation((GraphVertex)vertexList.get(sourceLabel), (GraphVertex)vertexList.get(targetLabel)));
                    }
                } else {
                    logger.warn("There's no relation def in edge " + label);
                }
                DefaultGraphEdge graphEdge = new DefaultGraphEdge(labelId, label, propertyList, relationList);
                edgeList.put(label, graphEdge);
            }
        } else {
            logger.error("Cant get types field in json[" + schemaJson + "]");
        }
        return new DefaultGraphSchema(vertexList, edgeList, propNameToIdList);
    }
}

