/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.compiler.schema;

import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultGraphVertex
implements GraphVertex {
    private int labelId;
    private String label;
    private List<GraphProperty> propertyList;
    private List<GraphProperty> primaryKeyList;

    public DefaultGraphVertex(int id, String label, List<GraphProperty> propertyList, List<GraphProperty> primaryKeyList) {
        this.labelId = id;
        this.label = label;
        this.propertyList = propertyList;
        this.primaryKeyList = primaryKeyList;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    @Override
    public List<Integer> getPkPropertyIndices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.labelId;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public GraphProperty getProperty(int propId) {
        for (GraphProperty graphProperty : this.propertyList) {
            if (graphProperty.getId() != propId) continue;
            return graphProperty;
        }
        throw new IllegalArgumentException("Cant get graph property for id " + propId);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        for (GraphProperty graphProperty : this.propertyList) {
            if (!StringUtils.equals((CharSequence)propName, (CharSequence)graphProperty.getName())) continue;
            return graphProperty;
        }
        throw new IllegalArgumentException("Cant get graph property for name " + propName);
    }

    @Override
    public int getVersionId() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("labelId", this.labelId).add("label", (Object)this.label).add("propertyList", this.propertyList).add("primaryKeyList", this.primaryKeyList).toString();
    }

    @Override
    public long getTableId() {
        throw new UnsupportedOperationException();
    }
}

