/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.compiler.schema;

import com.alibaba.graphscope.compiler.api.schema.GraphSchema;
import com.alibaba.graphscope.compiler.api.schema.SchemaFetcher;
import com.alibaba.graphscope.compiler.schema.DefaultGraphSchema;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.lang3.tuple.Pair;

public class JsonFileSchemaFetcher
implements SchemaFetcher {
    private long snapshot;
    private GraphSchema graphSchema;

    public JsonFileSchemaFetcher(String filePath) {
        try {
            String schemaString = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            this.graphSchema = DefaultGraphSchema.buildSchemaFromJson(schemaString);
            this.snapshot = 0x7FFFFFFEL;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Pair<GraphSchema, Long> getSchemaSnapshotPair() {
        return Pair.of((Object)this.graphSchema, (Object)this.snapshot);
    }

    @Override
    public int getPartitionNum() {
        return -1;
    }

    @Override
    public int getVersion() {
        return -1;
    }
}

