/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.client;

import com.alibaba.graphscope.proto.EndpointProto;
import com.alibaba.graphscope.sdkcommon.Protoable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Endpoint
implements Protoable<EndpointProto> {
    private String ip;
    private int port;
    private int gremlinServerPort;
    private int runtimePort = 0;
    private int runtimeCtrlAndAsyncPort;

    public Endpoint(String ip, int port, int gremlinServerPort, int runtimeCtrlPort) {
        this.ip = ip;
        this.port = port;
        this.gremlinServerPort = gremlinServerPort;
        this.runtimeCtrlAndAsyncPort = runtimeCtrlPort;
    }

    @JsonCreator
    public Endpoint(String ip, int port, int gremlinServerPort) {
        this.ip = ip;
        this.port = port;
        this.gremlinServerPort = gremlinServerPort;
        this.runtimeCtrlAndAsyncPort = 0;
    }

    public Endpoint(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.gremlinServerPort = 0;
        this.runtimeCtrlAndAsyncPort = 0;
    }

    public String getIp() {
        return this.ip;
    }

    public void updateIp(String ip) {
        if (StringUtils.isNotEmpty((CharSequence)ip)) {
            this.ip = ip;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getGremlinServerPort() {
        return this.gremlinServerPort;
    }

    public void setGremlinServerPort(int gremlinServerPort) {
        this.gremlinServerPort = gremlinServerPort;
    }

    public int getRuntimeCtrlAndAsyncPort() {
        return this.runtimeCtrlAndAsyncPort;
    }

    public void setRuntimePort(int port) {
        this.runtimePort = port;
    }

    public int getRuntimePort() {
        return this.runtimePort;
    }

    public String toString() {
        return Joiner.on((String)":").join((Object)this.ip, (Object)this.port, new Object[]{this.gremlinServerPort, this.runtimePort, this.runtimeCtrlAndAsyncPort});
    }

    public static Endpoint fromProto(EndpointProto proto) {
        return new Endpoint(proto.getHost(), proto.getPort(), proto.getGremlinServerPort(), proto.getRuntimCtrlAndAsyncPort());
    }

    @Override
    public void fromProto(byte[] data) throws InvalidProtocolBufferException {
        EndpointProto endpointProto = EndpointProto.parseFrom(data);
        this.ip = endpointProto.getHost();
        this.port = endpointProto.getPort();
        this.gremlinServerPort = endpointProto.getGremlinServerPort();
        this.runtimePort = endpointProto.getRuntimePort();
        this.runtimeCtrlAndAsyncPort = endpointProto.getRuntimCtrlAndAsyncPort();
    }

    @Override
    public EndpointProto toProto() {
        EndpointProto.Builder builder = EndpointProto.newBuilder();
        builder.setHost(this.ip);
        builder.setPort(this.port);
        builder.setGremlinServerPort(this.gremlinServerPort);
        builder.setRuntimePort(this.runtimePort);
        builder.setRuntimCtrlAndAsyncPort(this.runtimeCtrlAndAsyncPort);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.port == endpoint.port && this.gremlinServerPort == endpoint.gremlinServerPort && this.runtimePort == endpoint.runtimePort && this.runtimeCtrlAndAsyncPort == endpoint.runtimeCtrlAndAsyncPort && Objects.equals(this.ip, endpoint.ip);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port, this.gremlinServerPort, this.runtimePort, this.runtimeCtrlAndAsyncPort);
    }
}

