/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.common;

import com.alibaba.graphscope.proto.groot.BackupInfoPb;
import com.alibaba.graphscope.proto.groot.GraphDefPb;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BackupInfo {
    private int globalBackupId;
    private long snapshotId;
    private byte[] graphDefBytes;
    private List<Long> walOffsets;
    private Map<Integer, Integer> partitionToBackupId;

    @JsonCreator
    public BackupInfo(@JsonProperty(value="globalBackupId") int globalBackupId, @JsonProperty(value="snapshotId") long snapshotId, @JsonProperty(value="graphDefBytes") byte[] graphDefBytes, @JsonProperty(value="walOffsets") List<Long> walOffsets, @JsonProperty(value="partitionToBackupId") Map<Integer, Integer> partitionToBackupId) {
        this.globalBackupId = globalBackupId;
        this.snapshotId = snapshotId;
        this.graphDefBytes = graphDefBytes;
        this.walOffsets = walOffsets;
        this.partitionToBackupId = partitionToBackupId;
    }

    public int getGlobalBackupId() {
        return this.globalBackupId;
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public byte[] getGraphDefBytes() {
        return this.graphDefBytes;
    }

    public List<Long> getWalOffsets() {
        return this.walOffsets;
    }

    public Map<Integer, Integer> getPartitionToBackupId() {
        return this.partitionToBackupId;
    }

    public static BackupInfo parseProto(BackupInfoPb proto) {
        int globalBackupId = proto.getGlobalBackupId();
        long snapshotId = proto.getSnapshotId();
        List<Long> walOffsets = proto.getWalOffsetsList();
        Map<Integer, Integer> partitionToBackupId = proto.getPartitionToBackupIdMap();
        return new BackupInfo(globalBackupId, snapshotId, proto.getGraphDef().toByteArray(), walOffsets, partitionToBackupId);
    }

    public BackupInfoPb toProto() throws IOException {
        return BackupInfoPb.newBuilder().setGlobalBackupId(this.globalBackupId).setSnapshotId(this.snapshotId).setGraphDef(GraphDefPb.parseFrom(this.graphDefBytes)).addAllWalOffsets(this.walOffsets).putAllPartitionToBackupId(this.partitionToBackupId).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupInfo backupInfo = (BackupInfo)o;
        if (!Arrays.equals(this.graphDefBytes, backupInfo.graphDefBytes)) {
            return false;
        }
        if (!this.walOffsets.equals(backupInfo.walOffsets)) {
            return false;
        }
        if (!this.partitionToBackupId.equals(backupInfo.partitionToBackupId)) {
            return false;
        }
        return this.globalBackupId == backupInfo.globalBackupId && this.snapshotId == backupInfo.snapshotId;
    }

    public int hashCode() {
        return this.globalBackupId;
    }
}

