/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.common;

import com.alibaba.graphscope.proto.DataLoadTargetPb;

public class DataLoadTarget {
    private String label;
    private String srcLabel;
    private String dstLabel;
    private int labelId;
    private int srcLabelId;
    private int dstLabelId;

    private DataLoadTarget(String label, String srcLabel, String dstLabel, int labelId, int srcLabelId, int dstLabelId) {
        this.label = label;
        this.srcLabel = srcLabel;
        this.dstLabel = dstLabel;
        this.labelId = labelId;
        this.srcLabelId = srcLabelId;
        this.dstLabelId = dstLabelId;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSrcLabel() {
        return this.srcLabel;
    }

    public String getDstLabel() {
        return this.dstLabel;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public int getSrcLabelId() {
        return this.srcLabelId;
    }

    public int getDstLabelId() {
        return this.dstLabelId;
    }

    public DataLoadTargetPb toProto() {
        DataLoadTargetPb.Builder builder = DataLoadTargetPb.newBuilder();
        builder.setLabel(this.label);
        builder.setLabelId(this.labelId);
        if (this.srcLabel != null) {
            builder.setSrcLabel(this.srcLabel);
            builder.setSrcLabelId(this.srcLabelId);
        }
        if (this.dstLabel != null) {
            builder.setDstLabel(this.dstLabel);
            builder.setDstLabelId(this.dstLabelId);
        }
        return builder.build();
    }

    public static DataLoadTarget parseProto(DataLoadTargetPb proto) {
        String label = proto.getLabel();
        String srcLabel = proto.getSrcLabel();
        String dstLabel = proto.getDstLabel();
        int labelId = proto.getLabelId();
        int srcLabelId = proto.getSrcLabelId();
        int dstLabelId = proto.getDstLabelId();
        return new DataLoadTarget(label, srcLabel, dstLabel, labelId, srcLabelId, dstLabelId);
    }

    public String toString() {
        return "DataLoadTarget{label='" + this.label + '\'' + ", srcLabel='" + this.srcLabel + '\'' + ", dstLabel='" + this.dstLabel + '\'' + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(DataLoadTarget target) {
        return new Builder(target);
    }

    public static class Builder {
        private String label;
        private int labelId;
        private String srcVertexLabel;
        private int srcVertexLabelId;
        private String dstVertexLabel;
        private int dstVertexLabelId;

        private Builder() {
        }

        private Builder(DataLoadTarget target) {
            this.label = target.getLabel();
            this.labelId = target.getLabelId();
            this.srcVertexLabel = target.getSrcLabel();
            this.srcVertexLabelId = target.getSrcLabelId();
            this.dstVertexLabel = target.getDstLabel();
            this.dstVertexLabelId = target.getDstLabelId();
        }

        public Builder setLabel(String edgeLabel) {
            this.label = edgeLabel;
            return this;
        }

        public Builder setLabelId(int edgeLabelId) {
            this.labelId = edgeLabelId;
            return this;
        }

        public Builder setSrcLabel(String srcVertexLabel) {
            this.srcVertexLabel = srcVertexLabel;
            return this;
        }

        public Builder setSrcLabelId(int srcVertexLabelId) {
            this.srcVertexLabelId = srcVertexLabelId;
            return this;
        }

        public Builder setDstLabel(String dstVertexLabel) {
            this.dstVertexLabel = dstVertexLabel;
            return this;
        }

        public Builder setDstLabelId(int dstVertexLabelId) {
            this.dstVertexLabelId = dstVertexLabelId;
            return this;
        }

        public DataLoadTarget build() {
            return new DataLoadTarget(this.label, this.srcVertexLabel, this.dstVertexLabel, this.labelId, this.srcVertexLabelId, this.dstVertexLabelId);
        }
    }
}

