/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.exception;

import com.alibaba.graphscope.proto.StorageEngine;
import com.alibaba.graphscope.sdkcommon.exception.GrootException;
import com.alibaba.graphscope.sdkcommon.meta.DataType;
import com.alibaba.graphscope.sdkcommon.util.ExceptionUtils;
import java.text.MessageFormat;
import java.util.List;

public class MetaException
extends GrootException {
    public MetaException(ExceptionUtils.ErrorCode code, String msg) {
        super(code, msg);
    }

    public MetaException(String msg) {
        this(ExceptionUtils.ErrorCode.Unknown, msg);
    }

    public static MetaException typeAlreadyExist(String label) {
        String msg = MessageFormat.format("type: {0} is already exist", label);
        return new MetaException(ExceptionUtils.ErrorCode.TypeAlreadyExist, msg);
    }

    public static MetaException typePropertyAlreadyExist(String label, int propertyName) {
        String msg = MessageFormat.format("Property Id: {0} of {1} is already exists.", propertyName, label);
        return new MetaException(ExceptionUtils.ErrorCode.PropertyAlreadyExist, msg);
    }

    public static MetaException propertyAlreadyExist(String propertyName) {
        String msg = MessageFormat.format("PropertyName: {0} is already exists.", propertyName);
        return new MetaException(ExceptionUtils.ErrorCode.PropertyAlreadyExist, msg);
    }

    public static MetaException propertyNotExist(String propertyName) {
        return new MetaException(ExceptionUtils.ErrorCode.PropertyNotExist, "Property: " + propertyName + " is undefined. ");
    }

    public static MetaException propertyExistInType(String propertyName, List<String> labels) {
        return new MetaException(ExceptionUtils.ErrorCode.PropertyExistInType, "Property: " + propertyName + " can not be removed, because it exists in these types: " + labels);
    }

    public static MetaException typeNotFound(String label) {
        String msg = MessageFormat.format("Type: {0} not found.", label);
        return new MetaException(ExceptionUtils.ErrorCode.TypeNotFound, msg);
    }

    public static MetaException typeNotFound(int id) {
        String msg = MessageFormat.format("Type with id :{0} not found.", id);
        return new MetaException(ExceptionUtils.ErrorCode.TypeNotFound, msg);
    }

    public static RuntimeException asRuntimeException(ExceptionUtils.ErrorCode code, String msg) {
        throw new RuntimeException(new MetaException(code, msg));
    }

    public static MetaException relationShipAlreadyExist(String srcLabel, String edgeLabel, String dstLabel) {
        String msg = MessageFormat.format("relationship: with srcLabel :{0}, edgeLabel: {1}, dstLabel: {2} is already exist", srcLabel, edgeLabel, dstLabel);
        return new MetaException(ExceptionUtils.ErrorCode.RelationShipAlreadyExist, msg);
    }

    public static MetaException relationShipNotExist(String srcLabel, String edgeLabel, String dstLabel) {
        String msg = MessageFormat.format("relationship: with srcLabel :{0}, edgeLabel: {1}, dstLabel: {2} is not exist", srcLabel, edgeLabel, dstLabel);
        return new MetaException(ExceptionUtils.ErrorCode.RelationShipNotExist, msg);
    }

    public static MetaException dropTypeException(String label) {
        String msg = MessageFormat.format("drop type: {0} exception ,because of exist relationship", label);
        return new MetaException(ExceptionUtils.ErrorCode.RelationShipExistWithType, msg);
    }

    public static MetaException indexAlreadyExist(String name) {
        String msg = MessageFormat.format("Index is Already exist: {0}", name);
        return new MetaException(msg);
    }

    public static MetaException indexNotExist(String name) {
        String msg = MessageFormat.format("Index is not exist: {0}", name);
        return new MetaException(msg);
    }

    public static MetaException indexShouldNotUsedOnVertex(String indexName) {
        String msg = MessageFormat.format("Index can be used only on edge type: {0}", indexName);
        return new MetaException(ExceptionUtils.ErrorCode.IndexCanBeUsedOnlyOnEdge, msg);
    }

    public static GrootException indexTypeMustBeUnique(String name) {
        String msg = MessageFormat.format("Index Type Must be unique in one Vertex/Edge: {0}", name);
        return new MetaException(ExceptionUtils.ErrorCode.IndexTypeMustUnique, msg);
    }

    public static GrootException vertexPrimaryChanged() {
        return new MetaException(ExceptionUtils.ErrorCode.InvalidTypeChanged, "Can not change the primary key of Vertex Type");
    }

    public static GrootException storageEngineChanged(StorageEngine from, StorageEngine to) {
        return new MetaException(ExceptionUtils.ErrorCode.InvalidTypeChanged, "Can not change Storage Engine from " + from.name() + " to " + to.name());
    }

    public static MetaException propertyTypeChanged(String propertyName) {
        return new MetaException(ExceptionUtils.ErrorCode.InvalidTypeChanged, "Property: " + propertyName + " type can not be changed");
    }

    public static GrootException dimensionTypeChanged(boolean from, boolean to) {
        return new MetaException(ExceptionUtils.ErrorCode.InvalidTypeChanged, "Can not change dimensionType from " + MetaException.wrapDimension(from) + " to " + MetaException.wrapDimension(to));
    }

    public static GrootException typeChanged() {
        return new MetaException(ExceptionUtils.ErrorCode.InvalidTypeChanged, "Can not change Vertex Or Edge's type and label");
    }

    public static GrootException dataTypeNotValid(DataType dataType) {
        return new MetaException(ExceptionUtils.ErrorCode.DataTypeNotValid, "unSupported data type: " + dataType.toString());
    }

    private static String wrapDimension(boolean isDimension) {
        return isDimension ? "dimension" : "not dimension";
    }
}

