/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.meta;

import com.alibaba.graphscope.sdkcommon.exception.GrootException;
import com.alibaba.graphscope.sdkcommon.meta.DataTypeDeserializer;
import com.alibaba.graphscope.sdkcommon.meta.DataTypeSerializer;
import com.alibaba.graphscope.sdkcommon.meta.InternalDataType;
import com.alibaba.graphscope.sdkcommon.util.ExceptionUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize(using=DataTypeSerializer.class)
@JsonDeserialize(using=DataTypeDeserializer.class)
public class DataType {
    public static final DataType BOOL = new DataType(InternalDataType.BOOL);
    public static final DataType CHAR = new DataType(InternalDataType.CHAR);
    public static final DataType SHORT = new DataType(InternalDataType.SHORT);
    public static final DataType INT = new DataType(InternalDataType.INT);
    public static final DataType LONG = new DataType(InternalDataType.LONG);
    public static final DataType FLOAT = new DataType(InternalDataType.FLOAT);
    public static final DataType DOUBLE = new DataType(InternalDataType.DOUBLE);
    public static final DataType BYTES = new DataType(InternalDataType.BYTES);
    public static final DataType STRING = new DataType(InternalDataType.STRING);
    public static final DataType DATE = new DataType(InternalDataType.DATE);
    @JsonProperty
    private String expression;
    @JsonProperty
    private InternalDataType type;

    public DataType(InternalDataType internalDataType) {
        this.type = internalDataType;
    }

    public static DataType toDataType(int i) {
        return new DataType(InternalDataType.values()[i]);
    }

    public static DataType valueOf(String typeName) {
        return new DataType(InternalDataType.valueOf(typeName));
    }

    public boolean isInt() {
        return this.type == InternalDataType.SHORT || this.type == InternalDataType.INT || this.type == InternalDataType.LONG;
    }

    public void setExpression(String expression) throws GrootException {
        if (this.isPrimitiveType()) {
            this.expression = null;
            return;
        }
        if (!this.isValid(expression)) {
            throw new GrootException(ExceptionUtils.ErrorCode.DataTypeNotValid, "expression is not valid, subType must be primitiveTypes: " + InternalDataType.primitiveTypes.toString());
        }
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public InternalDataType getType() {
        return this.type;
    }

    @JsonIgnore
    public String name() {
        return this.getType().name();
    }

    @JsonValue
    public String getJson() {
        return this.type.name() + (StringUtils.isEmpty((CharSequence)this.expression) ? "" : "<" + this.expression + ">");
    }

    public boolean isValid(String expression) {
        if (this.type == InternalDataType.SET || this.type == InternalDataType.LIST) {
            return this.validSubTypes(expression);
        }
        if (this.type == InternalDataType.MAP) {
            String s = expression.replaceAll("[ ]*,[ ]*", ",");
            String[] split = s.split(",");
            if (split.length < 2) {
                return false;
            }
            return this.validSubTypes(split[0]) && this.validSubTypes(split[1]);
        }
        return true;
    }

    public boolean validSubTypes(String expression) {
        return InternalDataType.primitiveTypes.contains(expression.trim().toUpperCase());
    }

    public boolean isPrimitiveType() {
        return this.type != InternalDataType.LIST && this.type != InternalDataType.MAP && this.type != InternalDataType.SET;
    }

    public boolean isFixedLen() {
        switch (this.type) {
            case BOOL: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public int getFixedSize() {
        switch (this.type) {
            case BOOL: 
            case CHAR: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case LONG: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new RuntimeException("unreachable!");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType dataType = (DataType)o;
        return Objects.equal((Object)this.getExpression(), (Object)dataType.getExpression()) && this.getType() == dataType.getType();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getExpression(), this.getType()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).add("type", (Object)this.type).toString();
    }
}

