/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.meta;

import com.alibaba.graphscope.sdkcommon.exception.GrootException;
import com.alibaba.graphscope.sdkcommon.meta.DataType;
import com.alibaba.graphscope.sdkcommon.meta.InternalDataType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class DataTypeDeserializer
extends StdDeserializer<DataType> {
    public DataTypeDeserializer() {
        this(null);
    }

    public DataTypeDeserializer(Class<?> vc) {
        super(vc);
    }

    public DataType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String data = p.getValueAsString();
        try {
            if (data.startsWith("LIST<")) {
                DataType ret = new DataType(InternalDataType.LIST);
                ret.setExpression(data.substring("LIST<".length(), data.length() - 1));
                return ret;
            }
            if (data.startsWith("S<")) {
                DataType ret = new DataType(InternalDataType.SET);
                ret.setExpression(data.substring(2, data.length() - 1));
                return ret;
            }
            if (!data.startsWith("M<")) {
                DataType ret = new DataType(InternalDataType.valueOf(data.toUpperCase()));
                return ret;
            }
        }
        catch (GrootException ex) {
            throw new IOException(ex);
        }
        return null;
    }
}

