/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.meta;

import com.alibaba.graphscope.sdkcommon.meta.DataType;
import com.alibaba.graphscope.sdkcommon.meta.InternalDataType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public class DataTypeSerializer
extends StdSerializer<DataType> {
    public DataTypeSerializer() {
        super(DataType.class, true);
    }

    public void serialize(DataType value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.isPrimitiveType()) {
            gen.writeString(value.name());
        } else {
            String prefix = "";
            if (value.getType().equals((Object)InternalDataType.LIST)) {
                prefix = "LIST";
            } else if (value.getType().equals((Object)InternalDataType.SET)) {
                prefix = "S";
            } else if (value.getType().equals((Object)InternalDataType.MAP)) {
                prefix = "M";
            } else {
                throw new IOException(String.format("unknown data type: %s", value.toString()));
            }
            gen.writeString(String.format("%s<%s>", prefix, value.getExpression()));
        }
    }
}

