/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema;

import com.alibaba.graphscope.compiler.api.schema.EdgeRelation;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.alibaba.graphscope.sdkcommon.schema.PropertyDef;
import com.alibaba.graphscope.sdkcommon.schema.TypeDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GraphEdgeImpl
implements GraphEdge {
    private TypeDef typeDef;
    private List<EdgeRelation> edgeRelations;
    private PrimaryKeyConstraint primaryKeyConstraint;

    public GraphEdgeImpl(TypeDef typeDef, List<EdgeRelation> edgeRelations) {
        this.typeDef = typeDef;
        this.edgeRelations = edgeRelations;
        List<Integer> pkIdxs = typeDef.getPkIdxs();
        if (pkIdxs != null && pkIdxs.size() > 0) {
            List<PropertyDef> properties = typeDef.getProperties();
            ArrayList<String> pkNameList = new ArrayList<String>(pkIdxs.size());
            for (Integer pkIdx : pkIdxs) {
                PropertyDef propertyDef = properties.get(pkIdx);
                pkNameList.add(propertyDef.getName());
            }
            this.primaryKeyConstraint = new PrimaryKeyConstraint(pkNameList);
        }
    }

    @Override
    public List<EdgeRelation> getRelationList() {
        return this.edgeRelations;
    }

    @Override
    public String getLabel() {
        return this.typeDef.getLabel();
    }

    @Override
    public int getLabelId() {
        return this.typeDef.getLabelId();
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.typeDef.getPropertyList();
    }

    @Override
    public GraphProperty getProperty(int propId) {
        return this.typeDef.getProperty(propId);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        return this.typeDef.getProperty(propName);
    }

    @Override
    public int getVersionId() {
        return this.typeDef.getVersionId();
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    @Override
    public List<Integer> getPkPropertyIndices() {
        return null;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdgeImpl graphEdge = (GraphEdgeImpl)o;
        return Objects.equals(this.typeDef, graphEdge.typeDef) && Objects.equals(this.edgeRelations, graphEdge.edgeRelations) && Objects.equals(this.primaryKeyConstraint, graphEdge.primaryKeyConstraint);
    }

    public int hashCode() {
        return Objects.hash(this.typeDef, this.edgeRelations, this.primaryKeyConstraint);
    }
}

