/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphSchema;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.sdkcommon.schema.mapper.DefaultGraphSchema;
import com.alibaba.graphscope.sdkcommon.schema.mapper.EdgeTypeMapper;
import com.alibaba.graphscope.sdkcommon.schema.mapper.SchemaElementMapper;
import com.alibaba.graphscope.sdkcommon.schema.mapper.VertexTypeMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GraphSchemaMapper {
    private List<SchemaElementMapper> types;
    private int version;

    public List<SchemaElementMapper> getTypes() {
        return this.types;
    }

    public int getVersion() {
        return this.version;
    }

    public GraphSchema toGraphSchema() {
        DefaultGraphSchema graphSchema = new DefaultGraphSchema();
        HashMap vertexTypeMap = Maps.newHashMap();
        for (SchemaElementMapper elementMapper : this.types) {
            if (!(elementMapper instanceof VertexTypeMapper)) continue;
            GraphVertex graphVertex = ((VertexTypeMapper)elementMapper).toVertexType();
            graphSchema.createVertexType(graphVertex);
            vertexTypeMap.put(graphVertex.getLabel(), graphVertex);
        }
        for (SchemaElementMapper elementMapper : this.types) {
            if (!(elementMapper instanceof EdgeTypeMapper)) continue;
            GraphEdge graphEdge = ((EdgeTypeMapper)elementMapper).toEdgeType(vertexTypeMap);
            graphSchema.createEdgeType(graphEdge);
        }
        return graphSchema;
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("convert graph schema to json failed", e);
        }
    }

    public static GraphSchemaMapper parseFromSchema(GraphSchema schema) {
        GraphSchemaMapper schemaMapper = new GraphSchemaMapper();
        schemaMapper.version = schema.getVersion();
        schemaMapper.types = Lists.newArrayList();
        for (GraphVertex graphVertex : schema.getVertexList()) {
            schemaMapper.types.add(VertexTypeMapper.parseFromVertexType(graphVertex));
        }
        for (GraphEdge graphEdge : schema.getEdgeList()) {
            schemaMapper.types.add(EdgeTypeMapper.parseFromEdgeType(graphEdge));
        }
        return schemaMapper;
    }

    public static GraphSchemaMapper parseFromJson(String schemaJson) {
        JSONObject jsonObject = JSONObject.parseObject((String)schemaJson);
        GraphSchemaMapper graphSchema = new GraphSchemaMapper();
        Integer version = jsonObject.getInteger("version");
        graphSchema.version = null != version ? version : 0;
        graphSchema.types = Lists.newArrayList();
        JSONArray typeArray = jsonObject.getJSONArray("types");
        for (int i = 0; i < typeArray.size(); ++i) {
            JSONObject typeObject = typeArray.getJSONObject(i);
            String type = typeObject.getString("type");
            if (StringUtils.equals((CharSequence)"VERTEX", (CharSequence)StringUtils.upperCase((String)type))) {
                VertexTypeMapper vertexTypeMapper = (VertexTypeMapper)typeObject.toJavaObject(VertexTypeMapper.class);
                graphSchema.types.add(vertexTypeMapper);
                continue;
            }
            EdgeTypeMapper edgeTypeMapper = (EdgeTypeMapper)typeObject.toJavaObject(EdgeTypeMapper.class);
            graphSchema.types.add(edgeTypeMapper);
        }
        return graphSchema;
    }
}

